/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.authorization;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Allows to perform a logical 'and' between several authorizations
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.AndAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.AndAuthorization.class)
public class AndAuthorization extends io.vertx.rxjava.ext.auth.authorization.Authorization {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AndAuthorization that = (AndAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AndAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new AndAuthorization((io.vertx.ext.auth.authorization.AndAuthorization) obj),
    AndAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.AndAuthorization delegate;
  
  public AndAuthorization(io.vertx.ext.auth.authorization.AndAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public AndAuthorization(Object delegate) {
    super((io.vertx.ext.auth.authorization.AndAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.authorization.AndAuthorization)delegate;
  }

  public io.vertx.ext.auth.authorization.AndAuthorization getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.ext.auth.authorization.Authorization> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.ext.auth.authorization.Authorization>(o1 -> io.vertx.rxjava.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)o1), o1 -> o1.getDelegate());

  public static io.vertx.rxjava.ext.auth.authorization.AndAuthorization create() { 
    io.vertx.rxjava.ext.auth.authorization.AndAuthorization ret = io.vertx.rxjava.ext.auth.authorization.AndAuthorization.newInstance((io.vertx.ext.auth.authorization.AndAuthorization)io.vertx.ext.auth.authorization.AndAuthorization.create());
    return ret;
  }

  public java.util.List<io.vertx.rxjava.ext.auth.authorization.Authorization> getAuthorizations() { 
    java.util.List<io.vertx.rxjava.ext.auth.authorization.Authorization> ret = delegate.getAuthorizations().stream().map(elt -> io.vertx.rxjava.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)elt)).collect(Collectors.toList());
    return ret;
  }

  public io.vertx.rxjava.ext.auth.authorization.AndAuthorization addAuthorization(io.vertx.rxjava.ext.auth.authorization.Authorization authorization) { 
    io.vertx.rxjava.ext.auth.authorization.AndAuthorization ret = io.vertx.rxjava.ext.auth.authorization.AndAuthorization.newInstance((io.vertx.ext.auth.authorization.AndAuthorization)delegate.addAuthorization(authorization.getDelegate()));
    return ret;
  }

  public static AndAuthorization newInstance(io.vertx.ext.auth.authorization.AndAuthorization arg) {
    return arg != null ? new AndAuthorization(arg) : null;
  }

}
