/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.authentication;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * User-facing interface for authenticating users.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authentication.AuthenticationProvider original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authentication.AuthenticationProvider.class)
public class AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthenticationProvider that = (AuthenticationProvider) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AuthenticationProvider> __TYPE_ARG = new TypeArg<>(    obj -> new AuthenticationProvider((io.vertx.ext.auth.authentication.AuthenticationProvider) obj),
    AuthenticationProvider::getDelegate
  );

  private final io.vertx.ext.auth.authentication.AuthenticationProvider delegate;
  
  public AuthenticationProvider(io.vertx.ext.auth.authentication.AuthenticationProvider delegate) {
    this.delegate = delegate;
  }

  public AuthenticationProvider(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authentication.AuthenticationProvider)delegate;
  }

  public io.vertx.ext.auth.authentication.AuthenticationProvider getDelegate() {
    return delegate;
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a  object is passed to the handler in an .
   * The user object can then be used for authorisation.
   * @param credentials The credentials
   * @param resultHandler The result handler
   */
  @Deprecated()
  public void authenticate(io.vertx.core.json.JsonObject credentials, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.auth.User>> resultHandler) { 
    delegate.authenticate(credentials, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.auth.User.newInstance((io.vertx.ext.auth.User)event))));
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a  object is passed to the handler in an .
   * The user object can then be used for authorisation.
   * @param credentials The credentials
   */
  @Deprecated()
  public void authenticate(io.vertx.core.json.JsonObject credentials) {
    authenticate(credentials, ar -> { });
  }

    /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a  object is passed to the handler in an .
   * The user object can then be used for authorisation.
   * @param credentials The credentials
   * @return 
   */
  @Deprecated()
  public rx.Single<io.vertx.rxjava.ext.auth.User> rxAuthenticate(io.vertx.core.json.JsonObject credentials) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      authenticate(credentials, fut);
    }));
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a Credentials object containing information for authenticating the user.
   * What this actually contains depends on the specific implementation.
   *
   * If the user is successfully authenticated a  object is passed to the handler in an .
   * The user object can then be used for authorisation.
   * @param credentials The credentials
   * @param resultHandler The result handler
   */
  public void authenticate(io.vertx.ext.auth.authentication.Credentials credentials, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.auth.User>> resultHandler) { 
    delegate.authenticate(credentials, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.auth.User.newInstance((io.vertx.ext.auth.User)event))));
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a Credentials object containing information for authenticating the user.
   * What this actually contains depends on the specific implementation.
   *
   * If the user is successfully authenticated a  object is passed to the handler in an .
   * The user object can then be used for authorisation.
   * @param credentials The credentials
   */
  public void authenticate(io.vertx.ext.auth.authentication.Credentials credentials) {
    authenticate(credentials, ar -> { });
  }

    /**
   * Authenticate a user.
   * <p>
   * The first argument is a Credentials object containing information for authenticating the user.
   * What this actually contains depends on the specific implementation.
   *
   * If the user is successfully authenticated a  object is passed to the handler in an .
   * The user object can then be used for authorisation.
   * @param credentials The credentials
   * @return 
   */
  public rx.Single<io.vertx.rxjava.ext.auth.User> rxAuthenticate(io.vertx.ext.auth.authentication.Credentials credentials) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      authenticate(credentials, fut);
    }));
  }

  public static AuthenticationProvider newInstance(io.vertx.ext.auth.authentication.AuthenticationProvider arg) {
    return arg != null ? new AuthenticationProvider(arg) : null;
  }

}
