/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * User-facing interface for authenticating users.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.AuthProvider original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.AuthProvider.class)
public class AuthProvider extends io.vertx.rxjava.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthProvider that = (AuthProvider) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AuthProvider> __TYPE_ARG = new TypeArg<>(    obj -> new AuthProvider((io.vertx.ext.auth.AuthProvider) obj),
    AuthProvider::getDelegate
  );

  private final io.vertx.ext.auth.AuthProvider delegate;
  
  public AuthProvider(io.vertx.ext.auth.AuthProvider delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public AuthProvider(Object delegate) {
    super((io.vertx.ext.auth.AuthProvider)delegate);
    this.delegate = (io.vertx.ext.auth.AuthProvider)delegate;
  }

  public io.vertx.ext.auth.AuthProvider getDelegate() {
    return delegate;
  }

  public static AuthProvider newInstance(io.vertx.ext.auth.AuthProvider arg) {
    return arg != null ? new AuthProvider(arg) : null;
  }

}
