/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.streams;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * Represents a stream of data that can be written to.
 * <p>
 * Any class that implements this interface can be used by a {@link io.vertx.rxjava.core.streams.Pipe} to pipe data from a <code>ReadStream</code>
 * to it.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.WriteStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.streams.WriteStream.class)
public interface WriteStream<T> extends io.vertx.rxjava.core.streams.StreamBase {

  io.vertx.core.streams.WriteStream getDelegate();

  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.WriteStream<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(T data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(T data);

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWrite(T data);

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   */
  public void end();

    /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd();

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(T data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(T data);

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd(T data);

  /**
   * Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
   * if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
   * {@link io.vertx.rxjava.core.streams.Pipe} to provide flow control.
   * <p/>
   * The value is defined by the implementation of the stream, e.g in bytes for a
   * {@link io.vertx.rxjava.core.net.NetSocket}, etc...
   * @param maxSize the max size of the write stream
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.WriteStream<T> setWriteQueueMaxSize(int maxSize);

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.streams.WriteStream#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull();

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.rxjava.core.streams.Pipe} for an example of this being used.
   *
   * <p> The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.WriteStream<T> drainHandler(io.vertx.core.Handler<java.lang.Void> handler);

  public static <T> WriteStream<T> newInstance(io.vertx.core.streams.WriteStream arg) {
    return arg != null ? new WriteStreamImpl<T>(arg) : null;
  }

  public static <T> WriteStream<T> newInstance(io.vertx.core.streams.WriteStream arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new WriteStreamImpl<T>(arg, __typeArg_T) : null;
  }

}

class WriteStreamImpl<T> implements WriteStream<T> {
  private final io.vertx.core.streams.WriteStream<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public WriteStreamImpl(io.vertx.core.streams.WriteStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public WriteStreamImpl(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.streams.WriteStream)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.streams.WriteStream getDelegate() {
    return delegate;
  }

  private WriteStreamSubscriber<T> subscriber;

  public synchronized WriteStreamSubscriber<T> toSubscriber() {
    if (subscriber == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.unwrap;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.WriteStream<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(T data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.write(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(T data) {
    write(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWrite(T data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   */
  public void end() {
    end(ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(T data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(T data) {
    end(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd(T data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
   * if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
   * {@link io.vertx.rxjava.core.streams.Pipe} to provide flow control.
   * <p/>
   * The value is defined by the implementation of the stream, e.g in bytes for a
   * {@link io.vertx.rxjava.core.net.NetSocket}, etc...
   * @param maxSize the max size of the write stream
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.WriteStream<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.streams.WriteStream#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.rxjava.core.streams.Pipe} for an example of this being used.
   *
   * <p> The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.WriteStream<T> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

}
