/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.parsetools;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A helper class which allows you to easily parse protocols which are delimited by a sequence of bytes, or fixed
 * size records.
 * <p>
 * Instances of this class take as input {@link io.vertx.rxjava.core.buffer.Buffer} instances containing raw bytes,
 * and output records.
 * <p>
 * For example, if I had a simple ASCII text protocol delimited by '\n' and the input was the following:
 * <p>
 * <pre>
 * buffer1:HELLO\nHOW ARE Y
 * buffer2:OU?\nI AM
 * buffer3: DOING OK
 * buffer4:\n
 * </pre>
 * Then the output would be:<p>
 * <pre>
 * buffer1:HELLO
 * buffer2:HOW ARE YOU?
 * buffer3:I AM DOING OK
 * </pre>
 * Instances of this class can be changed between delimited mode and fixed size record mode on the fly as
 * individual records are read, this allows you to parse protocols where, for example, the first 5 records might
 * all be fixed size (of potentially different sizes), followed by some delimited records, followed by more fixed
 * size records.
 * <p>
 * Instances of this class can't currently be used for protocols where the text is encoded with something other than
 * a 1-1 byte-char mapping.
 * <p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.RecordParser original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.parsetools.RecordParser.class)
public class RecordParser implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer>, Handler<io.vertx.rxjava.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RecordParser that = (RecordParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RecordParser> __TYPE_ARG = new TypeArg<>(    obj -> new RecordParser((io.vertx.core.parsetools.RecordParser) obj),
    RecordParser::getDelegate
  );

  private final io.vertx.core.parsetools.RecordParser delegate;
  
  public RecordParser(io.vertx.core.parsetools.RecordParser delegate) {
    this.delegate = delegate;
  }

  public RecordParser(Object delegate) {
    this.delegate = (io.vertx.core.parsetools.RecordParser)delegate;
  }

  public io.vertx.core.parsetools.RecordParser getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.buffer.Buffer> observable;

  public synchronized Observable<io.vertx.rxjava.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  public void setOutput(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> output) { 
    delegate.setOutput(new io.vertx.lang.rx.DelegatingHandler<>(output, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newDelimited} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param delim the initial delimiter string
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newDelimited(java.lang.String delim, io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> output) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim, new io.vertx.lang.rx.DelegatingHandler<>(output, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newDelimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.rxjava.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param delim the initial delimiter string
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newDelimited(java.lang.String delim, io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim, stream.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newDelimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.rxjava.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param delim the initial delimiter string
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newDelimited(java.lang.String delim, rx.Observable<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim, io.vertx.rx.java.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Create a new <code>RecordParser</code> instance, initially in delimited mode, and where the delimiter can be represented
   * by the String <code></code> delim endcoded in latin-1 . Don't use this if your String contains other than latin-1 characters.
   * <p>
   * <code>output</code> Will receive whole records which have been parsed.
   * @param delim the initial delimiter string
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newDelimited(java.lang.String delim) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim));
    return ret;
  }

  /**
   * Create a new <code>RecordParser</code> instance, initially in delimited mode, and where the delimiter can be represented
   * by the <code>Buffer</code> delim.
   * <p>
   * @param delim the initial delimiter buffer
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newDelimited(io.vertx.rxjava.core.buffer.Buffer delim) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newDelimited} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param delim the initial delimiter buffer
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newDelimited(io.vertx.rxjava.core.buffer.Buffer delim, io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> output) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(output, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newDelimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.rxjava.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param delim the initial delimiter buffer
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newDelimited(io.vertx.rxjava.core.buffer.Buffer delim, io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), stream.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newDelimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.rxjava.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param delim the initial delimiter buffer
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newDelimited(io.vertx.rxjava.core.buffer.Buffer delim, rx.Observable<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), io.vertx.rx.java.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Create a new <code>RecordParser</code> instance, initially in fixed size mode, and where the record size is specified
   * by the <code>size</code> parameter.
   * <p>
   * <code>output</code> Will receive whole records which have been parsed.
   * @param size the initial record size
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newFixed(int size) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newFixed(size));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newFixed} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param size the initial record size
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newFixed(int size, io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> output) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newFixed(size, new io.vertx.lang.rx.DelegatingHandler<>(output, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newFixed} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.rxjava.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param size the initial record size
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newFixed(int size, io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newFixed(size, stream.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.parsetools.RecordParser#newFixed} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.rxjava.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param size the initial record size
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.RecordParser newFixed(int size, rx.Observable<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.core.parsetools.RecordParser ret = io.vertx.rxjava.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newFixed(size, io.vertx.rx.java.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Flip the parser into delimited mode, and where the delimiter can be represented
   * by the String <code>delim</code> encoded in latin-1 . Don't use this if your String contains other than latin-1 characters.
   * <p>
   * This method can be called multiple times with different values of delim while data is being parsed.
   * @param delim the new delimeter
   */
  public void delimitedMode(java.lang.String delim) { 
    delegate.delimitedMode(delim);
  }

  /**
   * Flip the parser into delimited mode, and where the delimiter can be represented
   * by the delimiter <code>delim</code>.
   * <p>
   * This method can be called multiple times with different values of delim while data is being parsed.
   * @param delim the new delimiter
   */
  public void delimitedMode(io.vertx.rxjava.core.buffer.Buffer delim) { 
    delegate.delimitedMode(delim.getDelegate());
  }

  /**
   * Flip the parser into fixed size mode, where the record size is specified by <code>size</code> in bytes.
   * <p>
   * This method can be called multiple times with different values of size while data is being parsed.
   * @param size the new record size
   */
  public void fixedSizeMode(int size) { 
    delegate.fixedSizeMode(size);
  }

  /**
   * Set the maximum allowed size for a record when using the delimited mode.
   * The delimiter itself does not count for the record size.
   * <p>
   * If a record is longer than specified, an {@link java.lang.IllegalStateException} will be thrown.
   * @param size the maximum record size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.parsetools.RecordParser maxRecordSize(int size) { 
    delegate.maxRecordSize(size);
    return this;
  }

  /**
   * This method is called to provide the parser with data.
   * @param buffer a chunk of data
   */
  public void handle(io.vertx.rxjava.core.buffer.Buffer buffer) { 
    delegate.handle(buffer.getDelegate());
  }

  public io.vertx.rxjava.core.parsetools.RecordParser exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.core.parsetools.RecordParser handler(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.rxjava.core.parsetools.RecordParser pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.core.parsetools.RecordParser fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.core.parsetools.RecordParser resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.core.parsetools.RecordParser endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public static RecordParser newInstance(io.vertx.core.parsetools.RecordParser arg) {
    return arg != null ? new RecordParser(arg) : null;
  }

}
