/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.parsetools;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A JSON event emited by the {@link io.vertx.rxjava.core.parsetools.JsonParser}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.JsonEvent original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.parsetools.JsonEvent.class)
public class JsonEvent {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonEvent that = (JsonEvent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JsonEvent> __TYPE_ARG = new TypeArg<>(    obj -> new JsonEvent((io.vertx.core.parsetools.JsonEvent) obj),
    JsonEvent::getDelegate
  );

  private final io.vertx.core.parsetools.JsonEvent delegate;
  
  public JsonEvent(io.vertx.core.parsetools.JsonEvent delegate) {
    this.delegate = delegate;
  }

  public JsonEvent(Object delegate) {
    this.delegate = (io.vertx.core.parsetools.JsonEvent)delegate;
  }

  public io.vertx.core.parsetools.JsonEvent getDelegate() {
    return delegate;
  }

  /**
   * @return the type of the event
   */
  public io.vertx.core.parsetools.JsonEventType type() { 
    io.vertx.core.parsetools.JsonEventType ret = delegate.type();
    return ret;
  }

  /**
   * @return the name of the field when the event is emitted as a JSON object member
   */
  public java.lang.String fieldName() { 
    java.lang.String ret = delegate.fieldName();
    return ret;
  }

  /**
   * @return the json value for  events
   */
  public java.lang.Object value() { 
    java.lang.Object ret = (Object) delegate.value();
    return ret;
  }

  /**
   * @return true when the JSON value is a number
   */
  public boolean isNumber() { 
    boolean ret = delegate.isNumber();
    return ret;
  }

  /**
   * @return the <code>Integer</code> value or <code>null</code> if the event has no JSON value
   */
  public java.lang.Integer integerValue() { 
    java.lang.Integer ret = delegate.integerValue();
    return ret;
  }

  /**
   * @return the <code>Long</code> value or <code>null</code> if the event has no JSON value
   */
  public java.lang.Long longValue() { 
    java.lang.Long ret = delegate.longValue();
    return ret;
  }

  /**
   * @return the <code>Float</code> value or <code>null</code> if the event has no JSON value
   */
  public java.lang.Float floatValue() { 
    java.lang.Float ret = delegate.floatValue();
    return ret;
  }

  /**
   * @return the <code>Double</code> value or <code>null</code> if the event has no JSON value
   */
  public java.lang.Double doubleValue() { 
    java.lang.Double ret = delegate.doubleValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a boolean
   */
  public boolean isBoolean() { 
    boolean ret = delegate.isBoolean();
    return ret;
  }

  /**
   * @return the <code>Boolean</code> value or <code>null</code> if the event has no JSON value
   */
  public java.lang.Boolean booleanValue() { 
    java.lang.Boolean ret = delegate.booleanValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a string
   */
  public boolean isString() { 
    boolean ret = delegate.isString();
    return ret;
  }

  /**
   * @return the string value or <code>null</code> if the event has no JSON value
   */
  public java.lang.String stringValue() { 
    java.lang.String ret = delegate.stringValue();
    return ret;
  }

  /**
   * Return the binary value.
   * <p>
   * JSON itself has no notion of a binary, this extension complies to the RFC-7493, so this method assumes there is a
   * String value with the key and it contains a Base64 encoded binary, which it decodes if found and returns.
   * @return the binary value or <code>null</code> if the event has no JSON value
   */
  public io.vertx.rxjava.core.buffer.Buffer binaryValue() { 
    io.vertx.rxjava.core.buffer.Buffer ret = io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.binaryValue());
    return ret;
  }

  /**
   * @return true when the JSON value is null
   */
  public boolean isNull() { 
    boolean ret = delegate.isNull();
    return ret;
  }

  /**
   * @return true when the JSON value is a JSON object
   */
  public boolean isObject() { 
    boolean ret = delegate.isObject();
    return ret;
  }

  /**
   * @return the JSON object value or <code>null</code> if the event has no JSON value
   */
  public io.vertx.core.json.JsonObject objectValue() { 
    io.vertx.core.json.JsonObject ret = delegate.objectValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a JSON array
   */
  public boolean isArray() { 
    boolean ret = delegate.isArray();
    return ret;
  }

  /**
   * @return the JSON array value or <code>null</code> if the event has no JSON value
   */
  public io.vertx.core.json.JsonArray arrayValue() { 
    io.vertx.core.json.JsonArray ret = delegate.arrayValue();
    return ret;
  }

  /**
   * Decodes and returns the current value as the specified <code>type</code>.
   * @param type the type to decode the value to
   * @return the decoded value
   */
  public <T> T mapTo(java.lang.Class<T> type) { 
    T ret = (T)TypeArg.of(type).wrap(delegate.mapTo(io.vertx.lang.rxjava.Helper.unwrap(type)));
    return ret;
  }

  /**
   * Return the <code>Instant</code> value.
   * <p>
   * JSON itself has no notion of a temporal types, this extension complies to the RFC-7493, so this method assumes
   * there is a String value with the key and it contains an ISO 8601 encoded date and time format
   * such as "2017-04-03T10:25:41Z", which it decodes if found and returns.
   * @return the <code>Instant</code> value or <code>null</code> if the event has no JSON value
   */
  public java.time.Instant instantValue() { 
    java.time.Instant ret = delegate.instantValue();
    return ret;
  }

  /**
   * Decodes and returns the current value as the specified <code>type</code>.
   * @param type the type to decode the value to
   * @return the decoded value
   */
  public <T> T mapTo(com.fasterxml.jackson.core.type.TypeReference<T> type) { 
    T ret = (T) delegate.mapTo(type);
    return ret;
  }

  public static JsonEvent newInstance(io.vertx.core.parsetools.JsonEvent arg) {
    return arg != null ? new JsonEvent(arg) : null;
  }

}
