/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.net;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a TCP server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetServer.class)
public class NetServer implements io.vertx.rxjava.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  public NetServer(Object delegate) {
    this.delegate = (io.vertx.core.net.NetServer)delegate;
  }

  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.core.net.NetSocket> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.net.NetSocket>(o1 -> io.vertx.rxjava.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the connect stream for this server. The server can only have at most one handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.rxjava.core.net.NetSocket} and passes it to the
   * connect stream .
   * @return the connect stream
   */
  @Deprecated()
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.net.NetSocket> connectStream() { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.net.NetSocket> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.connectStream(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.rxjava.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer connectHandler(io.vertx.core.Handler<io.vertx.rxjava.core.net.NetSocket> handler) { 
    io.vertx.rxjava.core.net.NetServer ret = io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.connectHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.net.NetServer>> listenHandler) { 
    delegate.listen(new io.vertx.lang.rx.DelegatingHandler<>(listenHandler, ar -> ar.map(event -> io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)event))));
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen() {
    return 
listen(ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.net.NetServer> rxListen() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listen(fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, host, new io.vertx.lang.rx.DelegatingHandler<>(listenHandler, ar -> ar.map(event -> io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)event))));
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(int port, java.lang.String host) {
    return 
listen(port, host, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.net.NetServer> rxListen(int port, java.lang.String host) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listen(port, host, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(int port, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, new io.vertx.lang.rx.DelegatingHandler<>(listenHandler, ar -> ar.map(event -> io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)event))));
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(int port) {
    return 
listen(port, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.net.NetServer> rxListen(int port) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listen(port, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(io.vertx.rxjava.core.net.SocketAddress localAddress, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.net.NetServer>> listenHandler) { 
    delegate.listen(localAddress.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(listenHandler, ar -> ar.map(event -> io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)event))));
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(io.vertx.rxjava.core.net.SocketAddress localAddress) {
    return 
listen(localAddress, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.net.NetServer> rxListen(io.vertx.rxjava.core.net.SocketAddress localAddress) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listen(localAddress, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @param completionHandler the handler
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param handler the update handler
   */
  public void updateSSLOptions(io.vertx.core.net.SSLOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.updateSSLOptions(options, handler);
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   */
  public void updateSSLOptions(io.vertx.core.net.SSLOptions options) {
    updateSSLOptions(options, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @return 
   */
  public rx.Single<java.lang.Void> rxUpdateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      updateSSLOptions(options, fut);
    }));
  }

  public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }

}
