/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.net;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A TCP client.
 * <p>
 * Multiple connections to different servers can be made using the same instance.
 * <p>
 * This client supports a configurable number of connection attempts and a configurable
 * delay between attempts.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetClient.class)
public class NetClient implements io.vertx.rxjava.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetClient that = (NetClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg<>(    obj -> new NetClient((io.vertx.core.net.NetClient) obj),
    NetClient::getDelegate
  );

  private final io.vertx.core.net.NetClient delegate;
  
  public NetClient(io.vertx.core.net.NetClient delegate) {
    this.delegate = delegate;
  }

  public NetClient(Object delegate) {
    this.delegate = (io.vertx.core.net.NetClient)delegate;
  }

  public io.vertx.core.net.NetClient getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetClient connect(int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.net.NetSocket>> connectHandler) { 
    delegate.connect(port, host, new io.vertx.lang.rx.DelegatingHandler<>(connectHandler, ar -> ar.map(event -> io.vertx.rxjava.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetClient connect(int port, java.lang.String host) {
    return 
connect(port, host, ar -> { });
  }

    /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.net.NetSocket> rxConnect(int port, java.lang.String host) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(port, host, fut);
    }));
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetClient connect(int port, java.lang.String host, java.lang.String serverName, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.net.NetSocket>> connectHandler) { 
    delegate.connect(port, host, serverName, new io.vertx.lang.rx.DelegatingHandler<>(connectHandler, ar -> ar.map(event -> io.vertx.rxjava.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetClient connect(int port, java.lang.String host, java.lang.String serverName) {
    return 
connect(port, host, serverName, ar -> { });
  }

    /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.net.NetSocket> rxConnect(int port, java.lang.String host, java.lang.String serverName) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(port, host, serverName, fut);
    }));
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetClient connect(io.vertx.rxjava.core.net.SocketAddress remoteAddress, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.net.NetSocket>> connectHandler) { 
    delegate.connect(remoteAddress.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(connectHandler, ar -> ar.map(event -> io.vertx.rxjava.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetClient connect(io.vertx.rxjava.core.net.SocketAddress remoteAddress) {
    return 
connect(remoteAddress, ar -> { });
  }

    /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.net.NetSocket> rxConnect(io.vertx.rxjava.core.net.SocketAddress remoteAddress) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(remoteAddress, fut);
    }));
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetClient connect(io.vertx.rxjava.core.net.SocketAddress remoteAddress, java.lang.String serverName, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.net.NetSocket>> connectHandler) { 
    delegate.connect(remoteAddress.getDelegate(), serverName, new io.vertx.lang.rx.DelegatingHandler<>(connectHandler, ar -> ar.map(event -> io.vertx.rxjava.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetClient connect(io.vertx.rxjava.core.net.SocketAddress remoteAddress, java.lang.String serverName) {
    return 
connect(remoteAddress, serverName, ar -> { });
  }

    /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.net.NetSocket> rxConnect(io.vertx.rxjava.core.net.SocketAddress remoteAddress, java.lang.String serverName) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(remoteAddress, serverName, fut);
    }));
  }

  /**
   * Close the client.
   * <p>
   * Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
   * complete until some time after the method has returned.
   * @param handler 
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the client.
   * <p>
   * Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
   * complete until some time after the method has returned.
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Close the client.
   * <p>
   * Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
   * complete until some time after the method has returned.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param handler the update handler
   */
  public void updateSSLOptions(io.vertx.core.net.SSLOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.updateSSLOptions(options, handler);
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   */
  public void updateSSLOptions(io.vertx.core.net.SSLOptions options) {
    updateSSLOptions(options, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @return 
   */
  public rx.Single<java.lang.Void> rxUpdateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      updateSSLOptions(options, fut);
    }));
  }

  public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
    return arg != null ? new NetClient(arg) : null;
  }

}
