/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.http;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Base WebSocket implementation.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.rxjava.core.streams.Pipe} to pipe data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketBase original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.WebSocketBase.class)
public interface WebSocketBase extends io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer>, io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> {

  io.vertx.core.http.WebSocketBase getDelegate();

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe();

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst);

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(io.vertx.rxjava.core.buffer.Buffer data);

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data);

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.http.WebSocketBase#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull();

  public io.vertx.rxjava.core.http.WebSocketBase exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler);

  public io.vertx.rxjava.core.http.WebSocketBase handler(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> handler);

  public io.vertx.rxjava.core.http.WebSocketBase pause();

  public io.vertx.rxjava.core.http.WebSocketBase resume();

  public io.vertx.rxjava.core.http.WebSocketBase fetch(long amount);

  public io.vertx.rxjava.core.http.WebSocketBase endHandler(io.vertx.core.Handler<java.lang.Void> endHandler);

  public io.vertx.rxjava.core.http.WebSocketBase setWriteQueueMaxSize(int maxSize);

  public io.vertx.rxjava.core.http.WebSocketBase drainHandler(io.vertx.core.Handler<java.lang.Void> handler);

  /**
   * When a <code>WebSocket</code> is created, it may register an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.http.WebSocketConnectOptions} or {@link io.vertx.core.http.HttpServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public java.lang.String binaryHandlerID();

  /**
   * When a <code>WebSocket</code> is created, it may register an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.http.WebSocketConnectOptions} or {@link io.vertx.core.http.HttpServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the text handler id
   */
  public java.lang.String textHandlerID();

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the WebSocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public java.lang.String subProtocol();

  /**
   * Returns the close status code received from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public java.lang.Short closeStatusCode();

  /**
   * Returns the close reason message from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public java.lang.String closeReason();

  /**
   *  Returns the HTTP headers when the WebSocket is first obtained in the handler.
   *  <p/>
   *  The headers will be <code>null</code> on subsequent interactions.
   * @return the headers
   */
  public io.vertx.rxjava.core.MultiMap headers();

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFrame(io.vertx.rxjava.core.http.WebSocketFrame frame, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFrame(io.vertx.rxjava.core.http.WebSocketFrame frame);

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteFrame(io.vertx.rxjava.core.http.WebSocketFrame frame);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalTextFrame(java.lang.String text, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalTextFrame(java.lang.String text);

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteFinalTextFrame(java.lang.String text);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data);

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data);

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeTextMessage(java.lang.String text, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeTextMessage(java.lang.String text);

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteTextMessage(java.lang.String text);

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @param handler called when the ping frame has been successfully written
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePing(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePing(io.vertx.rxjava.core.buffer.Buffer data);

    /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxWritePing(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @param handler called when the pong frame has been successfully written
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePong(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePong(io.vertx.rxjava.core.buffer.Buffer data);

    /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxWritePong(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Set a close handler. This will be called when the WebSocket is closed.
   * <p/>
   * After this callback, no more messages are expected. When the WebSocket received a close frame, the
   * {@link io.vertx.rxjava.core.http.WebSocketBase#closeStatusCode} will return the status code and {@link io.vertx.rxjava.core.http.WebSocketBase#closeReason} will return the reason.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase closeHandler(io.vertx.core.Handler<java.lang.Void> handler);

  /**
   * Set a frame handler on the connection. This handler will be called when frames are read on the connection.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase frameHandler(io.vertx.core.Handler<io.vertx.rxjava.core.http.WebSocketFrame> handler);

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * {@link io.vertx.rxjava.core.http.WebSocketBase#binaryMessageHandler}, but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase textMessageHandler(io.vertx.core.Handler<java.lang.String> handler);

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.rxjava.core.http.WebSocketBase#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.rxjava.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase binaryMessageHandler(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> handler);

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase pongHandler(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> handler);

  /**
   * 
   *
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   * @param handler 
   */
  public void end(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * 
   *
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   */
  public void end();

    /**
   * 
   *
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd();

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   */
  public void close();

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose();

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param handler 
   */
  public void close(short statusCode, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   */
  public void close(short statusCode);

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose(short statusCode);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  public void close(short statusCode, java.lang.String reason, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   */
  public void close(short statusCode, java.lang.String reason);

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose(short statusCode, java.lang.String reason);

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.rxjava.core.net.SocketAddress remoteAddress();

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress();

  /**
   * @return true if this {@link io.vertx.rxjava.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl();

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed();

  public static WebSocketBase newInstance(io.vertx.core.http.WebSocketBase arg) {
    return arg != null ? new WebSocketBaseImpl(arg) : null;
  }

}

class WebSocketBaseImpl implements WebSocketBase {
  private final io.vertx.core.http.WebSocketBase delegate;
  
  public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
    this.delegate = delegate;
  }

  public WebSocketBaseImpl(Object delegate) {
    this.delegate = (io.vertx.core.http.WebSocketBase)delegate;
  }

  public io.vertx.core.http.WebSocketBase getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.buffer.Buffer> observable;

  public synchronized Observable<io.vertx.rxjava.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(io.vertx.rxjava.core.buffer.Buffer data) {
    write(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data) {
    end(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.http.WebSocketBase#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.rxjava.core.http.WebSocketBase exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase handler(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>WebSocket</code> is created, it may register an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.http.WebSocketConnectOptions} or {@link io.vertx.core.http.HttpServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public java.lang.String binaryHandlerID() { 
    java.lang.String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created, it may register an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.http.WebSocketConnectOptions} or {@link io.vertx.core.http.HttpServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the text handler id
   */
  public java.lang.String textHandlerID() { 
    java.lang.String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the WebSocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public java.lang.String subProtocol() { 
    java.lang.String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * Returns the close status code received from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public java.lang.Short closeStatusCode() { 
    java.lang.Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * Returns the close reason message from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public java.lang.String closeReason() { 
    java.lang.String ret = delegate.closeReason();
    return ret;
  }

  /**
   *  Returns the HTTP headers when the WebSocket is first obtained in the handler.
   *  <p/>
   *  The headers will be <code>null</code> on subsequent interactions.
   * @return the headers
   */
  public io.vertx.rxjava.core.MultiMap headers() { 
    io.vertx.rxjava.core.MultiMap ret = io.vertx.rxjava.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFrame(io.vertx.rxjava.core.http.WebSocketFrame frame, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeFrame(frame.getDelegate(), handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFrame(io.vertx.rxjava.core.http.WebSocketFrame frame) {
    return 
writeFrame(frame, ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteFrame(io.vertx.rxjava.core.http.WebSocketFrame frame) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      writeFrame(frame, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalTextFrame(java.lang.String text, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeFinalTextFrame(text, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalTextFrame(java.lang.String text) {
    return 
writeFinalTextFrame(text, ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteFinalTextFrame(java.lang.String text) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      writeFinalTextFrame(text, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data) {
    return 
writeFinalBinaryFrame(data, ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      writeFinalBinaryFrame(data, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeBinaryMessage(data.getDelegate(), handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data) {
    return 
writeBinaryMessage(data, ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      writeBinaryMessage(data, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeTextMessage(java.lang.String text, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeTextMessage(text, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeTextMessage(java.lang.String text) {
    return 
writeTextMessage(text, ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWriteTextMessage(java.lang.String text) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      writeTextMessage(text, fut);
    }));
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @param handler called when the ping frame has been successfully written
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePing(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writePing(data.getDelegate(), handler);
    return this;
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePing(io.vertx.rxjava.core.buffer.Buffer data) {
    return 
writePing(data, ar -> { });
  }

    /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxWritePing(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      writePing(data, fut);
    }));
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @param handler called when the pong frame has been successfully written
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePong(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writePong(data.getDelegate(), handler);
    return this;
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePong(io.vertx.rxjava.core.buffer.Buffer data) {
    return 
writePong(data, ar -> { });
  }

    /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxWritePong(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      writePong(data, fut);
    }));
  }

  /**
   * Set a close handler. This will be called when the WebSocket is closed.
   * <p/>
   * After this callback, no more messages are expected. When the WebSocket received a close frame, the
   * {@link io.vertx.rxjava.core.http.WebSocketBase#closeStatusCode} will return the status code and {@link io.vertx.rxjava.core.http.WebSocketBase#closeReason} will return the reason.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set a frame handler on the connection. This handler will be called when frames are read on the connection.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase frameHandler(io.vertx.core.Handler<io.vertx.rxjava.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)event)));
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * {@link io.vertx.rxjava.core.http.WebSocketBase#binaryMessageHandler}, but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase textMessageHandler(io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.rxjava.core.http.WebSocketBase#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.rxjava.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase binaryMessageHandler(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase pongHandler(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.pongHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * 
   *
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   * @param handler 
   */
  public void end(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * 
   *
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   */
  public void end() {
    end(ar -> { });
  }

    /**
   * 
   *
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param handler 
   */
  public void close(short statusCode, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(statusCode, handler);
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   */
  public void close(short statusCode) {
    close(statusCode, ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose(short statusCode) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(statusCode, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  public void close(short statusCode, java.lang.String reason, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(statusCode, reason, handler);
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   */
  public void close(short statusCode, java.lang.String reason) {
    close(statusCode, reason, ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose(short statusCode, java.lang.String reason) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(statusCode, reason, fut);
    }));
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.rxjava.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.rxjava.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.rxjava.core.net.SocketAddress cached_0;
  private io.vertx.rxjava.core.net.SocketAddress cached_1;
}
