/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.dns;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Provides a way to asynchronously lookup information from DNS servers.
 * <p>
 * Please consult the documentation for more information on DNS clients.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.DnsClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.dns.DnsClient.class)
public class DnsClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DnsClient that = (DnsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg<>(    obj -> new DnsClient((io.vertx.core.dns.DnsClient) obj),
    DnsClient::getDelegate
  );

  private final io.vertx.core.dns.DnsClient delegate;
  
  public DnsClient(io.vertx.core.dns.DnsClient delegate) {
    this.delegate = delegate;
  }

  public DnsClient(Object delegate) {
    this.delegate = (io.vertx.core.dns.DnsClient)delegate;
  }

  public io.vertx.core.dns.DnsClient getDelegate() {
    return delegate;
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with the resolved address if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient lookup(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.lookup(name, handler);
    return this;
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient lookup(java.lang.String name) {
    return 
lookup(name, ar -> { });
  }

    /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.String> rxLookup(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lookup(name, fut);
    }));
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the  to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with the resolved {@link java.net.Inet4Address} if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient lookup4(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.lookup4(name, handler);
    return this;
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient lookup4(java.lang.String name) {
    return 
lookup4(name, ar -> { });
  }

    /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.String> rxLookup4(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lookup4(name, fut);
    }));
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.net.Inet6Address} if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient lookup6(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.lookup6(name, handler);
    return this;
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient lookup6(java.lang.String name) {
    return 
lookup6(name, ar -> { });
  }

    /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.String> rxLookup6(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lookup6(name, fut);
    }));
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet4Address}es. If none was found an empty {@link java.util.List} will be used. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveA(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> handler) { 
    delegate.resolveA(name, handler);
    return this;
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveA(java.lang.String name) {
    return 
resolveA(name, ar -> { });
  }

    /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.util.List<java.lang.String>> rxResolveA(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolveA(name, fut);
    }));
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet6Address}es. If none was found an empty {@link java.util.List} will be used. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveAAAA(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> handler) { 
    delegate.resolveAAAA(name, handler);
    return this;
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveAAAA(java.lang.String name) {
    return 
resolveAAAA(name, ar -> { });
  }

    /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.util.List<java.lang.String>> rxResolveAAAA(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolveAAAA(name, fut);
    }));
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveCNAME(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> handler) { 
    delegate.resolveCNAME(name, handler);
    return this;
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveCNAME(java.lang.String name) {
    return 
resolveCNAME(name, ar -> { });
  }

    /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a reference to this, so the API can be used fluently.
   */
  public rx.Single<java.util.List<java.lang.String>> rxResolveCNAME(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolveCNAME(name, fut);
    }));
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a List that contains all resolved {@link io.vertx.rxjava.core.dns.MxRecord}s, sorted by their {@link io.vertx.rxjava.core.dns.MxRecord#priority}. If non was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveMX(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.rxjava.core.dns.MxRecord>>> handler) { 
    delegate.resolveMX(name, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.rxjava.core.dns.MxRecord.newInstance((io.vertx.core.dns.MxRecord)elt)).collect(Collectors.toList()))));
    return this;
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveMX(java.lang.String name) {
    return 
resolveMX(name, ar -> { });
  }

    /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public rx.Single<java.util.List<io.vertx.rxjava.core.dns.MxRecord>> rxResolveMX(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolveMX(name, fut);
    }));
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveTXT(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> handler) { 
    delegate.resolveTXT(name, handler);
    return this;
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveTXT(java.lang.String name) {
    return 
resolveTXT(name, ar -> { });
  }

    /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public rx.Single<java.util.List<java.lang.String>> rxResolveTXT(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolveTXT(name, fut);
    }));
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolvePTR(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.resolvePTR(name, handler);
    return this;
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolvePTR(java.lang.String name) {
    return 
resolvePTR(name, ar -> { });
  }

    /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public rx.Single<java.lang.String> rxResolvePTR(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolvePTR(name, fut);
    }));
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveNS(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> handler) { 
    delegate.resolveNS(name, handler);
    return this;
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveNS(java.lang.String name) {
    return 
resolveNS(name, ar -> { });
  }

    /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public rx.Single<java.util.List<java.lang.String>> rxResolveNS(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolveNS(name, fut);
    }));
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link io.vertx.rxjava.core.dns.SrvRecord}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveSRV(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.rxjava.core.dns.SrvRecord>>> handler) { 
    delegate.resolveSRV(name, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.rxjava.core.dns.SrvRecord.newInstance((io.vertx.core.dns.SrvRecord)elt)).collect(Collectors.toList()))));
    return this;
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient resolveSRV(java.lang.String name) {
    return 
resolveSRV(name, ar -> { });
  }

    /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public rx.Single<java.util.List<io.vertx.rxjava.core.dns.SrvRecord>> rxResolveSRV(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolveSRV(name, fut);
    }));
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient reverseLookup(java.lang.String ipaddress, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.reverseLookup(ipaddress, handler);
    return this;
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.rxjava.core.dns.DnsClient reverseLookup(java.lang.String ipaddress) {
    return 
reverseLookup(ipaddress, ar -> { });
  }

    /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public rx.Single<java.lang.String> rxReverseLookup(java.lang.String ipaddress) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      reverseLookup(ipaddress, fut);
    }));
  }

  public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
    return arg != null ? new DnsClient(arg) : null;
  }

}
