/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.datagram;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A datagram socket can be used to send {@link io.vertx.rxjava.core.datagram.DatagramPacket}'s to remote datagram servers
 * and receive {@link io.vertx.rxjava.core.datagram.DatagramPacket}s .
 * <p>
 * Usually you use a datagram socket to send UDP over the wire. UDP is connection-less which means you are not connected
 * to the remote peer in a persistent way. Because of this you have to supply the address and port of the remote peer
 * when sending data.
 * <p>
 * You can send data to ipv4 or ipv6 addresses, which also include multicast addresses.
 * <p>
 * Please consult the documentation for more information on datagram sockets.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.datagram.DatagramPacket>, io.vertx.rxjava.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramSocket that = (DatagramSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg<>(    obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket) obj),
    DatagramSocket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramSocket delegate;
  
  public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
    this.delegate = delegate;
  }

  public DatagramSocket(Object delegate) {
    this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
  }

  public io.vertx.core.datagram.DatagramSocket getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.datagram.DatagramPacket> observable;

  public synchronized Observable<io.vertx.rxjava.core.datagram.DatagramPacket> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.datagram.DatagramPacket, io.vertx.rxjava.core.datagram.DatagramPacket> conv = io.vertx.rxjava.core.datagram.DatagramPacket::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private static final TypeArg<io.vertx.rxjava.core.datagram.DatagramPacket> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.datagram.DatagramPacket>(o1 -> io.vertx.rxjava.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.datagram.DatagramPacket> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.datagram.DatagramPacket> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.datagram.DatagramPacket> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.datagram.DatagramPacket> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.datagram.DatagramPacket> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * Write the given {@link io.vertx.rxjava.core.buffer.Buffer} to the {@link io.vertx.rxjava.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.rxjava.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(io.vertx.rxjava.core.buffer.Buffer packet, int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.send(packet.getDelegate(), port, host, handler);
    return this;
  }

  /**
   * Write the given {@link io.vertx.rxjava.core.buffer.Buffer} to the {@link io.vertx.rxjava.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.rxjava.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(io.vertx.rxjava.core.buffer.Buffer packet, int port, java.lang.String host) {
    return 
send(packet, port, host, ar -> { });
  }

    /**
   * Write the given {@link io.vertx.rxjava.core.buffer.Buffer} to the {@link io.vertx.rxjava.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.rxjava.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxSend(io.vertx.rxjava.core.buffer.Buffer packet, int port, java.lang.String host) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      send(packet, port, host, fut);
    }));
  }

  /**
   * Returns a <code>WriteStream<Buffer></code> able to send  to the
   * {@link io.vertx.rxjava.core.net.SocketAddress}.
   * @param port the port of the remote peer
   * @param host the host address of the remote peer
   * @return the write stream for sending packets
   */
  public io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> sender(int port, java.lang.String host) { 
    io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.core.streams.WriteStream.newInstance((io.vertx.core.streams.WriteStream)delegate.sender(port, host), TYPE_ARG_1);
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(java.lang.String str, int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.send(str, port, host, handler);
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(java.lang.String str, int port, java.lang.String host) {
    return 
send(str, port, host, ar -> { });
  }

    /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxSend(java.lang.String str, int port, java.lang.String host) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      send(str, port, host, fut);
    }));
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(java.lang.String str, java.lang.String enc, int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.send(str, enc, port, host, handler);
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket send(java.lang.String str, java.lang.String enc, int port, java.lang.String host) {
    return 
send(str, enc, port, host, ar -> { });
  }

    /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.rxjava.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxSend(java.lang.String str, java.lang.String enc, int port, java.lang.String host) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      send(str, enc, port, host, fut);
    }));
  }

  /**
   * Closes the {@link io.vertx.rxjava.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @param handler the handler to notify once complete
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the {@link io.vertx.rxjava.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Closes the {@link io.vertx.rxjava.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Return the {@link io.vertx.rxjava.core.net.SocketAddress} to which
   * this {@link io.vertx.rxjava.core.datagram.DatagramSocket} is bound.
   * @return the socket address
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listenMulticastGroup(java.lang.String multicastAddress, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, handler);
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listenMulticastGroup(java.lang.String multicastAddress) {
    return 
listenMulticastGroup(multicastAddress, ar -> { });
  }

    /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxListenMulticastGroup(java.lang.String multicastAddress) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listenMulticastGroup(multicastAddress, fut);
    }));
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, networkInterface, source, handler);
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source) {
    return 
listenMulticastGroup(multicastAddress, networkInterface, source, ar -> { });
  }

    /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxListenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listenMulticastGroup(multicastAddress, networkInterface, source, fut);
    }));
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket unlistenMulticastGroup(java.lang.String multicastAddress, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, handler);
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket unlistenMulticastGroup(java.lang.String multicastAddress) {
    return 
unlistenMulticastGroup(multicastAddress, ar -> { });
  }

    /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxUnlistenMulticastGroup(java.lang.String multicastAddress) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      unlistenMulticastGroup(multicastAddress, fut);
    }));
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket unlistenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, handler);
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket unlistenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source) {
    return 
unlistenMulticastGroup(multicastAddress, networkInterface, source, ar -> { });
  }

    /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxUnlistenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      unlistenMulticastGroup(multicastAddress, networkInterface, source, fut);
    }));
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket blockMulticastGroup(java.lang.String multicastAddress, java.lang.String sourceToBlock, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, sourceToBlock, handler);
    return this;
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket blockMulticastGroup(java.lang.String multicastAddress, java.lang.String sourceToBlock) {
    return 
blockMulticastGroup(multicastAddress, sourceToBlock, ar -> { });
  }

    /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxBlockMulticastGroup(java.lang.String multicastAddress, java.lang.String sourceToBlock) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      blockMulticastGroup(multicastAddress, sourceToBlock, fut);
    }));
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket blockMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String sourceToBlock, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler);
    return this;
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket blockMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String sourceToBlock) {
    return 
blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, ar -> { });
  }

    /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxBlockMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String sourceToBlock) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, fut);
    }));
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param handler the handler will be called when listening
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listen(int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.datagram.DatagramSocket>> handler) { 
    delegate.listen(port, host, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)event))));
    return this;
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.datagram.DatagramSocket listen(int port, java.lang.String host) {
    return 
listen(port, host, ar -> { });
  }

    /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.core.datagram.DatagramSocket> rxListen(int port, java.lang.String host) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listen(port, host, fut);
    }));
  }

  /**
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava.core.datagram.DatagramSocket pause() { 
    delegate.pause();
    return this;
  }

  /**
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava.core.datagram.DatagramSocket resume() { 
    delegate.resume();
    return this;
  }

  /**
   * @param amount 
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava.core.datagram.DatagramSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * @param endHandler 
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava.core.datagram.DatagramSocket endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.core.datagram.DatagramSocket handler(io.vertx.core.Handler<io.vertx.rxjava.core.datagram.DatagramPacket> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)event)));
    return this;
  }

  public io.vertx.rxjava.core.datagram.DatagramSocket exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  private io.vertx.rxjava.core.net.SocketAddress cached_0;
  public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
    return arg != null ? new DatagramSocket(arg) : null;
  }

}
