/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.cli;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface defining a command-line interface (in other words a command such as 'run', 'ls'...).
 * This interface is polyglot to ease reuse such as in Vert.x Shell.
 * <p/>
 * A command line interface has a name, and defines a set of options and arguments. Options are key-value pair such
 * as <code>-foo=bar</code> or <code>-flag</code>. The supported formats depend on the used parser. Arguments are unlike
 * options raw values. Options are defined using
 * {@link io.vertx.core.cli.Option}, while argument are defined using {@link io.vertx.core.cli.Argument}.
 * <p/>
 * Command line interfaces also define a summary and a description. These attributes are used in the usage generation
 * . To disable the help generation, set the <code>hidden</code> attribute to <code>true</code>.
 * <p/>
 * Command Line Interface object does not contains "value", it's a model. It must be evaluated by a
 * parser that returns a {@link io.vertx.rxjava.core.cli.CommandLine} object containing the argument and option values.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.cli.CLI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.cli.CLI.class)
public class CLI {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CLI that = (CLI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CLI> __TYPE_ARG = new TypeArg<>(    obj -> new CLI((io.vertx.core.cli.CLI) obj),
    CLI::getDelegate
  );

  private final io.vertx.core.cli.CLI delegate;
  
  public CLI(io.vertx.core.cli.CLI delegate) {
    this.delegate = delegate;
  }

  public CLI(Object delegate) {
    this.delegate = (io.vertx.core.cli.CLI)delegate;
  }

  public io.vertx.core.cli.CLI getDelegate() {
    return delegate;
  }


  /**
   * Creates an instance of {@link io.vertx.rxjava.core.cli.CLI} using the default implementation.
   * @param name the name of the CLI (must not be <code>null</code>)
   * @return the created instance of {@link io.vertx.rxjava.core.cli.CLI}
   */
  public static io.vertx.rxjava.core.cli.CLI create(java.lang.String name) { 
    io.vertx.rxjava.core.cli.CLI ret = io.vertx.rxjava.core.cli.CLI.newInstance((io.vertx.core.cli.CLI)io.vertx.core.cli.CLI.create(name));
    return ret;
  }

  /**
   * Parses the user command line interface and create a new {@link io.vertx.rxjava.core.cli.CommandLine} containing extracting values.
   * @param arguments the arguments
   * @return the creates command line
   */
  public io.vertx.rxjava.core.cli.CommandLine parse(java.util.List<java.lang.String> arguments) { 
    io.vertx.rxjava.core.cli.CommandLine ret = io.vertx.rxjava.core.cli.CommandLine.newInstance((io.vertx.core.cli.CommandLine)delegate.parse(arguments));
    return ret;
  }

  /**
   * Parses the user command line interface and create a new {@link io.vertx.rxjava.core.cli.CommandLine} containing extracting values.
   * @param arguments the arguments
   * @param validate enable / disable parsing validation
   * @return the creates command line
   */
  public io.vertx.rxjava.core.cli.CommandLine parse(java.util.List<java.lang.String> arguments, boolean validate) { 
    io.vertx.rxjava.core.cli.CommandLine ret = io.vertx.rxjava.core.cli.CommandLine.newInstance((io.vertx.core.cli.CommandLine)delegate.parse(arguments, validate));
    return ret;
  }

  /**
   * @return the CLI name.
   */
  public java.lang.String getName() { 
    java.lang.String ret = delegate.getName();
    return ret;
  }

  /**
   * Sets the name of the CLI.
   * @param name the name
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI setName(java.lang.String name) { 
    delegate.setName(name);
    return this;
  }

  /**
   * @return the CLI description.
   */
  public java.lang.String getDescription() { 
    java.lang.String ret = delegate.getDescription();
    return ret;
  }

  public io.vertx.rxjava.core.cli.CLI setDescription(java.lang.String desc) { 
    delegate.setDescription(desc);
    return this;
  }

  /**
   * @return the CLI summary.
   */
  public java.lang.String getSummary() { 
    java.lang.String ret = delegate.getSummary();
    return ret;
  }

  /**
   * Sets the summary of the CLI.
   * @param summary the summary
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI setSummary(java.lang.String summary) { 
    delegate.setSummary(summary);
    return this;
  }

  /**
   * Checks whether or not the current {@link io.vertx.rxjava.core.cli.CLI} instance is hidden.
   * @return <code>true</code> if the current {@link io.vertx.rxjava.core.cli.CLI} is hidden,  otherwise
   */
  public boolean isHidden() { 
    boolean ret = delegate.isHidden();
    return ret;
  }

  /**
   * Sets whether or not the current instance of {@link io.vertx.rxjava.core.cli.CLI} must be hidden. Hidden CLI are not listed when
   * displaying usages / help messages. In other words, hidden commands are for power user.
   * @param hidden enables or disables the hidden aspect of the CI
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI setHidden(boolean hidden) { 
    delegate.setHidden(hidden);
    return this;
  }

  /**
   * Gets the list of options.
   * @return the list of options, empty if none.
   */
  public java.util.List<io.vertx.core.cli.Option> getOptions() { 
    java.util.List<io.vertx.core.cli.Option> ret = delegate.getOptions();
    return ret;
  }

  /**
   * Adds an option.
   * @param option the option, must not be <code>null</code>.
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI addOption(io.vertx.core.cli.Option option) { 
    delegate.addOption(option);
    return this;
  }

  /**
   * Adds a set of options. Unlike {@link io.vertx.rxjava.core.cli.CLI#setOptions}}, this method does not remove the existing options.
   * The given list is appended to the existing list.
   * @param options the options, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI addOptions(java.util.List<io.vertx.core.cli.Option> options) { 
    delegate.addOptions(options);
    return this;
  }

  /**
   * Sets the list of arguments.
   * @param options the list of options, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI setOptions(java.util.List<io.vertx.core.cli.Option> options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * Gets the list of defined arguments.
   * @return the list of argument, empty if none.
   */
  public java.util.List<io.vertx.core.cli.Argument> getArguments() { 
    java.util.List<io.vertx.core.cli.Argument> ret = delegate.getArguments();
    return ret;
  }

  /**
   * Adds an argument.
   * @param arg the argument, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI addArgument(io.vertx.core.cli.Argument arg) { 
    delegate.addArgument(arg);
    return this;
  }

  /**
   * Adds a set of arguments. Unlike {@link io.vertx.rxjava.core.cli.CLI#setArguments}, this method does not remove the existing arguments.
   * The given list is appended to the existing list.
   * @param args the arguments, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI addArguments(java.util.List<io.vertx.core.cli.Argument> args) { 
    delegate.addArguments(args);
    return this;
  }

  /**
   * Sets the list of arguments.
   * @param args the list of arguments, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI setArguments(java.util.List<io.vertx.core.cli.Argument> args) { 
    delegate.setArguments(args);
    return this;
  }

  /**
   * Gets an {@link io.vertx.core.cli.Option} based on its name (short name, long name or argument name).
   * @param name the name, must not be <code>null</code>
   * @return the {@link io.vertx.core.cli.Option}, <code>null</code> if not found
   */
  public io.vertx.core.cli.Option getOption(java.lang.String name) { 
    io.vertx.core.cli.Option ret = delegate.getOption(name);
    return ret;
  }

  /**
   * Gets an {@link io.vertx.core.cli.Argument} based on its name (argument name).
   * @param name the name of the argument, must not be <code>null</code>
   * @return the {@link io.vertx.core.cli.Argument}, <code>null</code> if not found.
   */
  public io.vertx.core.cli.Argument getArgument(java.lang.String name) { 
    io.vertx.core.cli.Argument ret = delegate.getArgument(name);
    return ret;
  }

  /**
   * Gets an {@link io.vertx.core.cli.Argument} based on its index.
   * @param index the index, must be positive or zero.
   * @return the {@link io.vertx.core.cli.Argument}, <code>null</code> if not found.
   */
  public io.vertx.core.cli.Argument getArgument(int index) { 
    io.vertx.core.cli.Argument ret = delegate.getArgument(index);
    return ret;
  }

  /**
   * Removes an option identified by its name. This method does nothing if the option cannot be found.
   * @param name the option name
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI removeOption(java.lang.String name) { 
    delegate.removeOption(name);
    return this;
  }

  /**
   * Removes an argument identified by its index. This method does nothing if the argument cannot be found.
   * @param index the argument index
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI removeArgument(int index) { 
    delegate.removeArgument(index);
    return this;
  }

  /**
   * @return the CLI priority.
   */
  public int getPriority() { 
    int ret = delegate.getPriority();
    return ret;
  }

  /**
   * Sets the priority of the CLI.
   * @param priority the priority
   * @return the current {@link io.vertx.rxjava.core.cli.CLI} instance
   */
  public io.vertx.rxjava.core.cli.CLI setPriority(int priority) { 
    delegate.setPriority(priority);
    return this;
  }

  public static CLI newInstance(io.vertx.core.cli.CLI arg) {
    return arg != null ? new CLI(arg) : null;
  }

}
