/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.circuitbreaker;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A policy for retry execution.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.RetryPolicy original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.circuitbreaker.RetryPolicy.class)
public class RetryPolicy {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RetryPolicy that = (RetryPolicy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RetryPolicy> __TYPE_ARG = new TypeArg<>(    obj -> new RetryPolicy((io.vertx.circuitbreaker.RetryPolicy) obj),
    RetryPolicy::getDelegate
  );

  private final io.vertx.circuitbreaker.RetryPolicy delegate;
  
  public RetryPolicy(io.vertx.circuitbreaker.RetryPolicy delegate) {
    this.delegate = delegate;
  }

  public RetryPolicy(Object delegate) {
    this.delegate = (io.vertx.circuitbreaker.RetryPolicy)delegate;
  }

  public io.vertx.circuitbreaker.RetryPolicy getDelegate() {
    return delegate;
  }

  /**
   * Create a constant delay retry policy.
   * @param delay the constant delay in milliseconds
   * @return 
   */
  public static io.vertx.rxjava.circuitbreaker.RetryPolicy constantDelay(long delay) { 
    io.vertx.rxjava.circuitbreaker.RetryPolicy ret = io.vertx.rxjava.circuitbreaker.RetryPolicy.newInstance((io.vertx.circuitbreaker.RetryPolicy)io.vertx.circuitbreaker.RetryPolicy.constantDelay(delay));
    return ret;
  }

  /**
   * Create a linear delay retry policy.
   * @param initialDelay the initial delay in milliseconds
   * @param maxDelay maximum delay in milliseconds
   * @return 
   */
  public static io.vertx.rxjava.circuitbreaker.RetryPolicy linearDelay(long initialDelay, long maxDelay) { 
    io.vertx.rxjava.circuitbreaker.RetryPolicy ret = io.vertx.rxjava.circuitbreaker.RetryPolicy.newInstance((io.vertx.circuitbreaker.RetryPolicy)io.vertx.circuitbreaker.RetryPolicy.linearDelay(initialDelay, maxDelay));
    return ret;
  }

  /**
   * Create an exponential delay with jitter retry policy.
   * <p>
   * Based on <em>Full Jitter</em> in <a href="https://aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/">Exponential Backoff And Jitter</a>.
   * @param initialDelay the initial delay in milliseconds
   * @param maxDelay maximum delay in milliseconds
   * @return 
   */
  public static io.vertx.rxjava.circuitbreaker.RetryPolicy exponentialDelayWithJitter(long initialDelay, long maxDelay) { 
    io.vertx.rxjava.circuitbreaker.RetryPolicy ret = io.vertx.rxjava.circuitbreaker.RetryPolicy.newInstance((io.vertx.circuitbreaker.RetryPolicy)io.vertx.circuitbreaker.RetryPolicy.exponentialDelayWithJitter(initialDelay, maxDelay));
    return ret;
  }

  /**
   * Compute a delay in milliseconds before retry is executed.
   * @param failure the failure passed to the operation {@link io.vertx.rxjava.core.Promise}
   * @param retryCount the number of times operation has been retried already
   * @return a delay in milliseconds before retry is executed
   */
  public long delay(java.lang.Throwable failure, int retryCount) { 
    long ret = delegate.delay(failure, retryCount);
    return ret;
  }

  public static RetryPolicy newInstance(io.vertx.circuitbreaker.RetryPolicy arg) {
    return arg != null ? new RetryPolicy(arg) : null;
  }

}
