/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.cassandra;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * It is like {@link com.datastax.oss.driver.api.core.cql.AsyncResultSet}, but adapted for Vert.x.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.ResultSet original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.ResultSet.class)
public class ResultSet {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResultSet that = (ResultSet) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ResultSet> __TYPE_ARG = new TypeArg<>(    obj -> new ResultSet((io.vertx.cassandra.ResultSet) obj),
    ResultSet::getDelegate
  );

  private final io.vertx.cassandra.ResultSet delegate;
  
  public ResultSet(io.vertx.cassandra.ResultSet delegate) {
    this.delegate = delegate;
  }

  public ResultSet(Object delegate) {
    this.delegate = (io.vertx.cassandra.ResultSet)delegate;
  }

  public io.vertx.cassandra.ResultSet getDelegate() {
    return delegate;
  }


  /**
   * @return 
   */
  public int remaining() { 
    int ret = delegate.remaining();
    return ret;
  }

  /**
   * @return 
   */
  public boolean hasMorePages() { 
    boolean ret = delegate.hasMorePages();
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   * @param handler 
   */
  public void fetchNextPage(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.cassandra.ResultSet>> handler) { 
    delegate.fetchNextPage(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)event))));
  }

  /**
   * Like {@link io.vertx.rxjava.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   */
  public void fetchNextPage() {
    fetchNextPage(ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   * @return 
   */
  public rx.Single<io.vertx.rxjava.cassandra.ResultSet> rxFetchNextPage() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      fetchNextPage(fut);
    }));
  }

  /**
   * @return 
   */
  public boolean wasApplied() { 
    boolean ret = delegate.wasApplied();
    return ret;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.rxjava.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * @param handler handler called when all the rows is fetched
   * @return 
   */
  public io.vertx.rxjava.cassandra.ResultSet all(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<com.datastax.oss.driver.api.core.cql.Row>>> handler) { 
    delegate.all(handler);
    return this;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.rxjava.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * @return 
   */
  public io.vertx.rxjava.cassandra.ResultSet all() {
    return 
all(ar -> { });
  }

    /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.rxjava.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * @return 
   */
  public rx.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxAll() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      all(fut);
    }));
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ColumnDefinitions getColumnDefinitions() { 
    com.datastax.oss.driver.api.core.cql.ColumnDefinitions ret = delegate.getColumnDefinitions();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ExecutionInfo getExecutionInfo() { 
    com.datastax.oss.driver.api.core.cql.ExecutionInfo ret = delegate.getExecutionInfo();
    return ret;
  }

  /**
   * @return 
   */
  public java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> currentPage() { 
    java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> ret = delegate.currentPage();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.Row one() { 
    com.datastax.oss.driver.api.core.cql.Row ret = delegate.one();
    return ret;
  }

  public static ResultSet newInstance(io.vertx.cassandra.ResultSet arg) {
    return arg != null ? new ResultSet(arg) : null;
  }

}
