/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.sqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.sqlclient.PreparedStatement;
import io.vertx.rxjava.sqlclient.SqlClient;
import rx.Single;

@RxGen(value=io.vertx.sqlclient.Transaction.class)
public class Transaction
extends SqlClient {
    public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg(obj -> new Transaction((io.vertx.sqlclient.Transaction)obj), Transaction::getDelegate);
    private final io.vertx.sqlclient.Transaction delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Transaction(io.vertx.sqlclient.Transaction delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public Transaction(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.Transaction)delegate));
        this.delegate = (io.vertx.sqlclient.Transaction)delegate;
    }

    public io.vertx.sqlclient.Transaction getDelegate() {
        return this.delegate;
    }

    public Transaction prepare(String sql, final Handler<AsyncResult<PreparedStatement>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<PreparedStatement> rxPrepare(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.prepare(sql, (Handler<AsyncResult<PreparedStatement>>)fut)));
    }

    public void commit() {
        this.delegate.commit();
    }

    public void commit(Handler<AsyncResult<Void>> handler) {
        this.delegate.commit(handler);
    }

    public Single<Void> rxCommit() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.commit((Handler<AsyncResult<Void>>)fut)));
    }

    public void rollback() {
        this.delegate.rollback();
    }

    public void rollback(Handler<AsyncResult<Void>> handler) {
        this.delegate.rollback(handler);
    }

    public Single<Void> rxRollback() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.rollback((Handler<AsyncResult<Void>>)fut)));
    }

    public Transaction abortHandler(Handler<Void> handler) {
        this.delegate.abortHandler(handler);
        return this;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
        return arg != null ? new Transaction(arg) : null;
    }
}

