/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.rabbitmq;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.rxjava.rabbitmq.RabbitMQMessage;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.rabbitmq.RabbitMQConsumer.class)
public class RabbitMQConsumer
implements ReadStream<RabbitMQMessage> {
    public static final TypeArg<RabbitMQConsumer> __TYPE_ARG = new TypeArg(obj -> new RabbitMQConsumer((io.vertx.rabbitmq.RabbitMQConsumer)obj), RabbitMQConsumer::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQConsumer delegate;
    private Observable<RabbitMQMessage> observable;
    private static final TypeArg<RabbitMQMessage> TYPE_ARG_0 = new TypeArg(o1 -> RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)o1), o1 -> o1.getDelegate());
    private static final TypeArg<RabbitMQMessage> TYPE_ARG_1 = new TypeArg(o1 -> RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQConsumer that = (RabbitMQConsumer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQConsumer(io.vertx.rabbitmq.RabbitMQConsumer delegate) {
        this.delegate = delegate;
    }

    public RabbitMQConsumer(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQConsumer)delegate;
    }

    public io.vertx.rabbitmq.RabbitMQConsumer getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<RabbitMQMessage> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.rabbitmq.RabbitMQMessage, RabbitMQMessage> conv = RabbitMQMessage::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public ReadStream<RabbitMQMessage> fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public Pipe<RabbitMQMessage> pipe() {
        Pipe<RabbitMQMessage> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_1);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<RabbitMQMessage> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<RabbitMQMessage> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> pipeToObservable(WriteStream<RabbitMQMessage> dst) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxPipeTo(WriteStream<RabbitMQMessage> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public RabbitMQConsumer exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.delegate.exceptionHandler(exceptionHandler);
        return this;
    }

    public RabbitMQConsumer handler(final Handler<RabbitMQMessage> messageArrived) {
        this.delegate.handler((Handler)new Handler<io.vertx.rabbitmq.RabbitMQMessage>(){

            public void handle(io.vertx.rabbitmq.RabbitMQMessage event) {
                messageArrived.handle((Object)RabbitMQMessage.newInstance(event));
            }
        });
        return this;
    }

    public RabbitMQConsumer pause() {
        this.delegate.pause();
        return this;
    }

    public RabbitMQConsumer resume() {
        this.delegate.resume();
        return this;
    }

    public RabbitMQConsumer endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public String consumerTag() {
        String ret = this.delegate.consumerTag();
        return ret;
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public void cancel(Handler<AsyncResult<Void>> cancelResult) {
        this.delegate.cancel(cancelResult);
    }

    @Deprecated
    public Observable<Void> cancelObservable() {
        ObservableFuture<Void> cancelResult = RxHelper.observableFuture();
        this.cancel(cancelResult.toHandler());
        return cancelResult;
    }

    public Single<Void> rxCancel() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.cancel((Handler<AsyncResult<Void>>)fut)));
    }

    public boolean isPaused() {
        boolean ret = this.delegate.isPaused();
        return ret;
    }

    public static RabbitMQConsumer newInstance(io.vertx.rabbitmq.RabbitMQConsumer arg) {
        return arg != null ? new RabbitMQConsumer(arg) : null;
    }
}

