/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.eventbus.DeliveryContext;
import io.vertx.rxjava.core.eventbus.Message;
import io.vertx.rxjava.core.eventbus.MessageConsumer;
import io.vertx.rxjava.core.eventbus.MessageProducer;
import io.vertx.rxjava.core.metrics.Measured;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.eventbus.EventBus.class)
public class EventBus
implements Measured {
    public static final TypeArg<EventBus> __TYPE_ARG = new TypeArg(obj -> new EventBus((io.vertx.core.eventbus.EventBus)obj), EventBus::getDelegate);
    private final io.vertx.core.eventbus.EventBus delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventBus that = (EventBus)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public EventBus(io.vertx.core.eventbus.EventBus delegate) {
        this.delegate = delegate;
    }

    public EventBus(Object delegate) {
        this.delegate = (io.vertx.core.eventbus.EventBus)delegate;
    }

    public io.vertx.core.eventbus.EventBus getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public EventBus send(String address, Object message) {
        this.delegate.send(address, message);
        return this;
    }

    @Deprecated
    public <T> EventBus send(String address, Object message, final Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.send(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle((Object)Future.succeededFuture(Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
                } else {
                    replyHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public <T> Observable<Message<T>> sendObservable(String address, Object message) {
        ObservableFuture<Message<T>> replyHandler = RxHelper.observableFuture();
        this.send(address, message, replyHandler.toHandler());
        return replyHandler;
    }

    @Deprecated
    public <T> Single<Message<T>> rxSend(String address, Object message) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(address, message, (Handler)fut)));
    }

    public EventBus send(String address, Object message, DeliveryOptions options) {
        this.delegate.send(address, message, options);
        return this;
    }

    @Deprecated
    public <T> EventBus send(String address, Object message, DeliveryOptions options, final Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.send(address, message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle((Object)Future.succeededFuture(Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
                } else {
                    replyHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public <T> Observable<Message<T>> sendObservable(String address, Object message, DeliveryOptions options) {
        ObservableFuture<Message<T>> replyHandler = RxHelper.observableFuture();
        this.send(address, message, options, replyHandler.toHandler());
        return replyHandler;
    }

    @Deprecated
    public <T> Single<Message<T>> rxSend(String address, Object message, DeliveryOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(address, message, options, (Handler)fut)));
    }

    public <T> EventBus request(String address, Object message, final Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.request(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle((Object)Future.succeededFuture(Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
                } else {
                    replyHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public <T> Observable<Message<T>> requestObservable(String address, Object message) {
        ObservableFuture<Message<T>> replyHandler = RxHelper.observableFuture();
        this.request(address, message, replyHandler.toHandler());
        return replyHandler;
    }

    public <T> Single<Message<T>> rxRequest(String address, Object message) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.request(address, message, (Handler)fut)));
    }

    public <T> EventBus request(String address, Object message, DeliveryOptions options, final Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.request(address, message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle((Object)Future.succeededFuture(Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
                } else {
                    replyHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public <T> Observable<Message<T>> requestObservable(String address, Object message, DeliveryOptions options) {
        ObservableFuture<Message<T>> replyHandler = RxHelper.observableFuture();
        this.request(address, message, options, replyHandler.toHandler());
        return replyHandler;
    }

    public <T> Single<Message<T>> rxRequest(String address, Object message, DeliveryOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.request(address, message, options, (Handler)fut)));
    }

    public EventBus publish(String address, Object message) {
        this.delegate.publish(address, message);
        return this;
    }

    public EventBus publish(String address, Object message, DeliveryOptions options) {
        this.delegate.publish(address, message, options);
        return this;
    }

    public <T> MessageConsumer<T> consumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> consumer(String address, final Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address, new Handler<io.vertx.core.eventbus.Message<T>>(){

            public void handle(io.vertx.core.eventbus.Message<T> event) {
                handler.handle(Message.newInstance(event, TypeArg.unknown()));
            }
        }), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address, final Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address, new Handler<io.vertx.core.eventbus.Message<T>>(){

            public void handle(io.vertx.core.eventbus.Message<T> event) {
                handler.handle(Message.newInstance(event, TypeArg.unknown()));
            }
        }), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> sender(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> sender(String address, DeliveryOptions options) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address, options), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address, options), TypeArg.unknown());
        return ret;
    }

    public <T> EventBus addOutboundInterceptor(final Handler<DeliveryContext<T>> interceptor) {
        this.delegate.addOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>(){

            public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
                interceptor.handle(DeliveryContext.newInstance(event, TypeArg.unknown()));
            }
        });
        return this;
    }

    public <T> EventBus removeOutboundInterceptor(final Handler<DeliveryContext<T>> interceptor) {
        this.delegate.removeOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>(){

            public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
                interceptor.handle(DeliveryContext.newInstance(event, TypeArg.unknown()));
            }
        });
        return this;
    }

    public <T> EventBus addInboundInterceptor(final Handler<DeliveryContext<T>> interceptor) {
        this.delegate.addInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>(){

            public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
                interceptor.handle(DeliveryContext.newInstance(event, TypeArg.unknown()));
            }
        });
        return this;
    }

    public <T> EventBus removeInboundInterceptor(final Handler<DeliveryContext<T>> interceptor) {
        this.delegate.removeInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>(){

            public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
                interceptor.handle(DeliveryContext.newInstance(event, TypeArg.unknown()));
            }
        });
        return this;
    }

    public EventBus registerCodec(MessageCodec codec) {
        EventBus ret = EventBus.newInstance(this.delegate.registerCodec(codec));
        return ret;
    }

    public EventBus unregisterCodec(String name) {
        EventBus ret = EventBus.newInstance(this.delegate.unregisterCodec(name));
        return ret;
    }

    public static EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
        return arg != null ? new EventBus(arg) : null;
    }
}

