/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.mqtt.MqttServerOptionsConverter;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@DataObject(generateConverter=true, publicConverter=false)
public class MqttServerOptions
extends NetServerOptions {
    public static final int DEFAULT_PORT = 1883;
    public static final int DEFAULT_TLS_PORT = 8883;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 8092;
    public static final boolean DEFAULT_AUTO_CLIENT_ID = true;
    public static final int DEFAULT_MAX_CLIENT_ID_LENGTH = 23;
    public static final int DEFAULT_TIMEOUT_ON_CONNECT = 90;
    public static final boolean DEFAULT_USE_WEB_SOCKET = false;
    public static final int DEFAULT_WEB_SOCKET_MAX_FRAME_SIZE = 65536;
    public static final boolean DEFAULT_PER_FRAME_WEBSOCKET_COMPRESSION_SUPPORTED = true;
    public static final boolean DEFAULT_PER_MESSAGE_WEBSOCKET_COMPRESSION_SUPPORTED = true;
    public static final int DEFAULT_WEBSOCKET_COMPRESSION_LEVEL = 6;
    public static final boolean DEFAULT_WEBSOCKET_ALLOW_SERVER_NO_CONTEXT = false;
    public static final boolean DEFAULT_WEBSOCKET_PREFERRED_CLIENT_NO_CONTEXT = false;
    public static final String MQTT_SUBPROTOCOL_CSV_LIST = "mqtt, mqttv3.1, mqttv3.1.1";
    private int maxMessageSize;
    private boolean isAutoClientId;
    private int maxClientIdLength;
    private int timeoutOnConnect;
    private boolean useWebSocket;
    private int webSocketMaxFrameSize;
    private boolean perFrameWebSocketCompressionSupported;
    private boolean perMessageWebSocketCompressionSupported;
    private int webSocketCompressionLevel;
    private boolean webSocketAllowServerNoContext;
    private boolean webSocketPreferredClientNoContext;

    public MqttServerOptions() {
        this.init();
    }

    private void init() {
        this.setPort(1883);
        this.maxMessageSize = 8092;
        this.isAutoClientId = true;
        this.maxClientIdLength = 23;
        this.timeoutOnConnect = 90;
        this.useWebSocket = false;
        this.webSocketMaxFrameSize = 65536;
        this.perFrameWebSocketCompressionSupported = true;
        this.perMessageWebSocketCompressionSupported = true;
        this.webSocketCompressionLevel = 6;
        this.webSocketAllowServerNoContext = false;
        this.webSocketPreferredClientNoContext = false;
    }

    public MqttServerOptions(JsonObject json) {
        super(json);
        this.init();
        MqttServerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        if (this.maxMessageSize > 0 && this.getReceiveBufferSize() > 0) {
            Arguments.require((this.getReceiveBufferSize() >= this.maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
    }

    public MqttServerOptions(MqttServerOptions other) {
        super((NetServerOptions)other);
        this.maxMessageSize = other.maxMessageSize;
        this.isAutoClientId = other.isAutoClientId;
        this.maxClientIdLength = other.maxClientIdLength;
        this.timeoutOnConnect = other.timeoutOnConnect;
        this.useWebSocket = other.useWebSocket;
        this.webSocketMaxFrameSize = other.webSocketMaxFrameSize;
        this.perFrameWebSocketCompressionSupported = other.perFrameWebSocketCompressionSupported;
        this.perMessageWebSocketCompressionSupported = other.perMessageWebSocketCompressionSupported;
        this.webSocketCompressionLevel = other.webSocketCompressionLevel;
        this.webSocketAllowServerNoContext = other.webSocketAllowServerNoContext;
        this.webSocketPreferredClientNoContext = other.webSocketAllowServerNoContext;
    }

    public MqttServerOptions setPort(int port) {
        super.setPort(port);
        return this;
    }

    public MqttServerOptions setHost(String host) {
        super.setHost(host);
        return this;
    }

    public MqttServerOptions setClientAuth(ClientAuth clientAuth) {
        super.setClientAuth(clientAuth);
        return this;
    }

    public MqttServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public MqttServerOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public MqttServerOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public MqttServerOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public MqttServerOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public MqttServerOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public MqttServerOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    public MqttServerOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public MqttServerOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    public MqttServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public MqttServerOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public MqttServerOptions addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    public MqttServerOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    public MqttServerOptions setReceiveBufferSize(int receiveBufferSize) {
        if (this.maxMessageSize > 0 && receiveBufferSize > 0) {
            Arguments.require((receiveBufferSize >= this.maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public MqttServerOptions setSni(boolean sni) {
        super.setSni(sni);
        return this;
    }

    public MqttServerOptions setMaxMessageSize(int maxMessageSize) {
        Arguments.require((maxMessageSize > 0 ? 1 : 0) != 0, (String)"maxMessageSize must be > 0");
        if (this.getReceiveBufferSize() > 0) {
            Arguments.require((this.getReceiveBufferSize() >= maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public MqttServerOptions setAutoClientId(boolean isAutoClientId) {
        this.isAutoClientId = isAutoClientId;
        return this;
    }

    public boolean isAutoClientId() {
        return this.isAutoClientId;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public MqttServerOptions setMaxClientIdLength(int maxClientIdLength) {
        Arguments.require((maxClientIdLength > 0 ? 1 : 0) != 0, (String)"maxClientIdLength must be > 0");
        this.maxClientIdLength = maxClientIdLength;
        return this;
    }

    public MqttServerOptions setTimeoutOnConnect(int timeoutOnConnect) {
        this.timeoutOnConnect = timeoutOnConnect;
        return this;
    }

    public MqttServerOptions setUseProxyProtocol(boolean useProxyProtocol) {
        super.setUseProxyProtocol(useProxyProtocol);
        return this;
    }

    public boolean isUseProxyProtocol() {
        return super.isUseProxyProtocol();
    }

    public long getProxyProtocolTimeout() {
        return super.getProxyProtocolTimeout();
    }

    public MqttServerOptions setProxyProtocolTimeout(long proxyProtocolTimeout) {
        super.setProxyProtocolTimeout(proxyProtocolTimeout);
        return this;
    }

    public MqttServerOptions setProxyProtocolTimeoutUnit(TimeUnit proxyProtocolTimeoutUnit) {
        super.setProxyProtocolTimeoutUnit(proxyProtocolTimeoutUnit);
        return this;
    }

    public TimeUnit getProxyProtocolTimeoutUnit() {
        return super.getProxyProtocolTimeoutUnit();
    }

    public int timeoutOnConnect() {
        return this.timeoutOnConnect;
    }

    public MqttServerOptions setUseWebSocket(boolean useWebSocket) {
        this.useWebSocket = useWebSocket;
        return this;
    }

    public boolean isUseWebSocket() {
        return this.useWebSocket;
    }

    public int getWebSocketMaxFrameSize() {
        return this.webSocketMaxFrameSize;
    }

    public void setWebSocketMaxFrameSize(int webSocketMaxFrameSize) {
        Arguments.require((webSocketMaxFrameSize > 0 ? 1 : 0) != 0, (String)"WebSocket max frame size must be > 0");
        this.webSocketMaxFrameSize = webSocketMaxFrameSize;
    }

    public boolean isPerFrameWebSocketCompressionSupported() {
        return this.perFrameWebSocketCompressionSupported;
    }

    public MqttServerOptions setPerFrameWebSocketCompressionSupported(boolean supported) {
        this.perFrameWebSocketCompressionSupported = supported;
        return this;
    }

    public boolean isPerMessageWebSocketCompressionSupported() {
        return this.perMessageWebSocketCompressionSupported;
    }

    public MqttServerOptions setPerMessageWebSocketCompressionSupported(boolean supported) {
        this.perMessageWebSocketCompressionSupported = supported;
        return this;
    }

    public int getWebSocketCompressionLevel() {
        return this.webSocketCompressionLevel;
    }

    public MqttServerOptions setWebSocketCompressionLevel(int compressionLevel) {
        this.webSocketCompressionLevel = compressionLevel;
        return this;
    }

    public boolean isWebSocketAllowServerNoContext() {
        return this.webSocketAllowServerNoContext;
    }

    public MqttServerOptions setWebSocketAllowServerNoContext(boolean accept) {
        this.webSocketAllowServerNoContext = accept;
        return this;
    }

    public boolean isWebSocketPreferredClientNoContext() {
        return this.webSocketPreferredClientNoContext;
    }

    public MqttServerOptions setWebSocketPreferredClientNoContext(boolean accept) {
        this.webSocketPreferredClientNoContext = accept;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        MqttServerOptionsConverter.toJson(this, json);
        return json;
    }
}

