/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.ReadPreference;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.TaggableReadPreference;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.ReadPreferenceParser;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class ReadPreferenceParserTest {
    @Test
    public void testNoReadPreference() {
        ReadPreference rp = new ReadPreferenceParser(null, new JsonObject()).readPreference();
        Assert.assertNull((Object)rp);
    }

    @Test
    public void testReadPreference() {
        JsonObject config = new JsonObject();
        config.put("readPreference", (Object)"primary");
        ReadPreference rp = new ReadPreferenceParser(null, config).readPreference();
        Assert.assertNotNull((Object)rp);
        Assert.assertEquals((Object)ReadPreference.primary(), (Object)rp);
    }

    @Test
    public void testReadPreferenceCaseInsenitive() {
        JsonObject config = new JsonObject();
        config.put("readPreference", (Object)"PRIMARY");
        ReadPreference rp = new ReadPreferenceParser(null, config).readPreference();
        Assert.assertNotNull((Object)rp);
        Assert.assertEquals((Object)ReadPreference.primary(), (Object)rp);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidReadPreference() {
        JsonObject config = new JsonObject();
        config.put("readPreference", (Object)"foo");
        new ReadPreferenceParser(null, config).readPreference();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTypeReadPreference() {
        JsonObject config = new JsonObject();
        config.put("readPreference", (Object)123);
        new ReadPreferenceParser(null, config);
    }

    @Test
    public void testReadPreferenceTags() {
        ArrayList<TagSet> tagSets = new ArrayList<TagSet>();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag("dc1", "ny"));
        tags.add(new Tag("dc2", "tx"));
        tags.add(new Tag("dc3", "ca"));
        tagSets.add(new TagSet(tags));
        tags = new ArrayList();
        tags.add(new Tag("ac1", "ny"));
        tags.add(new Tag("ac2", "tx"));
        tags.add(new Tag("ac3", "ca"));
        tagSets.add(new TagSet(tags));
        TaggableReadPreference expected = ReadPreference.valueOf((String)"nearest", tagSets);
        JsonObject config = new JsonObject();
        config.put("readPreference", (Object)"nearest");
        JsonArray array = new JsonArray();
        array.add((Object)"dc1:ny,dc2:tx,dc3:ca");
        array.add((Object)"ac1:ny,ac2:tx,ac3:ca");
        config.put("readPreferenceTags", (Object)array);
        ReadPreference rp = new ReadPreferenceParser(null, config).readPreference();
        Assert.assertNotNull((Object)rp);
        Assert.assertEquals((Object)expected, (Object)rp);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidReadPreferenceTag() {
        JsonObject config = new JsonObject();
        config.put("readPreference", (Object)"nearest");
        JsonArray array = new JsonArray();
        array.add((Object)"dc1:ny,foo,bar");
        config.put("readPreferenceTags", (Object)array);
        new ReadPreferenceParser(null, config).readPreference();
    }

    @Test(expected=ClassCastException.class)
    public void testInvalidReadPreferenceTagType() {
        JsonObject config = new JsonObject();
        config.put("readPreference", (Object)"nearest");
        JsonArray array = new JsonArray();
        array.add((Object)1);
        config.put("readPreferenceTags", (Object)array);
        new ReadPreferenceParser(null, config).readPreference();
    }

    @Test
    public void testConnStringNoReadPreference() {
        ConnectionString connString = new ConnectionString("mongodb://localhost:27017/mydb?replicaSet=myapp");
        ReadPreference rp = new ReadPreferenceParser(connString, new JsonObject()).readPreference();
        Assert.assertNull((Object)rp);
    }

    @Test
    public void testConnStringReadPreference() {
        ConnectionString connString = new ConnectionString("mongodb://localhost:27017/mydb?replicaSet=myapp&readPreference=primaryPreferred");
        ReadPreference rp = new ReadPreferenceParser(connString, new JsonObject()).readPreference();
        Assert.assertNotNull((Object)rp);
        Assert.assertEquals((Object)ReadPreference.primaryPreferred(), (Object)rp);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConnStringInvalidReadPreference() {
        ConnectionString connString = new ConnectionString("mongodb://localhost:27017/mydb?replicaSet=myapp&readPreference=foobar");
        new ReadPreferenceParser(connString, new JsonObject()).readPreference();
    }

    @Test
    public void testConnStringReadPreferenceTags() {
        ConnectionString connString = new ConnectionString("mongodb://localhost:27017/mydb?replicaSet=myapp&readPreference=nearest&readPreferenceTags=dc:ny,rack:1&readPreferenceTags=dc:ny&readPreferenceTags=");
        ArrayList<TagSet> tagSets = new ArrayList<TagSet>();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag("dc", "ny"));
        tags.add(new Tag("rack", "1"));
        tagSets.add(new TagSet(tags));
        tags = new ArrayList();
        tags.add(new Tag("dc", "ny"));
        tagSets.add(new TagSet(tags));
        tagSets.add(new TagSet());
        TaggableReadPreference expected = ReadPreference.valueOf((String)"nearest", tagSets);
        ReadPreference rp = new ReadPreferenceParser(connString, new JsonObject()).readPreference();
        Assert.assertNotNull((Object)rp);
        Assert.assertEquals((Object)expected, (Object)rp);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConnStringInvalidReadPreferenceTag() {
        ConnectionString connString = new ConnectionString("mongodb://localhost:27017/mydb?replicaSet=myapp&readPreference=nearest&readPreferenceTags=dc:ny,foo,bar");
        new ReadPreferenceParser(connString, new JsonObject()).readPreference();
    }
}

