/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.MongoClientSettings;
import com.mongodb.connection.SslSettings;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ParsingSSLOptionsTest {
    private Vertx vertx;
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Test
    public void ssl_should_be_disabled_by_default() {
        JsonObject configWithoutSSLInfo = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs");
        MongoClientSettings parsedSettings = new MongoClientOptionsParser(this.vertx, configWithoutSSLInfo).settings();
        Assert.assertFalse((boolean)parsedSettings.getSslSettings().isEnabled());
        Assert.assertFalse((boolean)parsedSettings.getSslSettings().isInvalidHostNameAllowed());
    }

    @Test
    public void one_should_be_able_to_enable_ssl_support_via_connection_string() {
        JsonObject withSSLEnabled = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs&ssl=true");
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLEnabled).settings().getSslSettings();
        Assert.assertTrue((boolean)sslSettings.isEnabled());
    }

    @Test
    public void one_should_be_able_to_enable_ssl_support_via_config_property() {
        JsonObject withSSLEnabled = new JsonObject().put("ssl", (Object)true);
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLEnabled).settings().getSslSettings();
        Assert.assertTrue((boolean)sslSettings.isEnabled());
    }

    @Test
    public void one_should_be_able_to_allow_invalid_host_names_via_connection_string() {
        JsonObject withSSLAndInvalidHostnameEnabled = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs&ssl=true&sslInvalidHostNameAllowed=true");
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLAndInvalidHostnameEnabled).settings().getSslSettings();
        Assert.assertTrue((boolean)sslSettings.isInvalidHostNameAllowed());
    }

    @Test
    public void one_should_be_able_to_allow_invalid_host_names_via_config_property() {
        JsonObject withSSLAndInvalidHostnameEnabled = new JsonObject().put("ssl", (Object)true).put("sslInvalidHostNameAllowed", (Object)true);
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLAndInvalidHostnameEnabled).settings().getSslSettings();
        Assert.assertTrue((boolean)sslSettings.isInvalidHostNameAllowed());
    }

    @Test
    public void testTrustAllProperty() {
        JsonObject withSSLAndTrustAllEnabled = new JsonObject().put("ssl", (Object)true).put("trustAll", (Object)true);
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLAndTrustAllEnabled).settings().getSslSettings();
        Assert.assertNotNull((Object)sslSettings.getContext());
    }

    @Test
    public void testEmptyCaPathProperty() {
        JsonObject withSSLwithoutCaPath = new JsonObject().put("ssl", (Object)true);
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLwithoutCaPath).settings().getSslSettings();
        Assert.assertNotNull((Object)sslSettings.getContext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCaPathProperty() {
        JsonObject withSSLAndCaPath = new JsonObject().put("ssl", (Object)true).put("caPath", (Object)"notExisting.pem");
        new MongoClientOptionsParser(this.vertx, withSSLAndCaPath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyCaPemCertificate() throws IOException {
        File tmpFile = this.tmpFolder.newFile("invalidCa.pem");
        JsonObject withSSLAndCaPath = new JsonObject().put("ssl", (Object)true).put("caPath", (Object)tmpFile.getAbsolutePath());
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLAndCaPath).settings().getSslSettings();
        Assert.assertNull((Object)sslSettings.getContext());
    }

    @Test
    public void testValidCaPemCertificate() throws IOException {
        File tmpFile = this.tmpFolder.newFile("validCa.pem");
        try (FileWriter tmpWriter = new FileWriter(tmpFile);){
            tmpWriter.write("-----BEGIN CERTIFICATE-----\nMIICljCCAfigAwIBAgIJAK0oe+f4DaojMAoGCCqGSM49BAMEMFkxCzAJBgNVBAYT\nAkFUMQ8wDQYDVQQIDAZWaWVubmExDjAMBgNVBAoMBU5vRW52MSkwJwYDVQQLDCBO\nb0VudiBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eTAeFw0xNjEwMjcxNTAwNTFa\nFw00NjEwMjAxNTAwNTFaMFkxCzAJBgNVBAYTAkFUMQ8wDQYDVQQIDAZWaWVubmEx\nDjAMBgNVBAoMBU5vRW52MSkwJwYDVQQLDCBOb0VudiBSb290IENlcnRpZmljYXRl\nIEF1dGhvcml0eTCBmzAQBgcqhkjOPQIBBgUrgQQAIwOBhgAEAHpsMQth12N0d+aE\nFIFRd8in4MTYZNSQEyQ4fuPDNq0Zb+4TXpUmedLZQJKkAQxorak8ESC/tXuQJDUL\nOoKa+R6NAT4EKR1aaVVd7clC9rfGqVwGYslppycy9zsN6O4XLUiripamQF78FzRF\n8wRZvkwYhzud+jpV6shgEMw3zmcwDSYKo2YwZDAdBgNVHQ4EFgQUD96n//91CReu\nCz1K0qics6aNFV0wHwYDVR0jBBgwFoAUD96n//91CReuCz1K0qics6aNFV0wEgYD\nVR0TAQH/BAgwBgEB/wIBATAOBgNVHQ8BAf8EBAMCAYYwCgYIKoZIzj0EAwQDgYsA\nMIGHAkFOxsApSB7fn8ZnYG/EUscn/uAkjxHsvdEkPKCC+XYCKMssW4YP2kR6gZjo\nJ8vaOAJZwNevBe/R9J8zMvsAWRJmWgJCAKLedGLnBuJOK9jjnKBwbVm5OIQfApMA\nI2mJVnNXvS12w4DTZlP0K1t63WxsykBBTOIVXnYdPkdZvvnoAIcfA7iM\n-----END CERTIFICATE-----");
        }
        JsonObject withSSLAndCaPath = new JsonObject().put("ssl", (Object)true).put("caPath", (Object)tmpFile.getAbsolutePath());
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLAndCaPath).settings().getSslSettings();
        Assert.assertNotNull((Object)sslSettings.getContext());
    }

    @Test
    public void testValidCaPemCertificateChain() throws IOException {
        File tmpFile = this.tmpFolder.newFile("validCa.pem");
        try (FileWriter tmpWriter = new FileWriter(tmpFile);){
            tmpWriter.write("-----BEGIN CERTIFICATE-----\nMIICljCCAfigAwIBAgIJAK0oe+f4DaojMAoGCCqGSM49BAMEMFkxCzAJBgNVBAYT\nAkFUMQ8wDQYDVQQIDAZWaWVubmExDjAMBgNVBAoMBU5vRW52MSkwJwYDVQQLDCBO\nb0VudiBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eTAeFw0xNjEwMjcxNTAwNTFa\nFw00NjEwMjAxNTAwNTFaMFkxCzAJBgNVBAYTAkFUMQ8wDQYDVQQIDAZWaWVubmEx\nDjAMBgNVBAoMBU5vRW52MSkwJwYDVQQLDCBOb0VudiBSb290IENlcnRpZmljYXRl\nIEF1dGhvcml0eTCBmzAQBgcqhkjOPQIBBgUrgQQAIwOBhgAEAHpsMQth12N0d+aE\nFIFRd8in4MTYZNSQEyQ4fuPDNq0Zb+4TXpUmedLZQJKkAQxorak8ESC/tXuQJDUL\nOoKa+R6NAT4EKR1aaVVd7clC9rfGqVwGYslppycy9zsN6O4XLUiripamQF78FzRF\n8wRZvkwYhzud+jpV6shgEMw3zmcwDSYKo2YwZDAdBgNVHQ4EFgQUD96n//91CReu\nCz1K0qics6aNFV0wHwYDVR0jBBgwFoAUD96n//91CReuCz1K0qics6aNFV0wEgYD\nVR0TAQH/BAgwBgEB/wIBATAOBgNVHQ8BAf8EBAMCAYYwCgYIKoZIzj0EAwQDgYsA\nMIGHAkFOxsApSB7fn8ZnYG/EUscn/uAkjxHsvdEkPKCC+XYCKMssW4YP2kR6gZjo\nJ8vaOAJZwNevBe/R9J8zMvsAWRJmWgJCAKLedGLnBuJOK9jjnKBwbVm5OIQfApMA\nI2mJVnNXvS12w4DTZlP0K1t63WxsykBBTOIVXnYdPkdZvvnoAIcfA7iM\n-----END CERTIFICATE-----\n-----BEGIN CERTIFICATE-----\nMIIE0zCCA7ugAwIBAgIQGNrRniZ96LtKIVjNzGs7SjANBgkqhkiG9w0BAQUFADCB\nyjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJp\nU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW\nZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0\naG9yaXR5IC0gRzUwHhcNMDYxMTA4MDAwMDAwWhcNMzYwNzE2MjM1OTU5WjCByjEL\nMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZW\nZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJpU2ln\nbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxWZXJp\nU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9y\naXR5IC0gRzUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvJAgIKXo1\nnmAMqudLO07cfLw8RRy7K+D+KQL5VwijZIUVJ/XxrcgxiV0i6CqqpkKzj/i5Vbex\nt0uz/o9+B1fs70PbZmIVYc9gDaTY3vjgw2IIPVQT60nKWVSFJuUrjxuf6/WhkcIz\nSdhDY2pSS9KP6HBRTdGJaXvHcPaz3BJ023tdS1bTlr8Vd6Gw9KIl8q8ckmcY5fQG\nBO+QueQA5N06tRn/Arr0PO7gi+s3i+z016zy9vA9r911kTMZHRxAy3QkGSGT2RT+\nrCpSx4/VBEnkjWNHiDxpg8v+R70rfk/Fla4OndTRQ8Bnc+MUCH7lP59zuDMKz10/\nNIeWiu5T6CUVAgMBAAGjgbIwga8wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8E\nBAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJaW1hZ2UvZ2lmMCEwHzAH\nBgUrDgMCGgQUj+XTGoasjY5rw8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVy\naXNpZ24uY29tL3ZzbG9nby5naWYwHQYDVR0OBBYEFH/TZafC3ey78DAJ80M5+gKv\nMzEzMA0GCSqGSIb3DQEBBQUAA4IBAQCTJEowX2LP2BqYLz3q3JktvXf2pXkiOOzE\np6B4Eq1iDkVwZMXnl2YtmAl+X6/WzChl8gGqCBpH3vn5fJJaCGkgDdk+bW48DW7Y\n5gaRQBi5+MHt39tBquCWIMnNZBU4gcmU7qKEKQsTb47bDN0lAtukixlE0kF6BWlK\nWE9gyn6CagsCqiUXObXbf+eEZSqVir2G3l6BFoMtEMze/aiCKm0oHw0LxOXnGiYZ\n4fQRbxC1lfznQgUy286dUV4otp6F01vvpX1FQHKOtw5rDgb7MzVIcbidJ4vEZV8N\nhnacRHr2lVz2XTIIM6RUthg/aFzyQkqFOFSDX9HoLPKsEdao7WNq\n-----END CERTIFICATE-----\n");
        }
        JsonObject withSSLAndCaPath = new JsonObject().put("ssl", (Object)true).put("caPath", (Object)tmpFile.getAbsolutePath());
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLAndCaPath).settings().getSslSettings();
        Assert.assertNotNull((Object)sslSettings.getContext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPemCertificate() throws IOException {
        File tmpFile = this.tmpFolder.newFile("brokenCa.pem");
        try (FileWriter tmpWriter = new FileWriter(tmpFile);){
            tmpWriter.write("-----BEGIN CERTIFICATE-----\nMIICljCCAfigAwIBAgI...BROKEN...xsykBBTOIVXnYdPkdZvvnoAIcfA7iM\n-----END CERTIFICATE-----");
        }
        JsonObject withSSLAndCaPath = new JsonObject().put("ssl", (Object)true).put("caPath", (Object)tmpFile.getAbsolutePath());
        new MongoClientOptionsParser(this.vertx, withSSLAndCaPath);
    }

    @Test
    public void testValidKeyAndCertificate() throws IOException {
        File tmpKeyFile = this.tmpFolder.newFile("validKey.pem");
        try (FileWriter tmpKeyWriter = new FileWriter(tmpKeyFile);){
            tmpKeyWriter.write("-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDVmCecLdUZU917\nhweVz4JqvZ9vZEi1rH+BG98HYfRR/h3QaobxPImZu3hzKHZ+MPbm94HunLPAVA9y\nZhvZMToNfOuD4TUPBPloBuNzwBfZk2O4CaXeG4ailVWUfm5t/l+RD/55zYKuhw1/\nVl9lcOryF2XAmPQ2F1gwEKK7wt1Ak8zw8/yeYgBv1/F+ibCMvR6FVj9ABBEfTM+o\nOs4oy51otUv0h63GqYgXMJyLX7q+AGWdC3srwwLQROtkzi7y00g/YryXUoIqdXEI\n7CrNL35rZXcZ5LfGRwFX9evX11PpT3OShYlsJBcFE9KMatRoIWd6xUKlxTk0yLjo\nOUE2tsMJAgMBAAECggEAdewZAjqzidYpU0eLQoRcBj5GRaNiGRrxEgCnM1Y7IwFe\nyG/nrEu11DASIdHXCXhS99Tx4SCWhLpkBM6m1VQ+LrAm/ppZRr+CSpJzBLaq9C5R\nQYviDSu5Ow2jP+ZFZWiorlfcMLbrTRu2sfSnmkOrEpkkTh6jxTFCONcWYP8GU93D\nYCA3hSH0li7CueS+GYJ1JB2Cd7buu+tOhl36AhBD96miExlgNn0YGpTJJ3I0Hb+O\nlKIIQy+KK8f9TXrSeZC3OYlTtJaIr9ejspTXxIYN11EIit5MFEwnnkCglcsePjsx\nqeOFRumJ5Nj5H8qyCNZ5MtzwbLkyktJzlumvnyr+AQKBgQDv/QfGKZJFeoCEWpoj\nf+078JxSYyPVNXxbbr2NuN/V79hJBol87ukycz2CZkDCubIKfubc50eXDmhWCp4p\naJgl6BMhnovftYrIrGWJLwqXnwFwsKJSrJJqHlHDJDRGfUSQEWNclNeaB3Mr8W46\nZcaadeikstvka9xKA1LOCG3oIQKBgQDj2FFOxZK27KhY/9Oz1dUsPtAYYbLOor/P\nRbne3jICQStH3dnUEmWKIKrdYV1u2saw5djn3ujwB0xEXydRvRgiSF0qxYjbm9CG\nTJaiHhTsQDjWkYMZaxk3gc7Yfh8DHF0wlvWpu1wMXNsCJ6jxqW2e+jSRioZICPK6\nMcWWmArd6QKBgDWjoHEyKXdOAhuTBJCarzOOe+IONpwY8EqfXc6nW6A9k2H/DAvY\nelbEWyMiJ6deSeT+qCsHpoCkv707ck5fCmKulFgXT7wYn4Rqw+b9lKh+6Zt+X0mL\nOM5vKGctWGHI7eIlgMfYnLfYom1X8QMsbE9puy3UrEFJulrwkzlpuOcBAoGAVRNV\nsNsXIFSXu7uyueizU3UU0LXSRVQB2QxJDg3bkHnzBj+xcX15Cq2N/2G2uIjaPf1l\nE5dpVQ70jGcXUG8SDuMEXs8pfg7dOvhoGpqu51RHpN7qm9ggr1g5+x6Ex+2UYmtL\nyZfbFAasBE74x1ujQgRdEqct4sHsmFezVrro+9kCgYEAgl70mKk9yK/f7515OaO0\nY39tgVzpAG6RN1NKnY6NR5VNNemZx5jhKfk5byaYxX4XBjygD0sQ5KTpaZmoQIIX\nFxuwhLRRMn6vtsEf1HexJAtRd82aL5wKS62l0AXG/CVLAygn4aSSqLrgTyFFVUR3\ncASPpPIdZaKZG6q4Hmcpl58=\n-----END PRIVATE KEY-----");
        }
        File tmpCertFile = this.tmpFolder.newFile("validCert.pem");
        try (FileWriter tmpCertWriter = new FileWriter(tmpCertFile);){
            tmpCertWriter.write("-----BEGIN CERTIFICATE-----\nMIICwTCCAamgAwIBAgIEBeVm4jANBgkqhkiG9w0BAQsFADARMQ8wDQYDVQQDEwZj\nbGllbnQwHhcNMTgwNTI2MTEzNjUxWhcNMjEwNTI1MTEzNjUxWjARMQ8wDQYDVQQD\nEwZjbGllbnQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDVmCecLdUZ\nU917hweVz4JqvZ9vZEi1rH+BG98HYfRR/h3QaobxPImZu3hzKHZ+MPbm94HunLPA\nVA9yZhvZMToNfOuD4TUPBPloBuNzwBfZk2O4CaXeG4ailVWUfm5t/l+RD/55zYKu\nhw1/Vl9lcOryF2XAmPQ2F1gwEKK7wt1Ak8zw8/yeYgBv1/F+ibCMvR6FVj9ABBEf\nTM+oOs4oy51otUv0h63GqYgXMJyLX7q+AGWdC3srwwLQROtkzi7y00g/YryXUoIq\ndXEI7CrNL35rZXcZ5LfGRwFX9evX11PpT3OShYlsJBcFE9KMatRoIWd6xUKlxTk0\nyLjoOUE2tsMJAgMBAAGjITAfMB0GA1UdDgQWBBQ6xJBQsJCJdj/u0iTLYYD2qQsB\nDDANBgkqhkiG9w0BAQsFAAOCAQEAfoquV375+eAGmfnlLxB30v9VhsFckrxFVpYs\nXXC6h2G8MtXLpIEpgJo+4SZ4YjNwf/8m9J5j/duU8RukYanyzJdgkFFqKDBYCX7U\nSD1nQP7729KnQgxtbR/+i3zkNgo7FATdkLq+HOxklNOEE24Ldenya39bsG779B9n\nSskcbq++7rMM+onDYBv6PbUKCm6nfqPspq809CLxSaUJg9+9ykut6hiyke/i7GEP\nXIZHrM+mEvG00ES/zBIdV6TE0AIBP7q2MN7ylT509Ko9sUBMOZdEzikYp5GaRdiv\nzG9q6rqK5COK614BwJFOD1DKV1BoDFsgugvfvm/mrc3QfIUPDA==\n-----END CERTIFICATE-----");
        }
        JsonObject withSSLAndCertKeyPath = new JsonObject().put("ssl", (Object)true).put("keyPath", (Object)tmpKeyFile.getAbsolutePath()).put("certPath", (Object)tmpCertFile.getAbsolutePath());
        SslSettings sslSettings = new MongoClientOptionsParser(this.vertx, withSSLAndCertKeyPath).settings().getSslSettings();
        Assert.assertNotNull((Object)sslSettings.getContext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidKey() throws IOException {
        File tmpKeyFile = this.tmpFolder.newFile("brokenKey.pem");
        try (FileWriter tmpKeyWriter = new FileWriter(tmpKeyFile);){
            tmpKeyWriter.write("-----BEGIN CERTIFICATE-----\nMIICljCCAfigAwIBAgI...BROKEN...xsykBBTOIVXnYdPkdZvvnoAIcfA7iM\n-----END CERTIFICATE-----");
        }
        File tmpCertFile = this.tmpFolder.newFile("validCert.pem");
        try (FileWriter tmpCertWriter = new FileWriter(tmpCertFile);){
            tmpCertWriter.write("-----BEGIN CERTIFICATE-----\nMIICwTCCAamgAwIBAgIEBeVm4jANBgkqhkiG9w0BAQsFADARMQ8wDQYDVQQDEwZj\nbGllbnQwHhcNMTgwNTI2MTEzNjUxWhcNMjEwNTI1MTEzNjUxWjARMQ8wDQYDVQQD\nEwZjbGllbnQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDVmCecLdUZ\nU917hweVz4JqvZ9vZEi1rH+BG98HYfRR/h3QaobxPImZu3hzKHZ+MPbm94HunLPA\nVA9yZhvZMToNfOuD4TUPBPloBuNzwBfZk2O4CaXeG4ailVWUfm5t/l+RD/55zYKu\nhw1/Vl9lcOryF2XAmPQ2F1gwEKK7wt1Ak8zw8/yeYgBv1/F+ibCMvR6FVj9ABBEf\nTM+oOs4oy51otUv0h63GqYgXMJyLX7q+AGWdC3srwwLQROtkzi7y00g/YryXUoIq\ndXEI7CrNL35rZXcZ5LfGRwFX9evX11PpT3OShYlsJBcFE9KMatRoIWd6xUKlxTk0\nyLjoOUE2tsMJAgMBAAGjITAfMB0GA1UdDgQWBBQ6xJBQsJCJdj/u0iTLYYD2qQsB\nDDANBgkqhkiG9w0BAQsFAAOCAQEAfoquV375+eAGmfnlLxB30v9VhsFckrxFVpYs\nXXC6h2G8MtXLpIEpgJo+4SZ4YjNwf/8m9J5j/duU8RukYanyzJdgkFFqKDBYCX7U\nSD1nQP7729KnQgxtbR/+i3zkNgo7FATdkLq+HOxklNOEE24Ldenya39bsG779B9n\nSskcbq++7rMM+onDYBv6PbUKCm6nfqPspq809CLxSaUJg9+9ykut6hiyke/i7GEP\nXIZHrM+mEvG00ES/zBIdV6TE0AIBP7q2MN7ylT509Ko9sUBMOZdEzikYp5GaRdiv\nzG9q6rqK5COK614BwJFOD1DKV1BoDFsgugvfvm/mrc3QfIUPDA==\n-----END CERTIFICATE-----");
        }
        JsonObject withSSLAndCertKeyPath = new JsonObject().put("ssl", (Object)true).put("keyPath", (Object)tmpKeyFile.getAbsolutePath()).put("certPath", (Object)tmpCertFile.getAbsolutePath());
        new MongoClientOptionsParser(this.vertx, withSSLAndCertKeyPath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCertificate() throws IOException {
        File tmpKeyFile = this.tmpFolder.newFile("validKey.pem");
        try (FileWriter tmpKeyWriter = new FileWriter(tmpKeyFile);){
            tmpKeyWriter.write("-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDVmCecLdUZU917\nhweVz4JqvZ9vZEi1rH+BG98HYfRR/h3QaobxPImZu3hzKHZ+MPbm94HunLPAVA9y\nZhvZMToNfOuD4TUPBPloBuNzwBfZk2O4CaXeG4ailVWUfm5t/l+RD/55zYKuhw1/\nVl9lcOryF2XAmPQ2F1gwEKK7wt1Ak8zw8/yeYgBv1/F+ibCMvR6FVj9ABBEfTM+o\nOs4oy51otUv0h63GqYgXMJyLX7q+AGWdC3srwwLQROtkzi7y00g/YryXUoIqdXEI\n7CrNL35rZXcZ5LfGRwFX9evX11PpT3OShYlsJBcFE9KMatRoIWd6xUKlxTk0yLjo\nOUE2tsMJAgMBAAECggEAdewZAjqzidYpU0eLQoRcBj5GRaNiGRrxEgCnM1Y7IwFe\nyG/nrEu11DASIdHXCXhS99Tx4SCWhLpkBM6m1VQ+LrAm/ppZRr+CSpJzBLaq9C5R\nQYviDSu5Ow2jP+ZFZWiorlfcMLbrTRu2sfSnmkOrEpkkTh6jxTFCONcWYP8GU93D\nYCA3hSH0li7CueS+GYJ1JB2Cd7buu+tOhl36AhBD96miExlgNn0YGpTJJ3I0Hb+O\nlKIIQy+KK8f9TXrSeZC3OYlTtJaIr9ejspTXxIYN11EIit5MFEwnnkCglcsePjsx\nqeOFRumJ5Nj5H8qyCNZ5MtzwbLkyktJzlumvnyr+AQKBgQDv/QfGKZJFeoCEWpoj\nf+078JxSYyPVNXxbbr2NuN/V79hJBol87ukycz2CZkDCubIKfubc50eXDmhWCp4p\naJgl6BMhnovftYrIrGWJLwqXnwFwsKJSrJJqHlHDJDRGfUSQEWNclNeaB3Mr8W46\nZcaadeikstvka9xKA1LOCG3oIQKBgQDj2FFOxZK27KhY/9Oz1dUsPtAYYbLOor/P\nRbne3jICQStH3dnUEmWKIKrdYV1u2saw5djn3ujwB0xEXydRvRgiSF0qxYjbm9CG\nTJaiHhTsQDjWkYMZaxk3gc7Yfh8DHF0wlvWpu1wMXNsCJ6jxqW2e+jSRioZICPK6\nMcWWmArd6QKBgDWjoHEyKXdOAhuTBJCarzOOe+IONpwY8EqfXc6nW6A9k2H/DAvY\nelbEWyMiJ6deSeT+qCsHpoCkv707ck5fCmKulFgXT7wYn4Rqw+b9lKh+6Zt+X0mL\nOM5vKGctWGHI7eIlgMfYnLfYom1X8QMsbE9puy3UrEFJulrwkzlpuOcBAoGAVRNV\nsNsXIFSXu7uyueizU3UU0LXSRVQB2QxJDg3bkHnzBj+xcX15Cq2N/2G2uIjaPf1l\nE5dpVQ70jGcXUG8SDuMEXs8pfg7dOvhoGpqu51RHpN7qm9ggr1g5+x6Ex+2UYmtL\nyZfbFAasBE74x1ujQgRdEqct4sHsmFezVrro+9kCgYEAgl70mKk9yK/f7515OaO0\nY39tgVzpAG6RN1NKnY6NR5VNNemZx5jhKfk5byaYxX4XBjygD0sQ5KTpaZmoQIIX\nFxuwhLRRMn6vtsEf1HexJAtRd82aL5wKS62l0AXG/CVLAygn4aSSqLrgTyFFVUR3\ncASPpPIdZaKZG6q4Hmcpl58=\n-----END PRIVATE KEY-----");
        }
        File tmpCertFile = this.tmpFolder.newFile("brokenCert.pem");
        try (FileWriter tmpCertWriter = new FileWriter(tmpCertFile);){
            tmpCertWriter.write("-----BEGIN CERTIFICATE-----\nMIICwTCCAamgAwIBA...BROKEN...FOD1DKV1BoDFsgugvfvm/mrc3QfIUPDA==\n-----END CERTIFICATE-----");
        }
        JsonObject withSSLAndCertKeyPath = new JsonObject().put("ssl", (Object)true).put("keyPath", (Object)tmpKeyFile.getAbsolutePath()).put("certPath", (Object)tmpCertFile.getAbsolutePath());
        new MongoClientOptionsParser(this.vertx, withSSLAndCertKeyPath);
    }
}

