/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.ConnectionString;
import com.mongodb.MongoCredential;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.CredentialListParser;
import io.vertx.test.core.TestUtils;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CredentialListParserTest {
    @Test
    public void testConnectionString() {
        String username = TestUtils.randomAlphaString((int)8);
        String password = TestUtils.randomAlphaString((int)20);
        ConnectionString connectionString = new ConnectionString(String.format("mongodb://%s:%s@%s/%s", username, password, "localhost:27017", "my-datasource"));
        List credentials = new CredentialListParser(connectionString, null).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertArrayEquals((char[])password.toCharArray(), (char[])credential.getPassword());
        Assert.assertEquals((Object)"my-datasource", (Object)credential.getSource());
    }

    @Test
    public void testSimpleAuth() {
        JsonObject config = new JsonObject().put("db_name", (Object)"my-datasource");
        String username = TestUtils.randomAlphaString((int)8);
        String password = TestUtils.randomAlphaString((int)20);
        config.put("username", (Object)username);
        config.put("password", (Object)password);
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertArrayEquals((char[])password.toCharArray(), (char[])credential.getPassword());
        Assert.assertEquals((Object)"my-datasource", (Object)credential.getSource());
    }

    @Test
    public void testSimpleAuthWithSource() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        String password = TestUtils.randomAlphaString((int)20);
        String authSource = TestUtils.randomAlphaString((int)10);
        config.put("username", (Object)username);
        config.put("password", (Object)password);
        config.put("authSource", (Object)authSource);
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertArrayEquals((char[])password.toCharArray(), (char[])credential.getPassword());
        Assert.assertEquals((Object)authSource, (Object)credential.getSource());
    }

    @Test
    public void testAuth_GSSAPI() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        String authSource = TestUtils.randomAlphaString((int)10);
        config.put("username", (Object)username);
        config.put("authSource", (Object)authSource);
        config.put("authMechanism", (Object)"GSSAPI");
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertNotEquals((Object)authSource, (Object)credential.getSource());
        Assert.assertEquals((Object)AuthenticationMechanism.GSSAPI, (Object)credential.getAuthenticationMechanism());
    }

    @Test
    public void testAuth_GSSAPI_WithServiceName() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        String authSource = TestUtils.randomAlphaString((int)10);
        String serviceName = TestUtils.randomAlphaString((int)11);
        config.put("username", (Object)username);
        config.put("authSource", (Object)authSource);
        config.put("authMechanism", (Object)"GSSAPI");
        config.put("gssapiServiceName", (Object)serviceName);
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertNotEquals((Object)authSource, (Object)credential.getSource());
        Assert.assertEquals((Object)AuthenticationMechanism.GSSAPI, (Object)credential.getAuthenticationMechanism());
        Assert.assertEquals((Object)serviceName, (Object)credential.getMechanismProperty("SERVICE_NAME", null));
    }

    @Test
    public void testAuth_PLAIN() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        String password = TestUtils.randomAlphaString((int)20);
        String authSource = TestUtils.randomAlphaString((int)10);
        config.put("username", (Object)username);
        config.put("password", (Object)password);
        config.put("authSource", (Object)authSource);
        config.put("authMechanism", (Object)"PLAIN");
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertArrayEquals((char[])password.toCharArray(), (char[])credential.getPassword());
        Assert.assertEquals((Object)authSource, (Object)credential.getSource());
        Assert.assertEquals((Object)AuthenticationMechanism.PLAIN, (Object)credential.getAuthenticationMechanism());
    }

    @Test
    public void testAuth_MONGODB_X509() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        String authSource = TestUtils.randomAlphaString((int)10);
        config.put("username", (Object)username);
        config.put("authSource", (Object)authSource);
        config.put("authMechanism", (Object)"MONGODB-X509");
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertNotEquals((Object)authSource, (Object)credential.getSource());
        Assert.assertEquals((Object)AuthenticationMechanism.MONGODB_X509, (Object)credential.getAuthenticationMechanism());
    }

    @Test
    public void testAuth_MONGODB_X509_without_username() {
        JsonObject config = new JsonObject();
        String authSource = TestUtils.randomAlphaString((int)10);
        config.put("authSource", (Object)authSource);
        config.put("authMechanism", (Object)"MONGODB-X509");
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertNull((Object)credential.getUserName());
        Assert.assertNotEquals((Object)authSource, (Object)credential.getSource());
        Assert.assertEquals((Object)AuthenticationMechanism.MONGODB_X509, (Object)credential.getAuthenticationMechanism());
    }

    @Test
    public void testAuth_SCRAM_SHA_1() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        String password = TestUtils.randomAlphaString((int)20);
        String authSource = TestUtils.randomAlphaString((int)10);
        config.put("username", (Object)username);
        config.put("password", (Object)password);
        config.put("authSource", (Object)authSource);
        config.put("authMechanism", (Object)"SCRAM-SHA-1");
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertArrayEquals((char[])password.toCharArray(), (char[])credential.getPassword());
        Assert.assertEquals((Object)authSource, (Object)credential.getSource());
        Assert.assertEquals((Object)AuthenticationMechanism.SCRAM_SHA_1, (Object)credential.getAuthenticationMechanism());
    }

    @Test
    public void testAuth_SCRAM_SHA_256() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        String password = TestUtils.randomAlphaString((int)20);
        String authSource = TestUtils.randomAlphaString((int)10);
        config.put("username", (Object)username);
        config.put("password", (Object)password);
        config.put("authSource", (Object)authSource);
        config.put("authMechanism", (Object)"SCRAM-SHA-256");
        List credentials = new CredentialListParser(null, config).credentials();
        Assert.assertEquals((long)1L, (long)credentials.size());
        MongoCredential credential = (MongoCredential)credentials.get(0);
        Assert.assertEquals((Object)username, (Object)credential.getUserName());
        Assert.assertArrayEquals((char[])password.toCharArray(), (char[])credential.getPassword());
        Assert.assertEquals((Object)authSource, (Object)credential.getSource());
        Assert.assertEquals((Object)AuthenticationMechanism.SCRAM_SHA_256, (Object)credential.getAuthenticationMechanism());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuth_Invalid() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        String password = TestUtils.randomAlphaString((int)20);
        String authSource = TestUtils.randomAlphaString((int)10);
        config.put("username", (Object)username);
        config.put("password", (Object)password);
        config.put("authSource", (Object)authSource);
        config.put("authMechanism", (Object)"FOO-BAR");
        new CredentialListParser(null, config).credentials();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuth_NoPassword() {
        JsonObject config = new JsonObject();
        String username = TestUtils.randomAlphaString((int)8);
        config.put("username", (Object)username);
        new CredentialListParser(null, config).credentials();
    }
}

