/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.connection.ConnectionPoolSettings;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.ConnectionPoolSettingsParser;
import io.vertx.test.core.TestUtils;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionPoolSettingsParserTest {
    @Test
    public void testConnectionPoolSettings() {
        int maxPoolSize = 42;
        int minPoolSize = maxPoolSize / 2;
        long maxIdleTimeMS = Math.abs(TestUtils.randomLong());
        long maxLifeTimeMS = Math.abs(TestUtils.randomLong());
        long waitQueueTimeoutMS = Math.abs(TestUtils.randomLong());
        long maintenanceInitialDelayMS = Math.abs(TestUtils.randomLong());
        long maintenanceFrequencyMS = Math.abs(TestUtils.randomLong());
        JsonObject config = new JsonObject();
        config.put("maxPoolSize", (Object)maxPoolSize);
        config.put("minPoolSize", (Object)minPoolSize);
        config.put("maxIdleTimeMS", (Object)maxIdleTimeMS);
        config.put("maxLifeTimeMS", (Object)maxLifeTimeMS);
        config.put("waitQueueTimeoutMS", (Object)waitQueueTimeoutMS);
        config.put("maintenanceInitialDelayMS", (Object)maintenanceInitialDelayMS);
        config.put("maintenanceFrequencyMS", (Object)maintenanceFrequencyMS);
        ConnectionPoolSettings settings = new ConnectionPoolSettingsParser(null, config).settings();
        Assert.assertEquals((long)maxPoolSize, (long)settings.getMaxSize());
        Assert.assertEquals((long)minPoolSize, (long)settings.getMinSize());
        Assert.assertEquals((long)maxIdleTimeMS, (long)settings.getMaxConnectionIdleTime(TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)maxLifeTimeMS, (long)settings.getMaxConnectionLifeTime(TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)waitQueueTimeoutMS, (long)settings.getMaxWaitTime(TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)maintenanceInitialDelayMS, (long)settings.getMaintenanceInitialDelay(TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)maintenanceFrequencyMS, (long)settings.getMaintenanceFrequency(TimeUnit.MILLISECONDS));
    }
}

