/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.MongoCompressor;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressorsSettingsParserTest {
    private Vertx vertx;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Test
    public void testCompressorsConnectionString() {
        String connectionString = "mongodb://localhost:27017/?compressors=zstd,zlib&zlibCompressionLevel=1";
        JsonObject config = new JsonObject().put("connection_string", (Object)connectionString);
        MongoClientOptionsParser parser = new MongoClientOptionsParser(this.vertx, config);
        List compressorList = parser.settings().getCompressorList();
        Assert.assertEquals((Object)"zstd", (Object)((MongoCompressor)compressorList.get(0)).getName());
        Assert.assertEquals((Object)"zlib", (Object)((MongoCompressor)compressorList.get(1)).getName());
        Assert.assertEquals((long)1L, (long)((Integer)((MongoCompressor)compressorList.get(1)).getPropertyNonNull("LEVEL", (Object)0)).intValue());
        Assert.assertEquals((long)2L, (long)compressorList.size());
    }

    @Test
    public void testCompressorsConfig() {
        String connectionString = "mongodb://localhost:27017/?compressors=zstd,zlib&zlibCompressionLevel=1";
        JsonObject config = new JsonObject().put("connection_string", (Object)connectionString).put("compressors", (Object)new JsonArray().add((Object)"snappy").add((Object)"zstd").add((Object)"zlib")).put("zlibCompressionLevel", (Object)6);
        MongoClientOptionsParser parser = new MongoClientOptionsParser(this.vertx, config);
        List compressorList = parser.settings().getCompressorList();
        Assert.assertEquals((Object)"snappy", (Object)((MongoCompressor)compressorList.get(0)).getName());
        Assert.assertEquals((Object)"zstd", (Object)((MongoCompressor)compressorList.get(1)).getName());
        Assert.assertEquals((Object)"zlib", (Object)((MongoCompressor)compressorList.get(2)).getName());
        Assert.assertEquals((long)6L, (long)((Integer)((MongoCompressor)compressorList.get(2)).getPropertyNonNull("LEVEL", (Object)0)).intValue());
        Assert.assertEquals((long)3L, (long)compressorList.size());
    }
}

