/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.codec.json;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.codec.json.JsonObjectCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.junit.Assert;
import org.junit.Test;

public class JsonObjectCodecTest {
    private JsonObject options = new JsonObject();

    @Test
    public void getBsonType_returnsDateTimeType_WhenValueIsJsonObjectAndContainsDateField() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        JsonObject value = new JsonObject();
        value.put("$date", (Object)"2015-05-30T22:50:02+02:00");
        Assert.assertEquals((Object)BsonType.DATE_TIME, (Object)codec.getBsonType((Object)value));
    }

    @Test
    public void writeDocument_supportBsonDateTime() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        OffsetDateTime now = OffsetDateTime.now();
        JsonObject dateValue = new JsonObject();
        dateValue.put("$date", (Object)now.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        JsonObject value = new JsonObject();
        value.put("test", (Object)dateValue);
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resultValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.DATE_TIME, (Object)resultValue.getBsonType());
        Assert.assertEquals((long)now.toInstant().toEpochMilli(), (long)resultValue.asDateTime().getValue());
    }

    @Test
    public void readDocument_supportBsonDateTime() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        Instant now = Instant.now();
        BsonDocument bson = new BsonDocument();
        bson.append("test", (BsonValue)new BsonDateTime(now.toEpochMilli()));
        BsonDocumentReader reader = new BsonDocumentReader(bson);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        JsonObject resultValue = result.getJsonObject("test");
        Assert.assertEquals((Object)Instant.ofEpochMilli(now.toEpochMilli()), (Object)OffsetDateTime.parse(resultValue.getString("$date")).toInstant());
    }

    @Test
    public void writeDocument_supportBsonDateTimeWithMillis() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        JsonObject dateValue = new JsonObject();
        dateValue.put("$date", (Object)"2011-12-03T10:15:30.500+01:00");
        JsonObject value = new JsonObject();
        value.put("test", (Object)dateValue);
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        long millis = 1322903730500L;
        BsonValue resultValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.DATE_TIME, (Object)resultValue.getBsonType());
        Assert.assertEquals((long)millis, (long)resultValue.asDateTime().getValue());
        String back = OffsetDateTime.ofInstant(Instant.ofEpochMilli(1322903730500L), ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Assert.assertEquals((Object)"2011-12-03T09:15:30.5Z", (Object)back);
    }

    @Test
    public void writeDocument_supportBsonBinary() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        OffsetDateTime now = OffsetDateTime.now();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(now);
            oos.close();
            JsonObject binaryJson = new JsonObject();
            binaryJson.put("$binary", (Object)baos.toByteArray());
            JsonObject value = new JsonObject();
            value.put("test", (Object)binaryJson);
            BsonDocument bsonResult = new BsonDocument();
            BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
            codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
            BsonValue resultValue = bsonResult.get((Object)"test");
            Assert.assertEquals((Object)BsonType.BINARY, (Object)resultValue.getBsonType());
            BsonBinary bsonBinary = resultValue.asBinary();
            ByteArrayInputStream bais = new ByteArrayInputStream(bsonBinary.getData());
            ObjectInputStream ois = new ObjectInputStream(bais);
            OffsetDateTime reconstitutedNow = (OffsetDateTime)ois.readObject();
            Assert.assertEquals((Object)now, (Object)reconstitutedNow);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void writeDocument_supportBsonBinaryUUID() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        UUID uuid = UUID.randomUUID();
        byte[] byteUuid = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
        JsonObject value = new JsonObject();
        value.put("test", (Object)new JsonObject().put("$binary", (Object)byteUuid).put("$type", (Object)BsonBinarySubType.UUID_STANDARD.getValue()));
        BsonDocument bsonDocument = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonDocument);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resultValue = bsonDocument.get((Object)"test");
        Assert.assertEquals((Object)BsonType.BINARY, (Object)resultValue.getBsonType());
        BsonBinary bsonBinary = resultValue.asBinary();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bsonBinary.getData());
        Assert.assertEquals((long)BsonBinarySubType.UUID_STANDARD.getValue(), (long)bsonBinary.getType());
        Assert.assertEquals((Object)uuid, (Object)new UUID(byteBuffer.getLong(), byteBuffer.getLong()));
    }

    @Test
    public void readDocument_supportBsonBinaryUUID() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        BsonDocument bsonDocument = new BsonDocument();
        UUID uuid = UUID.randomUUID();
        byte[] byteUuid = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
        bsonDocument.put("test", (BsonValue)new BsonBinary(BsonBinarySubType.UUID_STANDARD, byteUuid));
        BsonDocumentReader reader = new BsonDocumentReader(bsonDocument);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        JsonObject resultValue = result.getJsonObject("test");
        Assert.assertTrue((boolean)resultValue.containsKey("$binary"));
        Assert.assertTrue((boolean)resultValue.containsKey("$type"));
        ByteBuffer byteBuffer = ByteBuffer.wrap(resultValue.getBinary("$binary"));
        Assert.assertEquals((Object)BsonBinarySubType.UUID_STANDARD.getValue(), (Object)resultValue.getInteger("$type"));
        Assert.assertEquals((Object)uuid, (Object)new UUID(byteBuffer.getLong(), byteBuffer.getLong()));
    }

    @Test
    public void readDocument_supportBsonBinary() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        Instant now = Instant.now();
        BsonDocument bson = new BsonDocument();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(now);
            oos.close();
            bson.append("test", (BsonValue)new BsonBinary(baos.toByteArray()));
            BsonDocumentReader reader = new BsonDocumentReader(bson);
            JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
            JsonObject resultValue = result.getJsonObject("test");
            byte[] bytes = resultValue.getBinary("$binary");
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Instant reconstitutedNow = (Instant)ois.readObject();
            Assert.assertEquals((Object)now, (Object)reconstitutedNow);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void readDocument_supportObjectId() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        BsonDocument bson = new BsonDocument();
        ObjectId objectId = new ObjectId();
        bson.append("test", (BsonValue)new BsonObjectId(objectId));
        BsonDocumentReader reader = new BsonDocumentReader(bson);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        String sObjectId = result.getJsonObject("test").getString("$oid");
        Assert.assertEquals((Object)objectId.toHexString(), (Object)sObjectId);
    }

    @Test
    public void writeDocument_supportObjectId() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        ObjectId objectId = new ObjectId();
        JsonObject oidJson = new JsonObject();
        oidJson.put("$oid", (Object)objectId.toHexString());
        JsonObject value = new JsonObject();
        value.put("test", (Object)oidJson);
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resultValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.OBJECT_ID, (Object)resultValue.getBsonType());
        BsonObjectId bsonObjectId = resultValue.asObjectId();
        Assert.assertEquals((Object)objectId.toHexString(), (Object)bsonObjectId.getValue().toHexString());
    }

    @Test
    public void readDocument_supportBsonTimeStamp() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        int time = (int)(System.currentTimeMillis() / 1000L);
        int increment = 5;
        BsonDocument bson = new BsonDocument();
        bson.append("test", (BsonValue)new BsonTimestamp(time, increment));
        BsonDocumentReader reader = new BsonDocumentReader(bson);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        JsonObject timeStampValue = result.getJsonObject("test").getJsonObject("$timestamp");
        Assert.assertEquals((long)time, (long)timeStampValue.getInteger("t").intValue());
        Assert.assertEquals((long)increment, (long)timeStampValue.getInteger("i").intValue());
    }

    @Test
    public void writeDocument_supportBsonTimeStamp() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        int time = (int)(System.currentTimeMillis() / 1000L);
        int increment = 5;
        JsonObject timeStampComponent = new JsonObject();
        timeStampComponent.put("t", (Object)time);
        timeStampComponent.put("i", (Object)increment);
        JsonObject timeStamp = new JsonObject();
        timeStamp.put("$timestamp", (Object)timeStampComponent);
        JsonObject value = new JsonObject();
        value.put("test", (Object)timeStamp);
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resultValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.TIMESTAMP, (Object)resultValue.getBsonType());
        Assert.assertEquals((long)time, (long)resultValue.asTimestamp().getTime());
        Assert.assertEquals((long)increment, (long)resultValue.asTimestamp().getInc());
    }

    @Test
    public void hexStringAsKeyDefault() {
        JsonObject document = new JsonObject();
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        document = codec.generateIdIfAbsentFromDocument(document);
        Assert.assertTrue((boolean)document.containsKey("_id"));
        Assert.assertTrue((boolean)(document.getValue("_id") instanceof String));
    }

    @Test
    public void objectIdAsKeySpecified() {
        JsonObject customOptions = new JsonObject().put("useObjectId", (Object)false);
        JsonObject document = new JsonObject();
        JsonObjectCodec codec = new JsonObjectCodec(customOptions);
        document = codec.generateIdIfAbsentFromDocument(document);
        Assert.assertTrue((boolean)document.containsKey("_id"));
        Assert.assertTrue((boolean)(document.getValue("_id") instanceof String));
    }

    @Test
    public void objectIdAsKey() {
        JsonObject customOptions = new JsonObject().put("useObjectId", (Object)true);
        JsonObject document = new JsonObject();
        JsonObjectCodec codec = new JsonObjectCodec(customOptions);
        document = codec.generateIdIfAbsentFromDocument(document);
        Assert.assertTrue((boolean)document.containsKey("_id"));
        Assert.assertTrue((boolean)(document.getValue("_id") instanceof JsonObject));
        Assert.assertTrue((boolean)document.getJsonObject("_id").containsKey("$oid"));
    }

    @Test
    public void writeDocument_supportNumberInt() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        int i = 24;
        JsonObject value = new JsonObject();
        value.put("test", (Object)i);
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resutlValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.INT32, (Object)resutlValue.getBsonType());
        BsonInt32 bsonInt32 = resutlValue.asInt32();
        Assert.assertEquals((long)i, (long)bsonInt32.getValue());
    }

    @Test
    public void readDocument_supportNumberInt() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        int i = 24;
        BsonDocument bson = new BsonDocument();
        bson.append("test", (BsonValue)new BsonInt32(i));
        BsonDocumentReader reader = new BsonDocumentReader(bson);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        int numberIntValue = result.getInteger("test");
        Assert.assertEquals((long)i, (long)numberIntValue);
    }

    @Test
    public void writeDocument_supportNumberLong() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        long l = Long.MAX_VALUE;
        JsonObject value = new JsonObject();
        value.put("test", (Object)new JsonObject().put("$numberLong", (Object)l));
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resutlValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.INT64, (Object)resutlValue.getBsonType());
        BsonInt64 bsonInt64 = resutlValue.asInt64();
        Assert.assertEquals((long)l, (long)bsonInt64.getValue());
    }

    @Test
    public void readDocument_supportNumberLong() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        long l = Long.MAX_VALUE;
        BsonDocument bson = new BsonDocument();
        BsonDocument numberLong = new BsonDocument();
        numberLong.append("$numberLong", (BsonValue)new BsonInt64(l));
        bson.append("test", (BsonValue)numberLong);
        BsonDocumentReader reader = new BsonDocumentReader(bson);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        long numberLongValue = result.getJsonObject("test").getLong("$numberLong");
        Assert.assertEquals((long)l, (long)numberLongValue);
    }

    @Test
    public void writeDocument_supportNumberDouble() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        double d = Double.MAX_VALUE;
        JsonObject value = new JsonObject();
        value.put("test", (Object)d);
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resutlValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.DOUBLE, (Object)resutlValue.getBsonType());
        BsonDouble bsonDouble = resutlValue.asDouble();
        Assert.assertEquals((double)d, (double)bsonDouble.getValue(), (double)0.0);
    }

    @Test
    public void readDocument_supportNumberDouble() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        double d = Double.MAX_VALUE;
        BsonDocument bson = new BsonDocument();
        bson.append("test", (BsonValue)new BsonDouble(d));
        BsonDocumentReader reader = new BsonDocumentReader(bson);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        double numberDoubleValue = result.getDouble("test");
        Assert.assertEquals((double)d, (double)numberDoubleValue, (double)0.0);
    }

    @Test
    public void writeDocument_supportNumberFloat() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        float f = 1.123f;
        JsonObject value = new JsonObject();
        value.put("test", (Object)Float.valueOf(f));
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resutlValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.DOUBLE, (Object)resutlValue.getBsonType());
        BsonDouble bsonDouble = resutlValue.asDouble();
        Assert.assertEquals((double)f, (double)bsonDouble.getValue(), (double)0.0);
    }

    @Test
    public void readDocument_supportNumberFloat() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        float f = 1.123f;
        BsonDocument bson = new BsonDocument();
        bson.append("test", (BsonValue)new BsonDouble((double)f));
        BsonDocumentReader reader = new BsonDocumentReader(bson);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        float numberFloatValue = result.getFloat("test").floatValue();
        Assert.assertEquals((double)f, (double)numberFloatValue, (double)0.0);
    }

    @Test
    public void writeDocument_supportNumberDecimal() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        String l = "2222.454543";
        JsonObject value = new JsonObject();
        value.put("test", (Object)new JsonObject().put("$numberDecimal", (Object)l));
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resultValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.DECIMAL128, (Object)resultValue.getBsonType());
        BsonDecimal128 decimal128 = resultValue.asDecimal128();
        Assert.assertEquals((Object)l, (Object)decimal128.getValue().toString());
    }

    @Test
    public void readDocument_supportNumberDecimal() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        String v = "24.56";
        BsonDocument bson = new BsonDocument();
        BsonDocument numberDecimal = new BsonDocument();
        numberDecimal.append("$numberDecimal", (BsonValue)new BsonDecimal128(new Decimal128(new BigDecimal(v))));
        bson.append("test", (BsonValue)numberDecimal);
        BsonDocumentReader reader = new BsonDocumentReader(bson);
        JsonObject result = (JsonObject)codec.readDocument((BsonReader)reader, DecoderContext.builder().build());
        String decimalValue = result.getJsonObject("test").getString("$numberDecimal");
        Assert.assertEquals((Object)v, (Object)decimalValue);
    }

    @Test
    public void writeDocument_supportBsonStringFromInstant() {
        JsonObjectCodec codec = new JsonObjectCodec(this.options);
        Instant now = Instant.now();
        JsonObject value = new JsonObject();
        value.put("test", (Object)now);
        BsonDocument bsonResult = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(bsonResult);
        codec.writeDocument((BsonWriter)writer, "", (Object)value, EncoderContext.builder().build());
        BsonValue resultValue = bsonResult.get((Object)"test");
        Assert.assertEquals((Object)BsonType.STRING, (Object)resultValue.getBsonType());
        Assert.assertEquals((Object)now.toString(), (Object)resultValue.asString().getValue());
    }
}

