/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.ValidationOptions;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class ValidationOptionsTest {
    private static void assertNotEqual(BiConsumer<ValidationOptions, ValidationOptions> f) {
        ValidationOptions a = new ValidationOptions();
        ValidationOptions b = new ValidationOptions();
        f.accept(a, b);
        Assert.assertNotEquals((Object)a, (Object)b);
    }

    private static void assertNotEqual(int expected, Consumer<ValidationOptions> f) {
        ValidationOptions o = new ValidationOptions();
        f.accept(o);
        Assert.assertNotEquals((long)expected, (long)o.hashCode());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new ValidationOptions(), (Object)new ValidationOptions());
        ValidationOptionsTest.assertNotEqual((a, b) -> {
            a.setValidator(new JsonObject());
            b.setValidator(new JsonObject().put("some", (Object)"validatorValue"));
        });
        ValidationOptionsTest.assertNotEqual((a, b) -> {
            a.setValidationAction(ValidationAction.ERROR);
            b.setValidationAction(ValidationAction.WARN);
        });
        ValidationOptionsTest.assertNotEqual((a, b) -> {
            a.setValidationLevel(ValidationLevel.STRICT);
            b.setValidationLevel(ValidationLevel.OFF);
        });
        Assert.assertNotEquals((Object)new ValidationOptions(), null);
    }

    @Test
    public void testHashCode() {
        ValidationOptions a = new ValidationOptions();
        int hash = a.hashCode();
        Assert.assertEquals((long)hash, (long)new ValidationOptions().hashCode());
        ValidationOptionsTest.assertNotEqual(hash, o -> o.setValidationLevel(ValidationLevel.MODERATE));
        ValidationOptionsTest.assertNotEqual(hash, o -> o.setValidationAction(ValidationAction.WARN));
        ValidationOptionsTest.assertNotEqual(hash, o -> o.setValidator(new JsonObject().put("some", (Object)"validatorValue")));
    }

    @Test
    public void testValidationOptionsFromJson() {
        JsonObject json = new JsonObject().put("validationLevel", (Object)"MODERATE").put("validationAction", (Object)"WARN").put("validator", (Object)new JsonObject().put("some", (Object)"validatorValue"));
        ValidationOptions options = new ValidationOptions(json);
        Assert.assertEquals((Object)ValidationLevel.MODERATE, (Object)options.getValidationLevel());
        Assert.assertEquals((Object)ValidationAction.WARN, (Object)options.getValidationAction());
        Assert.assertEquals((Object)new JsonObject().put("some", (Object)"validatorValue"), (Object)options.getValidator());
    }

    @Test
    public void testValidationOptionsToJson() {
        JsonObject json = new JsonObject().put("validationLevel", (Object)"MODERATE").put("validationAction", (Object)"WARN").put("validator", (Object)new JsonObject().put("some", (Object)"validatorValue"));
        ValidationOptions options = new ValidationOptions().setValidationAction(ValidationAction.WARN).setValidationLevel(ValidationLevel.MODERATE).setValidator(new JsonObject().put("some", (Object)"validatorValue"));
        Assert.assertEquals((Object)json, (Object)options.toJson());
    }
}

