/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoTestBase;
import org.junit.Test;

public class RefCountTest
extends MongoTestBase {
    private LocalMap<String, Object> getLocalMap() {
        return this.vertx.sharedData().getLocalMap("__vertx.MongoClient.datasources");
    }

    @Test
    public void testNonShared() {
        LocalMap<String, Object> map = this.getLocalMap();
        JsonObject config = RefCountTest.getConfig();
        MongoClient client1 = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(1L, map.size());
        MongoClient client2 = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(2L, map.size());
        MongoClient client3 = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(3L, map.size());
        client1.close();
        this.assertEquals(2L, map.size());
        client2.close();
        this.assertEquals(1L, map.size());
        client3.close();
        RefCountTest.assertWaitUntil(() -> map.size() == 0);
        RefCountTest.assertWaitUntil(() -> this.getLocalMap().size() == 0);
        RefCountTest.assertWaitUntil(() -> map != this.getLocalMap());
    }

    @Test
    public void testSharedDefault() throws Exception {
        LocalMap<String, Object> map = this.getLocalMap();
        JsonObject config = RefCountTest.getConfig();
        MongoClient client1 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(1L, map.size());
        MongoClient client2 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(1L, map.size());
        MongoClient client3 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(1L, map.size());
        client1.close();
        this.assertEquals(1L, map.size());
        client2.close();
        this.assertEquals(1L, map.size());
        client3.close();
        this.assertEquals(0L, map.size());
        this.assertNotSame(map, this.getLocalMap());
    }

    @Test
    public void testSharedNamed() throws Exception {
        LocalMap<String, Object> map = this.getLocalMap();
        JsonObject config = RefCountTest.getConfig();
        MongoClient client1 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds1");
        this.assertEquals(1L, map.size());
        MongoClient client2 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds1");
        this.assertEquals(1L, map.size());
        MongoClient client3 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds1");
        this.assertEquals(1L, map.size());
        MongoClient client4 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds2");
        this.assertEquals(2L, map.size());
        MongoClient client5 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds2");
        this.assertEquals(2L, map.size());
        MongoClient client6 = MongoClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds2");
        this.assertEquals(2L, map.size());
        client1.close();
        this.assertEquals(2L, map.size());
        client2.close();
        this.assertEquals(2L, map.size());
        client3.close();
        this.assertEquals(1L, map.size());
        client4.close();
        this.assertEquals(1L, map.size());
        client5.close();
        this.assertEquals(1L, map.size());
        client6.close();
        this.assertEquals(0L, map.size());
        this.assertNotSame(map, this.getLocalMap());
    }
}

