/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientTestBase;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import java.util.concurrent.CountDownLatch;
import org.bson.types.ObjectId;
import org.junit.Test;

public class MongoClientWithObjectIdTest
extends MongoClientTestBase {
    public void setUp() throws Exception {
        super.setUp();
        JsonObject config = MongoClientWithObjectIdTest.getConfig();
        config.put("useObjectId", (Object)true);
        this.useObjectId = true;
        this.mongoClient = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        CountDownLatch latch = new CountDownLatch(1);
        this.dropCollections(this.mongoClient, latch);
        this.awaitLatch(latch);
    }

    public void tearDown() throws Exception {
        this.mongoClient.close();
        super.tearDown();
    }

    protected static JsonObject getConfig() {
        JsonObject config = MongoClientTestBase.getConfig();
        config.put("useObjectId", (Object)true);
        return config;
    }

    protected void assertEquals(JsonObject expected, JsonObject actual) {
        if (actual.containsKey("_id") && actual.getValue("_id") instanceof String) {
            actual.put("_id", (Object)new JsonObject().put("$oid", (Object)actual.getString("_id")));
        }
        super.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    @Test
    public void testSavePreexistingLongID() throws Exception {
        this.assertTrue(true);
        this.testComplete();
        this.await();
    }

    @Test
    public void testFindOneReturnsStringId() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject orig = this.createDoc();
            JsonObject doc = orig.copy();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOne(collection, new JsonObject().put("foo", (Object)"bar"), null, this.onSuccess(obj -> {
                    this.assertTrue(obj.containsKey("_id"));
                    this.assertTrue(obj.getValue("_id") instanceof String);
                    obj.remove("_id");
                    this.assertEquals(orig, (JsonObject)obj);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneReturnsNothing() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject orig = this.createDoc();
            JsonObject doc = orig.copy();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOne(collection, new JsonObject().put("nothing", (Object)"xxrandomxx"), null, this.onSuccess(obj -> {
                    this.assertNull(obj);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindReturnsStringId() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject orig = this.createDoc();
            JsonObject doc = orig.copy();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.find(collection, new JsonObject().put("foo", (Object)"bar"), this.onSuccess(list -> {
                    this.assertTrue(list.size() == 1);
                    JsonObject obj = (JsonObject)list.get(0);
                    this.assertTrue(obj.containsKey("_id"));
                    this.assertTrue(obj.getValue("_id") instanceof String);
                    obj.remove("_id");
                    this.assertEquals(orig, obj);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Override
    @Test
    public void testInsertPreexistingObjectID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            doc.put("_id", (Object)new ObjectId().toHexString());
            this.mongoClient.insertWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> {
                this.assertNull(id);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Override
    @Test
    public void testInsertPreexistingID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            doc.put("_id", (Object)new ObjectId().toHexString());
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNull(id);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Override
    @Test
    public void testInsertRetrieve() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            doc.put("_id", (Object)new ObjectId().toHexString());
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNull(id);
                this.mongoClient.findOne(collection, new JsonObject(), null, this.onSuccess(retrieved -> {
                    this.assertEquals(doc, (JsonObject)retrieved);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Override
    @Test
    public void testSavePreexistingObjectID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            doc.put("_id", (Object)new ObjectId().toHexString());
            this.mongoClient.saveWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> {
                this.assertNull(id);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Override
    @Test
    public void testInsertAlreadyExists() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                doc.put("_id", id);
                this.mongoClient.insert(collection, doc, response -> {
                    this.assertFalse(response.succeeded());
                    this.testComplete();
                });
            }));
        }));
        this.await();
    }

    @Override
    @Test
    public void testReplaceUpsert() {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocumentsWithOptions(collection, new JsonObject().put("_id", (Object)new ObjectId().toHexString()), replacement, new UpdateOptions(true), this.onSuccess(v -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(list -> {
                this.assertNotNull(list);
                this.assertEquals(2L, list.size());
                JsonObject result = null;
                for (JsonObject o : list) {
                    if (!o.containsKey("replacement")) continue;
                    result = o;
                }
                this.assertNotNull(result);
                this.testComplete();
            }))));
        }));
        this.await();
    }
}

