/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.changestream.OperationType;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientTestBase;
import io.vertx.ext.mongo.TimeSeriesGranularity;
import io.vertx.ext.mongo.TimeSeriesOptions;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.impl.SingleResultSubscriber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.junit.Test;
import org.reactivestreams.Subscriber;

public class MongoClientTest
extends MongoClientTestBase {
    private com.mongodb.reactivestreams.client.MongoClient actualMongo;
    private MongoDatabase db;

    public void setUp() throws Exception {
        super.setUp();
        JsonObject config = MongoClientTest.getConfig();
        this.mongoClient = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        CountDownLatch latch = new CountDownLatch(1);
        this.dropCollections(this.mongoClient, latch);
        this.awaitLatch(latch);
        this.actualMongo = MongoClients.create((String)"mongodb://localhost:27018");
        this.db = this.actualMongo.getDatabase("DEFAULT_DB");
    }

    public void tearDown() throws Exception {
        this.mongoClient.close();
        this.actualMongo.close();
        super.tearDown();
    }

    @Test
    public void testCreateCollectionWithOptions() {
        String expectedLocale = "de_AT";
        String collection = this.randomCollection();
        CreateCollectionOptions options = new CreateCollectionOptions().setCollation(new CollationOptions().setLocale(expectedLocale));
        PromiseInternal promise = ((VertxInternal)this.vertx).promise();
        this.mongoClient.createCollectionWithOptions(collection, options, this.onSuccess(arg_0 -> this.lambda$testCreateCollectionWithOptions$0((Promise)promise, arg_0)));
        promise.future().onFailure(arg_0 -> ((MongoClientTest)this).fail(arg_0)).onSuccess(d -> {
            JsonObject json = new JsonObject(d.toJson());
            this.assertEquals(expectedLocale, json.getJsonObject("options", new JsonObject()).getJsonObject("collation", new JsonObject()).getString("locale"));
        }).onComplete(d -> this.testComplete());
        this.await();
    }

    @Test
    public void testFindBatch() throws Exception {
        this.testFindBatch(3000, (latch, stream) -> {
            ArrayList foos = new ArrayList();
            stream.exceptionHandler(arg_0 -> ((MongoClientTest)this).fail(arg_0)).endHandler(v -> latch.countDown()).handler(result -> foos.add(result.getString("foo")));
            return foos;
        });
    }

    @Test
    public void testFindBatchResumePause() throws Exception {
        this.testFindBatch(3000, (latch, stream) -> {
            ArrayList foos = new ArrayList();
            stream.exceptionHandler(arg_0 -> ((MongoClientTest)this).fail(arg_0)).endHandler(v -> latch.countDown()).handler(result -> {
                foos.add(result.getString("foo"));
                if (foos.size() % 100 == 0) {
                    stream.pause();
                    this.vertx.setTimer(10L, id -> stream.resume());
                }
            });
            return foos;
        });
    }

    @Test
    public void testFindBatchFetch() throws Exception {
        this.testFindBatch(3000, (latch, stream) -> {
            ArrayList foos = new ArrayList();
            stream.exceptionHandler(arg_0 -> ((MongoClientTest)this).fail(arg_0)).endHandler(v -> latch.countDown()).handler(result -> {
                foos.add(result.getString("foo"));
                if (foos.size() % 100 == 0) {
                    this.vertx.setTimer(10L, id -> stream.fetch(100L));
                }
            });
            stream.pause();
            stream.fetch(100L);
            return foos;
        });
    }

    @Test
    public void testFindSmallBatchResumePauseOneByOne() throws Exception {
        this.testFindBatch(10, (latch, stream) -> {
            ArrayList foos = new ArrayList();
            stream.exceptionHandler(arg_0 -> ((MongoClientTest)this).fail(arg_0)).endHandler(v -> latch.countDown()).handler(result -> {
                foos.add(result.getString("foo"));
                stream.pause();
                this.vertx.setTimer(10L, id -> stream.resume());
            });
            return foos;
        });
    }

    @Test
    public void testFindSmallBatchFetchOneByOne() throws Exception {
        this.testFindBatch(10, (latch, stream) -> {
            ArrayList foos = new ArrayList();
            stream.exceptionHandler(arg_0 -> ((MongoClientTest)this).fail(arg_0)).endHandler(v -> latch.countDown()).handler(result -> {
                foos.add(result.getString("foo"));
                this.vertx.setTimer(10L, id -> stream.fetch(1L));
            });
            stream.pause();
            stream.fetch(1L);
            return foos;
        });
    }

    private void testFindBatch(int numDocs, BiFunction<CountDownLatch, ReadStream<JsonObject>, List<String>> checker) throws Exception {
        AtomicReference streamReference = new AtomicReference();
        String collection = this.randomCollection();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference foos = new AtomicReference();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.insertDocs(this.mongoClient, collection, numDocs, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> {
            FindOptions findOptions = new FindOptions().setSort(new JsonObject().put("counter", (Object)1)).setBatchSize(1);
            ReadStream stream = this.mongoClient.findBatchWithOptions(collection, new JsonObject(), findOptions);
            streamReference.set(stream);
            foos.set(checker.apply(latch, stream));
        }))));
        this.awaitLatch(latch);
        this.assertEquals(numDocs, ((List)foos.get()).size());
        this.assertEquals("bar0", ((List)foos.get()).get(0));
        this.assertEquals("bar" + (numDocs - 1), ((List)foos.get()).get(numDocs - 1));
        ((ReadStream)streamReference.get()).handler(null).exceptionHandler(null).endHandler(null);
    }

    @Test
    public void testUpsertCreatesHexIfRecordDoesNotExist() throws Exception {
        this.upsertDoc(this.randomCollection(), this.createDoc(), null, IGNORE -> this.testComplete());
        this.await();
    }

    @Test
    public void testUpsertWithASetOnInsertIsNotOverWritten() throws Exception {
        String collection = this.randomCollection();
        JsonObject docToInsert = this.createDoc();
        JsonObject insertStatement = new JsonObject().put("$set", (Object)docToInsert).put("$setOnInsert", (Object)new JsonObject().put("a-field", (Object)"an-entry"));
        this.upsertDoc(collection, docToInsert, insertStatement, null, saved -> {
            this.assertEquals("an-entry", saved.getString("a-field"));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testUpsertDoesNotChangeIdIfRecordExist() throws Exception {
        String collection = this.randomCollection();
        JsonObject docToInsert = this.createDoc();
        this.mongoClient.insert(collection, docToInsert, this.onSuccess(id -> this.upsertDoc(collection, docToInsert, (String)id, IGNORE -> this.testComplete())));
        this.await();
    }

    @Test
    public void testAggregate() throws Exception {
        int numDocs = 1000;
        String collection = this.randomCollection();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicLong count = new AtomicLong();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.insertDocs(this.mongoClient, collection, 1000, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.aggregate(collection, new JsonArray().add((Object)new JsonObject().put("$match", (Object)new JsonObject().put("foo", (Object)new JsonObject().put("$regex", (Object)"bar1")))).add((Object)new JsonObject().put("$count", (Object)"foo_starting_with_bar1"))).exceptionHandler(arg_0 -> ((MongoClientTest)this).fail(arg_0)).endHandler(v -> latch.countDown()).handler(result -> count.set(result.getLong("foo_starting_with_bar1")))))));
        this.awaitLatch(latch);
        this.assertEquals(111L, count.longValue());
    }

    @Test
    public void testAggregateWithOptions() throws Exception {
        AggregateOptions aggregateOptions = new AggregateOptions();
        aggregateOptions.setAllowDiskUse(Boolean.valueOf(true));
        JsonArray pipeline = new JsonArray();
        pipeline.add((Object)new JsonObject().put("$addFields", (Object)new JsonObject().put("field", (Object)"test")));
        int numDocs = 25;
        CountDownLatch fetchLatch = new CountDownLatch(numDocs);
        CountDownLatch endLatch = new CountDownLatch(1);
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, numDocs, (Handler<AsyncResult<Void>>)this.onSuccess(res -> this.mongoClient.aggregateWithOptions(collection, pipeline, aggregateOptions).exceptionHandler(arg_0 -> ((MongoClientTest)this).fail(arg_0)).handler(j -> fetchLatch.countDown()).fetch(25L).endHandler(v -> endLatch.countDown())));
        this.awaitLatch(fetchLatch);
        this.awaitLatch(endLatch);
    }

    @Test
    public void testWatch() throws Exception {
        JsonArray operationTypes = new JsonArray(Arrays.asList("insert", "update", "replace", "delete"));
        JsonObject match = new JsonObject().put("operationType", (Object)new JsonObject().put("$in", (Object)operationTypes));
        JsonArray pipeline = new JsonArray().add((Object)new JsonObject().put("$match", (Object)match));
        JsonObject fields = new JsonObject().put("operationType", (Object)true).put("namespaceDocument", (Object)true).put("destinationNamespaceDocument", (Object)true).put("documentKey", (Object)true).put("updateDescription", (Object)true).put("fullDocument", (Object)true);
        pipeline.add((Object)new JsonObject().put("$project", (Object)fields));
        String collection = this.randomCollection();
        CountDownLatch latch = new CountDownLatch(4);
        AtomicReference streamReference = new AtomicReference();
        AtomicReference watchedDocumentId = new AtomicReference();
        long timerId = this.vertx.setPeriodic(100L, l -> this.mongoClient.insert(collection, this.createDoc()));
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            ReadStream stream = this.mongoClient.watch(collection, pipeline, true, 1).handler(changeStreamDocument -> {
                OperationType operationType = changeStreamDocument.getOperationType();
                this.assertNotNull(operationType);
                JsonObject fullDocument = (JsonObject)changeStreamDocument.getFullDocument();
                switch (operationType) {
                    case INSERT: {
                        String id = fullDocument.getString("_id");
                        this.assertNotNull(id);
                        if (watchedDocumentId.compareAndSet(null, id)) {
                            this.vertx.cancelTimer(timerId);
                            this.assertEquals("bar", fullDocument.getString("foo"));
                            fullDocument.put("_id", (Object)id);
                            fullDocument.put("fieldToUpdate", (Object)"updatedValue");
                            JsonObject query = new JsonObject().put("_id", (Object)id);
                            JsonObject updateField = new JsonObject().put("fieldToUpdate", (Object)"updatedValue");
                            this.mongoClient.updateCollection(collection, query, new JsonObject().put("$set", (Object)updateField), this.onSuccess(update -> this.mongoClient.save(collection, fullDocument.put("fieldToReplace", (Object)"replacedValue"))));
                            break;
                        }
                        return;
                    }
                    case UPDATE: {
                        this.assertEquals("updatedValue", fullDocument.getString("fieldToUpdate"));
                        break;
                    }
                    case REPLACE: {
                        this.assertEquals("replacedValue", fullDocument.getString("fieldToReplace"));
                        this.mongoClient.removeDocuments(collection, new JsonObject());
                        break;
                    }
                    case DELETE: {
                        this.assertNull(fullDocument);
                    }
                }
                latch.countDown();
            }).endHandler(v -> this.assertEquals(0L, latch.getCount())).exceptionHandler(arg_0 -> ((MongoClientTest)this).fail(arg_0)).fetch(1L);
            streamReference.set(stream);
        }));
        this.awaitLatch(latch);
        ((ReadStream)streamReference.get()).handler(null);
    }

    private void upsertDoc(String collection, JsonObject docToInsert, String expectedId, Consumer<JsonObject> doneFunction) {
        JsonObject insertStatement = new JsonObject().put("$setOnInsert", (Object)docToInsert);
        this.upsertDoc(collection, docToInsert, insertStatement, expectedId, doneFunction);
    }

    private void upsertDoc(String collection, JsonObject docToInsert, JsonObject insertStatement, String expectedId, Consumer<JsonObject> doneFunction) {
        this.mongoClient.updateCollectionWithOptions(collection, new JsonObject().put("foo", (Object)docToInsert.getString("foo")), insertStatement, new UpdateOptions().setUpsert(true), this.onSuccess(res -> {
            this.assertEquals(0L, res.getDocModified());
            if (expectedId == null) {
                this.assertEquals(0L, res.getDocMatched());
                this.assertNotNull(res.getDocUpsertedId());
            } else {
                this.assertEquals(1L, res.getDocMatched());
                this.assertNull(res.getDocUpsertedId());
            }
            PromiseInternal promise = ((VertxInternal)this.vertx).promise();
            this.db.getCollection(collection).find().first().subscribe((Subscriber)new SingleResultSubscriber((Promise)promise));
            promise.future().onFailure(Throwable::printStackTrace).onSuccess(savedDoc -> {
                if (expectedId != null) {
                    this.assertEquals(expectedId, savedDoc.getString((Object)"_id"));
                } else {
                    this.assertEquals(res.getDocUpsertedId().getString("_id"), savedDoc.getString((Object)"_id"));
                }
                doneFunction.accept(new JsonObject(savedDoc.toJson()));
            });
        }));
    }

    @Test
    public void testCreateTimeSeriesCollection() {
        String collectionName = "_testCreateTimeSeriesCollection" + UUID.randomUUID();
        TimeSeriesOptions timeseries = new TimeSeriesOptions().setMetaField("metadata").setGranularity(TimeSeriesGranularity.HOURS);
        CreateCollectionOptions options = new CreateCollectionOptions().setTimeSeriesOptions(timeseries);
        this.mongoClient.createCollectionWithOptions(collectionName, options, this.onSuccess(v -> this.mongoClient.runCommand("listCollections", JsonObject.of((String)"listCollections", (Object)"1.0"), this.onSuccess(json -> {
            boolean isTimeSeriesCollection = false;
            for (Object obj : json.getJsonObject("cursor").getJsonArray("firstBatch")) {
                JsonObject coll = (JsonObject)obj;
                if (!Objects.equals(collectionName, coll.getString("name"))) continue;
                isTimeSeriesCollection = Objects.equals("timeseries", coll.getString("type"));
                break;
            }
            this.assertTrue(isTimeSeriesCollection);
            this.testComplete();
        }))));
        this.await();
    }

    private /* synthetic */ void lambda$testCreateCollectionWithOptions$0(Promise promise, Void res) {
        this.db.listCollections().first().subscribe((Subscriber)new SingleResultSubscriber(promise));
    }
}

