/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoTestBase;
import io.vertx.ext.mongo.UpdateOptions;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class MongoClientAggregateUpdateTest
extends MongoTestBase {
    protected MongoClient mongoClient;

    public void setUp() throws Exception {
        super.setUp();
        JsonObject config = MongoClientAggregateUpdateTest.getConfig();
        this.mongoClient = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        CountDownLatch latch = new CountDownLatch(1);
        this.dropCollections(this.mongoClient, latch);
        this.awaitLatch(latch);
    }

    public void tearDown() throws Exception {
        this.mongoClient.close();
        super.tearDown();
    }

    @Test
    public void testAggregateUpdateCollection() {
        String collection = this.randomCollection();
        this.mongoClient.insert(collection, new JsonObject().put("price", (Object)10).put("quantity", (Object)1), this.onSuccess(id -> this.mongoClient.insert(collection, new JsonObject().put("price", (Object)20).put("quantity", (Object)2), this.onSuccess(id2 -> this.mongoClient.insert(collection, new JsonObject().put("price", (Object)30).put("quantity", (Object)10), this.onSuccess(id3 -> this.mongoClient.updateCollection(collection, new JsonObject().put("quantity", (Object)new JsonObject().put("$lte", (Object)2)), new JsonArray().add((Object)new JsonObject().put("$set", (Object)new JsonObject().put("price", (Object)new JsonObject().put("$subtract", (Object)new JsonArray().add((Object)"$price").add((Object)2))))), this.onSuccess(res -> {
            this.assertEquals(2L, res.getDocModified());
            this.assertEquals(2L, res.getDocMatched());
            this.testComplete();
        }))))))));
        this.await();
    }

    @Test
    public void testAggregateUpdateCollectionWithOptions() {
        String collection = this.randomCollection();
        this.mongoClient.insert(collection, new JsonObject().put("price", (Object)10).put("quantity", (Object)1), this.onSuccess(id -> this.mongoClient.insert(collection, new JsonObject().put("price", (Object)20).put("quantity", (Object)2), this.onSuccess(id2 -> this.mongoClient.insert(collection, new JsonObject().put("price", (Object)30).put("quantity", (Object)10), this.onSuccess(id3 -> this.mongoClient.updateCollectionWithOptions(collection, new JsonObject().put("quantity", (Object)new JsonObject().put("$lte", (Object)2)), new JsonArray().add((Object)new JsonObject().put("$set", (Object)new JsonObject().put("price", (Object)new JsonObject().put("$subtract", (Object)new JsonArray().add((Object)"$price").add((Object)2))))), new UpdateOptions(), this.onSuccess(res -> {
            this.assertEquals(2L, res.getDocModified());
            this.assertEquals(2L, res.getDocMatched());
            this.testComplete();
        }))))))));
        this.await();
    }
}

