/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoGridFsClient;
import io.vertx.ext.mongo.MongoTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class GridFsTest
extends MongoTestBase {
    protected MongoClient mongoClient;

    public void setUp() throws Exception {
        super.setUp();
        JsonObject config = GridFsTest.getConfig();
        this.mongoClient = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        CountDownLatch latch = new CountDownLatch(1);
        this.dropCollections(this.mongoClient, latch);
        this.awaitLatch(latch);
    }

    public void tearDown() throws Exception {
        this.mongoClient.close();
        super.tearDown();
    }

    @Test
    public void testDelete() {
        String fileName = GridFsTest.createTempFileWithContent(3142L);
        AtomicReference gridFsClient = new AtomicReference();
        Promise mongoGridFsPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)mongoGridFsPromise);
        mongoGridFsPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise deletePromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).delete(id, (Handler)deletePromise);
            return deletePromise.future();
        }).onComplete(event -> {
            if (event.succeeded()) {
                this.testComplete();
            } else {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testFileUpload() {
        long fileLength = 3142L;
        String fileName = GridFsTest.createTempFileWithContent(fileLength);
        String downloadFileName = GridFsTest.createTempFile();
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise downloadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).downloadFileAs(fileName, downloadFileName, (Handler)downloadPromise);
            return downloadPromise.future();
        }).compose(length -> {
            this.assertEquals((long)length, fileLength);
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            } else {
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testBigFileUpload() {
        String originalFileName = GridFsTest.createTempFileWithContent(51216L);
        long originalLength = new File(originalFileName).length();
        String copiedFileName = GridFsTest.createTempFile();
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(originalFileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise downloadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).downloadFileAs(originalFileName, copiedFileName, (Handler)downloadPromise);
            return downloadPromise.future();
        }).compose(length -> {
            this.assertEquals(originalLength, (long)length);
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            } else {
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testFileUploadWithOptions() {
        String fileName = GridFsTest.createTempFileWithContent(8027L);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        JsonObject meta = new JsonObject();
        meta.put("nick_name", (Object)"Puhi the eel");
        GridFsUploadOptions options = new GridFsUploadOptions();
        options.setMetadata(meta);
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFileWithOptions(fileName, options, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testFindWithMetadata() {
        String fileName = GridFsTest.createTempFileWithContent(3142L);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        JsonObject meta = new JsonObject();
        meta.put("nick_name", (Object)"Puhi the eel");
        GridFsUploadOptions options = new GridFsUploadOptions();
        options.setMetadata(meta);
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFileWithOptions(fileName, options, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise findPromise = Promise.promise();
            JsonObject query = new JsonObject().put("metadata.nick_name", (Object)"Puhi the eel");
            ((MongoGridFsClient)gridFsClient.get()).findIds(query, (Handler)findPromise);
            return findPromise.future();
        }).compose(list -> {
            this.assertTrue(list.size() > 0);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testFindAllIds() {
        String fileName = GridFsTest.createTempFileWithContent(3142L);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise findPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).findAllIds((Handler)findPromise);
            return findPromise.future();
        }).compose(list -> {
            this.assertTrue(list.size() == 1);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testDrop() {
        GridFsTest.createTempFileWithContent(3142L);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testReadByFileName() {
        long fileLength = 3142L;
        String fileName = GridFsTest.createTempFileWithContent(fileLength);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createDefaultGridFsBucketService((Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise readPromise = Promise.promise();
            AtomicLong count = new AtomicLong(0L);
            ReadStream rs = ((MongoGridFsClient)gridFsClient.get()).readByFileName(fileName);
            rs.handler(buffer -> count.addAndGet(buffer.length()));
            rs.endHandler(x -> readPromise.complete((Object)count.get()));
            return readPromise.future();
        }).compose(length -> {
            this.assertTrue(fileLength == length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testReadByFileNameWithOptions() {
        long fileLength = 3142L;
        String fileName = GridFsTest.createTempFileWithContent(fileLength);
        GridFsDownloadOptions options = new GridFsDownloadOptions();
        options.setRevision(GridFsDownloadOptions.DEFAULT_REVISION);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createDefaultGridFsBucketService((Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise readPromise = Promise.promise();
            AtomicLong count = new AtomicLong(0L);
            ReadStream rs = ((MongoGridFsClient)gridFsClient.get()).readByFileNameWithOptions(fileName, options);
            rs.handler(buffer -> count.addAndGet(buffer.length()));
            rs.endHandler(x -> readPromise.complete((Object)count.get()));
            return readPromise.future();
        }).compose(length -> {
            this.assertTrue(fileLength == length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testReadById() {
        long fileLength = 8027L;
        String fileName = GridFsTest.createTempFileWithContent(fileLength);
        AtomicReference gridFsClient = new AtomicReference();
        AtomicReference idCreated = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createDefaultGridFsBucketService((Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            idCreated.set(id);
            Promise readPromise = Promise.promise();
            AtomicLong count = new AtomicLong(0L);
            ReadStream rs = ((MongoGridFsClient)gridFsClient.get()).readById((String)idCreated.get());
            rs.handler(buffer -> count.addAndGet(buffer.length()));
            rs.endHandler(x -> readPromise.complete((Object)count.get()));
            return readPromise.future();
        }).compose(length -> {
            this.assertTrue(fileLength == length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testDownloadStream() {
        long fileLength = 3142L;
        String fileName = GridFsTest.createTempFileWithContent(fileLength);
        String downloadFileName = GridFsTest.createTempFile();
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createDefaultGridFsBucketService((Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise openPromise = Promise.promise();
            this.vertx.fileSystem().open(downloadFileName, new OpenOptions().setWrite(true), (Handler)openPromise);
            return openPromise.future();
        }).compose(asyncFile -> {
            Promise downloadedPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).downloadByFileName((WriteStream)asyncFile, fileName, (Handler)downloadedPromise);
            return downloadedPromise.future();
        }).compose(length -> {
            this.assertTrue(fileLength == length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testDownloadStreamById() {
        long fileLength = 8027L;
        String fileName = GridFsTest.createTempFileWithContent(fileLength);
        String downloadFileName = GridFsTest.createTempFile();
        AtomicReference gridFsClient = new AtomicReference();
        AtomicReference idCreated = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createDefaultGridFsBucketService((Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            idCreated.set(id);
            Promise openPromise = Promise.promise();
            this.vertx.fileSystem().open(downloadFileName, new OpenOptions().setWrite(true), (Handler)openPromise);
            return openPromise.future();
        }).compose(asyncFile -> {
            Promise downloadedPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).downloadById((WriteStream)asyncFile, (String)idCreated.get(), (Handler)downloadedPromise);
            return downloadedPromise.future();
        }).compose(length -> {
            this.assertTrue(fileLength == length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testDownloadStreamWithOptions() {
        long fileLength = 3142L;
        String fileName = GridFsTest.createTempFileWithContent(fileLength);
        String downloadFileName = GridFsTest.createTempFile();
        GridFsDownloadOptions options = new GridFsDownloadOptions();
        options.setRevision(GridFsDownloadOptions.DEFAULT_REVISION);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createDefaultGridFsBucketService((Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            Promise openPromise = Promise.promise();
            this.vertx.fileSystem().open(downloadFileName, new OpenOptions().setWrite(true), (Handler)openPromise);
            return openPromise.future();
        }).compose(asyncFile -> {
            Promise downloadedPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).downloadByFileNameWithOptions((WriteStream)asyncFile, fileName, options, (Handler)downloadedPromise);
            return downloadedPromise.future();
        }).compose(length -> {
            this.assertTrue(fileLength == length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testFileDownload() {
        String fileName = GridFsTest.createTempFileWithContent(1024L);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(uploaded -> {
            Promise downloadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).downloadFile(fileName, (Handler)downloadPromise);
            return downloadPromise.future();
        }).compose(length -> {
            this.assertEquals(1024L, (long)length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testStreamUpload() {
        String fileName = GridFsTest.createTempFileWithContent(1024L);
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise openPromise = Promise.promise();
            this.vertx.fileSystem().open(fileName, new OpenOptions(), (Handler)openPromise);
            return openPromise.future();
        }).compose(asyncFile -> {
            Promise uploadedPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadByFileName((ReadStream)asyncFile, fileName, (Handler)uploadedPromise);
            return uploadedPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testStreamUploadWithOptions() {
        String fileName = GridFsTest.createTempFileWithContent(1024L);
        GridFsUploadOptions options = new GridFsUploadOptions();
        options.setChunkSizeBytes(Integer.valueOf(1024));
        options.setMetadata(new JsonObject().put("meta_test", (Object)"Kamapua`a"));
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise openPromise = Promise.promise();
            this.vertx.fileSystem().open(fileName, new OpenOptions(), (Handler)openPromise);
            return openPromise.future();
        }).compose(asyncFile -> {
            Promise uploadedPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadByFileNameWithOptions((ReadStream)asyncFile, fileName, options, (Handler)uploadedPromise);
            return uploadedPromise.future();
        }).compose(id -> {
            this.assertNotNull(id);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testFileDownloadAs() {
        String fileName = GridFsTest.createTempFileWithContent(1024L);
        String asFileName = GridFsTest.createTempFile();
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(uploaded -> {
            Promise downloadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).downloadFileAs(fileName, asFileName, (Handler)downloadPromise);
            return downloadPromise.future();
        }).compose(length -> {
            this.assertEquals(1024L, (long)length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    @Test
    public void testFileDownloadById() {
        String fileName = GridFsTest.createTempFileWithContent(1024L);
        String asFileName = GridFsTest.createTempFile();
        AtomicReference gridFsClient = new AtomicReference();
        Promise gridFsClientPromise = Promise.promise();
        this.mongoClient.createGridFsBucketService("fs", (Handler)gridFsClientPromise);
        gridFsClientPromise.future().compose(mongoGridFsClient -> {
            this.assertNotNull(mongoGridFsClient);
            gridFsClient.set(mongoGridFsClient);
            Promise dropPromise = Promise.promise();
            mongoGridFsClient.drop((Handler)dropPromise);
            return dropPromise.future();
        }).compose(dropped -> {
            Promise uploadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).uploadFile(fileName, (Handler)uploadPromise);
            return uploadPromise.future();
        }).compose(id -> {
            Promise downloadPromise = Promise.promise();
            ((MongoGridFsClient)gridFsClient.get()).downloadFileByID(id, asFileName, (Handler)downloadPromise);
            return downloadPromise.future();
        }).compose(length -> {
            this.assertEquals(1024L, (long)length);
            this.testComplete();
            return Future.succeededFuture();
        }).onComplete(event -> {
            if (event.failed()) {
                this.fail(event.cause());
            }
        });
        this.await();
    }

    private static String createTempFileWithContent(long length) {
        try {
            Path path = Files.createTempFile("sample-file", ".txt", new FileAttribute[0]);
            File file = path.toFile();
            FileOutputStream fos = new FileOutputStream(file);
            int i = 0;
            while ((long)i < length) {
                fos.write(ThreadLocalRandom.current().nextInt(-128, 128));
                ++i;
            }
            fos.close();
            file.deleteOnExit();
            return file.getAbsolutePath();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static String createTempFile() {
        try {
            Path path = Files.createTempFile("sample-file", ".txt", new FileAttribute[0]);
            File file = path.toFile();
            file.deleteOnExit();
            return file.getAbsolutePath();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

