/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class DistinctTest
extends MongoTestBase {
    protected MongoClient mongoClient;

    public void setUp() throws Exception {
        super.setUp();
        JsonObject config = DistinctTest.getConfig();
        this.mongoClient = MongoClient.create((Vertx)this.vertx, (JsonObject)config);
        CountDownLatch latch = new CountDownLatch(1);
        this.dropCollections(this.mongoClient, latch);
        this.awaitLatch(latch);
    }

    public void tearDown() throws Exception {
        this.mongoClient.close();
        super.tearDown();
    }

    @Test
    public void testDistinctInteger() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinct(collection, "num", Integer.class.getName(), this.onSuccess(distincted -> {
            this.assertEquals(1L, distincted.size());
            this.assertEquals(123, distincted.getInteger(0));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctString() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinct(collection, "foo", String.class.getName(), this.onSuccess(distincted -> {
            this.assertEquals(10L, distincted.size());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctBoolean() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinct(collection, "big", Boolean.class.getName(), this.onSuccess(distincted -> {
            this.assertEquals(1L, distincted.size());
            this.assertEquals(true, distincted.getBoolean(0));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctDouble() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinct(collection, "dblval", Double.class.getName(), this.onSuccess(distincted -> {
            this.assertEquals(1L, distincted.size());
            this.assertEquals(1.23, distincted.getDouble(0));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctLong() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinct(collection, "longval", Long.class.getName(), this.onSuccess(distincted -> {
            this.assertEquals(1L, distincted.size());
            this.assertEquals(123456789L, distincted.getLong(0));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctBadResultClass() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinct(collection, "foo", Object.class.getName(), this.onFailure(failure -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryInteger() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "num", Integer.class.getName(), new JsonObject(), this.onSuccess(distincted -> {
            this.assertEquals(1L, distincted.size());
            this.assertEquals(123, distincted.getInteger(0));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryString() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "foo", String.class.getName(), new JsonObject(), this.onSuccess(distincted -> {
            this.assertEquals(10L, distincted.size());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryBoolean() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "big", Boolean.class.getName(), new JsonObject(), this.onSuccess(distincted -> {
            this.assertEquals(1L, distincted.size());
            this.assertEquals(true, distincted.getBoolean(0));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryDouble() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "dblval", Double.class.getName(), new JsonObject(), this.onSuccess(distincted -> {
            this.assertEquals(1L, distincted.size());
            this.assertEquals(1.23, distincted.getDouble(0));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryLong() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "longval", Long.class.getName(), new JsonObject(), this.onSuccess(distincted -> {
            this.assertEquals(1L, distincted.size());
            this.assertEquals(123456789L, distincted.getLong(0));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryBadResultClass() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "foo", Object.class.getName(), new JsonObject(), this.onFailure(failure -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryEmptyResult() {
        String collection = this.randomCollection();
        JsonObject query = new JsonObject().put("title", (Object)"The Hobbit");
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "longval", Long.class.getName(), query, this.onSuccess(distincted -> {
            this.assertEquals(0L, distincted.size());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctBatchBadResultClass() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctBatch(collection, "foo", Object.class.getName()).exceptionHandler(t -> this.testComplete()).endHandler(v -> this.fail("Throwable expected")).handler(v -> this.fail("Throwable expected"))));
        this.await();
    }

    @Test
    public void testDistinctStringBadFormat() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinct(collection, "foo", Integer.class.getName(), this.onFailure(failure -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testDistinctUnexistentString() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinct(collection, "unexist", String.class.getName(), this.onSuccess(distincted -> {
            this.assertEquals(0L, distincted.size());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctBatchString() throws Exception {
        String collection = this.randomCollection();
        int numDocs = 10;
        List results = Collections.synchronizedList(new ArrayList());
        this.insertDocs(this.mongoClient, collection, numDocs, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctBatch(collection, "foo", String.class.getName()).exceptionHandler(arg_0 -> ((DistinctTest)this).fail(arg_0)).endHandler(v -> this.testComplete()).handler(results::add)));
        this.await();
        this.assertEquals(numDocs, results.size());
    }

    @Test
    public void testDistinctBatchWithQueryBadResultClass() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctBatchWithQuery(collection, "foo", Object.class.getName(), new JsonObject()).exceptionHandler(t -> this.testComplete()).endHandler(v -> this.fail("Throwable expected")).handler(v -> this.fail("Throwable expected"))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryStringBadFormat() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "foo", Integer.class.getName(), new JsonObject(), this.onFailure(failure -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testDistinctWithQueryUnexistentString() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctWithQuery(collection, "unexist", String.class.getName(), new JsonObject(), this.onSuccess(distincted -> {
            this.assertEquals(0L, distincted.size());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDistinctBatchWithQueryString() throws Exception {
        String collection = this.randomCollection();
        int numDocs = 10;
        List results = Collections.synchronizedList(new ArrayList());
        this.insertDocs(this.mongoClient, collection, numDocs, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctBatchWithQuery(collection, "foo", String.class.getName(), new JsonObject()).exceptionHandler(arg_0 -> ((DistinctTest)this).fail(arg_0)).endHandler(v -> this.testComplete()).handler(results::add)));
        this.await();
        this.assertEquals(numDocs, results.size());
    }

    @Test
    public void testDistinctOptionsWithCollationSetting() {
        String collection = this.randomCollection();
        this.mongoClient.distinctWithQuery(collection, "num", Integer.class.getName(), new JsonObject(), new DistinctOptions().setCollation(new CollationOptions()));
        int numDocs = 10;
        List results = Collections.synchronizedList(new ArrayList());
        this.insertDocs(this.mongoClient, collection, numDocs, this::createDocWithAmbiguitiesDependingOnLocale, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctBatchWithQuery(collection, "foo", String.class.getName(), new JsonObject(), new DistinctOptions().setCollation(new CollationOptions().setLocale("de_AT"))).exceptionHandler(arg_0 -> ((DistinctTest)this).fail(arg_0)).endHandler(v -> this.testComplete()).handler(results::add)));
        this.await();
        this.assertEquals(2L, results.size());
    }

    @Test
    public void testDistinctOptionsSetting() {
        String collection = this.randomCollection();
        this.mongoClient.distinctWithQuery(collection, "num", Integer.class.getName(), new JsonObject(), new DistinctOptions());
        int numDocs = 10;
        List results = Collections.synchronizedList(new ArrayList());
        this.insertDocs(this.mongoClient, collection, numDocs, this::createDocWithAmbiguitiesDependingOnLocale, (Handler<AsyncResult<Void>>)this.onSuccess(inserted -> this.mongoClient.distinctBatchWithQuery(collection, "foo", String.class.getName(), new JsonObject(), new DistinctOptions()).exceptionHandler(arg_0 -> ((DistinctTest)this).fail(arg_0)).endHandler(v -> this.testComplete()).handler(results::add)));
        this.await();
        this.assertEquals(2L, results.size());
    }

    @Test
    public void testDistinctOptionsFromJson() {
        JsonObject json = new JsonObject().put("collation", (Object)new JsonObject().put("locale", (Object)"simple"));
        DistinctOptions options = new DistinctOptions(json);
        this.assertEquals(new CollationOptions(), options.getCollation());
    }

    @Test
    public void testDistinctOptionsToJson() {
        JsonObject json = new JsonObject().put("collation", (Object)new JsonObject().put("locale", (Object)"simple"));
        DistinctOptions options = new DistinctOptions().setCollation(new CollationOptions());
        this.assertEquals(json, options.toJson());
    }
}

