/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CountOptions;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class CountOptionsTest {
    private static void assertNotEqual(BiConsumer<CountOptions, CountOptions> f) {
        CountOptions a = new CountOptions();
        CountOptions b = new CountOptions();
        f.accept(a, b);
        Assert.assertNotEquals((Object)a, (Object)b);
    }

    private static void assertNotEqual(int expected, Consumer<CountOptions> f) {
        CountOptions o = new CountOptions();
        f.accept(o);
        Assert.assertNotEquals((long)expected, (long)o.hashCode());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new CountOptions(), (Object)new CountOptions());
        CountOptionsTest.assertNotEqual((a, b) -> {
            a.setCollation(new CollationOptions().setLocale("de_AT"));
            b.setCollation(new CollationOptions().setLocale("de_DE"));
        });
        CountOptionsTest.assertNotEqual((a, b) -> {
            a.setHint(new JsonObject("{ \"$natural\" : 1 }"));
            b.setHint(new JsonObject("{ \"$natural\" : -1 }"));
        });
        CountOptionsTest.assertNotEqual((a, b) -> {
            a.setHintString("x");
            b.setHintString("y");
        });
        CountOptionsTest.assertNotEqual((a, b) -> {
            a.setLimit(Integer.valueOf(10));
            b.setLimit(Integer.valueOf(20));
        });
        CountOptionsTest.assertNotEqual((a, b) -> {
            a.setSkip(Integer.valueOf(1));
            b.setSkip(Integer.valueOf(2));
        });
        CountOptionsTest.assertNotEqual((a, b) -> {
            a.setMaxTime(Long.valueOf(100L));
            a.setMaxTime(Long.valueOf(200L));
        });
        Assert.assertNotEquals((Object)new CountOptions(), null);
    }

    @Test
    public void testHashCode() {
        CountOptions a = new CountOptions();
        int hash = a.hashCode();
        Assert.assertEquals((long)hash, (long)new CountOptions().hashCode());
        CountOptionsTest.assertNotEqual(hash, o -> o.setCollation(new CollationOptions()));
        CountOptionsTest.assertNotEqual(hash, o -> o.setHint(new JsonObject("{ \"$natural\" : 1 }")));
        CountOptionsTest.assertNotEqual(hash, o -> o.setHintString("x"));
        CountOptionsTest.assertNotEqual(hash, o -> o.setLimit(Integer.valueOf(10)));
        CountOptionsTest.assertNotEqual(hash, o -> o.setSkip(Integer.valueOf(2)));
        CountOptionsTest.assertNotEqual(hash, o -> o.setMaxTime(Long.valueOf(10L)));
    }

    @Test
    public void testCountOptionsFromJson() {
        JsonObject json = new JsonObject().put("hint", (Object)new JsonObject().put("some", (Object)"hint")).put("hintString", (Object)"someHintString").put("limit", (Object)10).put("skip", (Object)20).put("maxTime", (Object)30L).put("collation", (Object)new JsonObject().put("locale", (Object)"simple"));
        CountOptions options = new CountOptions(json);
        Assert.assertEquals((Object)new JsonObject().put("some", (Object)"hint"), (Object)options.getHint());
        Assert.assertEquals((Object)"someHintString", (Object)options.getHintString());
        Assert.assertEquals((Object)10, (Object)options.getLimit());
        Assert.assertEquals((Object)20, (Object)options.getSkip());
        Assert.assertEquals((Object)30L, (Object)options.getMaxTime());
        Assert.assertEquals((Object)new CollationOptions(), (Object)options.getCollation());
    }

    @Test
    public void testCountOptionsToJson() {
        JsonObject json = new JsonObject().put("hint", (Object)new JsonObject().put("some", (Object)"hint")).put("hintString", (Object)"someHintString").put("limit", (Object)10).put("skip", (Object)20).put("maxTime", (Object)30L).put("collation", (Object)new JsonObject().put("locale", (Object)"simple"));
        CountOptions options = new CountOptions().setCollation(new CollationOptions()).setHint(new JsonObject().put("some", (Object)"hint")).setHintString("someHintString").setLimit(Integer.valueOf(10)).setSkip(Integer.valueOf(20)).setMaxTime(Long.valueOf(30L));
        Assert.assertEquals((Object)json, (Object)options.toJson());
    }
}

