/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class CollationOptionsTest {
    private static void assertNotEqual(BiConsumer<CollationOptions, CollationOptions> f) {
        CollationOptions a = new CollationOptions();
        CollationOptions b = new CollationOptions();
        f.accept(a, b);
        Assert.assertNotEquals((Object)a, (Object)b);
    }

    private static void assertNotEqual(int expected, Consumer<CollationOptions> f) {
        CollationOptions o = new CollationOptions();
        f.accept(o);
        Assert.assertNotEquals((long)expected, (long)o.hashCode());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new CollationOptions(), (Object)new CollationOptions());
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setAlternate(CollationAlternate.NON_IGNORABLE);
            b.setAlternate(CollationAlternate.SHIFTED);
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setBackwards(Boolean.valueOf(true));
            b.setBackwards(Boolean.valueOf(false));
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setCaseFirst(CollationCaseFirst.OFF);
            b.setCaseFirst(CollationCaseFirst.LOWER);
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setCaseFirst(CollationCaseFirst.OFF);
            b.setCaseFirst(CollationCaseFirst.UPPER);
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setCaseFirst(CollationCaseFirst.LOWER);
            b.setCaseFirst(CollationCaseFirst.UPPER);
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setLocale("en_US");
            b.setLocale("de_AT");
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setCaseLevel(Boolean.valueOf(true));
            b.setCaseLevel(Boolean.valueOf(false));
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setMaxVariable(CollationMaxVariable.PUNCT);
            b.setMaxVariable(CollationMaxVariable.SPACE);
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setNormalization(Boolean.valueOf(true));
            b.setNormalization(Boolean.valueOf(false));
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setNumericOrdering(Boolean.valueOf(true));
            b.setNumericOrdering(Boolean.valueOf(false));
        });
        CollationOptionsTest.assertNotEqual((a, b) -> {
            a.setStrength(CollationStrength.PRIMARY);
            b.setStrength(CollationStrength.SECONDARY);
        });
        Assert.assertNotEquals((Object)new CollationOptions(), null);
    }

    @Test
    public void testHashCode() {
        CollationOptions a = new CollationOptions();
        int hash = a.hashCode();
        Assert.assertEquals((long)hash, (long)new CollationOptions().hashCode());
        CollationOptionsTest.assertNotEqual(hash, o -> o.setStrength(CollationStrength.PRIMARY));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setNormalization(Boolean.valueOf(true)));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setNumericOrdering(Boolean.valueOf(true)));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setMaxVariable(CollationMaxVariable.SPACE));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setLocale("de_AT"));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setCaseLevel(Boolean.valueOf(true)));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setCaseFirst(CollationCaseFirst.UPPER));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setCaseFirst(CollationCaseFirst.LOWER));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setAlternate(CollationAlternate.SHIFTED));
        CollationOptionsTest.assertNotEqual(hash, o -> o.setBackwards(Boolean.valueOf(true)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidStrengthLevelLessThan1() {
        CollationOptions collationOptions = new CollationOptions();
        collationOptions.setStrength(CollationStrength.fromInt((int)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidStrengthLevelGreaterThan5() {
        CollationOptions collationOptions = new CollationOptions();
        collationOptions.setStrength(CollationStrength.fromInt((int)6));
    }

    @Test
    public void testCollationOptionsFromEmptyJson() {
        CollationOptions options = new CollationOptions(new JsonObject());
        Assert.assertEquals((Object)"simple", (Object)options.getLocale());
        Assert.assertNull((Object)options.getAlternate());
        Assert.assertNull((Object)options.isBackwards());
        Assert.assertNull((Object)options.getCaseFirst());
        Assert.assertNull((Object)options.isCaseLevel());
        Assert.assertNull((Object)options.getMaxVariable());
        Assert.assertNull((Object)options.isNumericOrdering());
        Assert.assertNull((Object)options.getStrength());
    }

    @Test
    public void testCollationOptionsFromJson() {
        CollationOptions options = new CollationOptions(new JsonObject().put("locale", (Object)"de_AT").put("alternate", (Object)"non-ignorable").put("backwards", (Object)true).put("caseFirst", (Object)"upper").put("caseLevel", (Object)true).put("maxVariable", (Object)"punct").put("numericOrdering", (Object)true).put("normalization", (Object)true).put("strength", (Object)2));
        Assert.assertEquals((Object)"de_AT", (Object)options.getLocale());
        Assert.assertEquals((Object)CollationAlternate.NON_IGNORABLE, (Object)options.getAlternate());
        Assert.assertTrue((boolean)options.isBackwards());
        Assert.assertEquals((Object)CollationCaseFirst.UPPER, (Object)options.getCaseFirst());
        Assert.assertTrue((boolean)options.isCaseLevel());
        Assert.assertEquals((Object)CollationMaxVariable.PUNCT, (Object)options.getMaxVariable());
        Assert.assertTrue((boolean)options.isNumericOrdering());
        Assert.assertTrue((boolean)options.isNormalization());
        Assert.assertEquals((Object)CollationStrength.SECONDARY, (Object)options.getStrength());
    }

    @Test
    public void testCollationOptionsToJson() {
        JsonObject json = new JsonObject().put("locale", (Object)"de_AT").put("alternate", (Object)"non-ignorable").put("backwards", (Object)true).put("caseFirst", (Object)"upper").put("caseLevel", (Object)true).put("maxVariable", (Object)"punct").put("numericOrdering", (Object)true).put("normalization", (Object)true).put("strength", (Object)2);
        CollationOptions options = new CollationOptions().setLocale("de_AT").setAlternate(CollationAlternate.NON_IGNORABLE).setStrength(CollationStrength.SECONDARY).setBackwards(Boolean.valueOf(true)).setCaseLevel(Boolean.valueOf(true)).setCaseFirst(CollationCaseFirst.UPPER).setMaxVariable(CollationMaxVariable.PUNCT).setNormalization(Boolean.valueOf(true)).setNumericOrdering(Boolean.valueOf(true));
        Assert.assertEquals((Object)json, (Object)options.toJson());
    }
}

