/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkOperationType;
import io.vertx.ext.mongo.CollationOptions;
import org.junit.Assert;
import org.junit.Test;

public class BulkOperationTest {
    @Test
    public void testEquals() {
        BulkOperation a = BulkOperation.createUpdate((JsonObject)new JsonObject(), (JsonObject)new JsonObject());
        BulkOperation b = BulkOperation.createUpdate((JsonObject)new JsonObject(), (JsonObject)new JsonObject());
        a.setType(BulkOperationType.UPDATE);
        b.setType(BulkOperationType.INSERT);
        Assert.assertNotEquals((Object)a, (Object)b);
        b.setType(BulkOperationType.UPDATE);
        Assert.assertEquals((Object)a, (Object)b);
        a.setFilter(new JsonObject().put("foo", (Object)"bar"));
        b.setFilter(new JsonObject().put("foo", (Object)"eek"));
        Assert.assertNotEquals((Object)a, (Object)b);
        b.setFilter(new JsonObject().put("foo", (Object)"bar"));
        Assert.assertEquals((Object)a, (Object)b);
        a.setDocument(new JsonObject().put("bar", (Object)"foo"));
        b.setDocument(new JsonObject().put("bar", (Object)"eek"));
        Assert.assertNotEquals((Object)a, (Object)b);
        b.setDocument(new JsonObject().put("bar", (Object)"foo"));
        Assert.assertEquals((Object)a, (Object)b);
        a.setMulti(true);
        b.setMulti(false);
        Assert.assertNotEquals((Object)a, (Object)b);
        b.setMulti(true);
        Assert.assertEquals((Object)a, (Object)b);
        a.setUpsert(true);
        b.setUpsert(false);
        Assert.assertNotEquals((Object)a, (Object)b);
        b.setUpsert(true);
        Assert.assertEquals((Object)a, (Object)b);
        a.setCollation(new CollationOptions());
        b.setCollation(new CollationOptions().setLocale("de_AT"));
        Assert.assertNotEquals((Object)a, (Object)b);
        b.setCollation(new CollationOptions());
        Assert.assertEquals((Object)a, (Object)b);
        a.setHint(new JsonObject().put("foo", (Object)"bar"));
        b.setHint(new JsonObject().put("bar", (Object)"foo"));
        Assert.assertNotEquals((Object)a, (Object)b);
        b.setHint(new JsonObject().put("foo", (Object)"bar"));
        Assert.assertEquals((Object)a, (Object)b);
        a.setHintString("foo");
        b.setHintString("bar");
        Assert.assertNotEquals((Object)a, (Object)b);
        b.setHintString("foo");
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, null);
    }

    @Test
    public void testHashCode() {
        BulkOperation a = BulkOperation.createUpdate((JsonObject)new JsonObject().put("foo", (Object)"bar"), (JsonObject)new JsonObject().put("bar", (Object)"foo"), (boolean)true, (boolean)true);
        int hash = a.hashCode();
        a.setType(BulkOperationType.INSERT);
        Assert.assertNotEquals((long)hash, (long)a.hashCode());
        a.setType(BulkOperationType.UPDATE);
        Assert.assertEquals((long)hash, (long)a.hashCode());
        a.setFilter(new JsonObject().put("foo", (Object)"eek"));
        Assert.assertNotEquals((long)hash, (long)a.hashCode());
        a.setFilter(new JsonObject().put("foo", (Object)"bar"));
        Assert.assertEquals((long)hash, (long)a.hashCode());
        a.setDocument(new JsonObject().put("bar", (Object)"eek"));
        Assert.assertNotEquals((long)hash, (long)a.hashCode());
        a.setDocument(new JsonObject().put("bar", (Object)"foo"));
        Assert.assertEquals((long)hash, (long)a.hashCode());
        a.setMulti(false);
        Assert.assertNotEquals((long)hash, (long)a.hashCode());
        a.setMulti(true);
        Assert.assertEquals((long)hash, (long)a.hashCode());
        a.setUpsert(false);
        Assert.assertNotEquals((long)hash, (long)a.hashCode());
        a.setUpsert(true);
        Assert.assertEquals((long)hash, (long)a.hashCode());
        a.setCollation(new CollationOptions());
        Assert.assertNotEquals((long)hash, (long)a.hashCode());
        a.setCollation(null);
        Assert.assertEquals((long)hash, (long)a.hashCode());
        a.setHint(new JsonObject().put("foo", (Object)"bar"));
        Assert.assertNotEquals((long)hash, (long)a.hashCode());
        a.setHint(null);
        Assert.assertEquals((long)hash, (long)a.hashCode());
        a.setHintString("foo");
        Assert.assertNotEquals((long)hash, (long)a.hashCode());
        a.setHintString(null);
        Assert.assertEquals((long)hash, (long)a.hashCode());
        Assert.assertNotEquals((Object)a, null);
    }
}

