/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.test.core.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class AggregateOptionsTest {
    @Test
    public void testOptions() {
        AggregateOptions options = new AggregateOptions();
        long maxTime = TestUtils.randomLong();
        int batchSize = TestUtils.randomInt();
        boolean allowDiskUser = TestUtils.randomBoolean();
        CollationOptions collation = new CollationOptions();
        Assert.assertEquals((Object)options, (Object)options.setMaxTime(maxTime));
        Assert.assertEquals((long)maxTime, (long)options.getMaxTime());
        Assert.assertEquals((Object)options, (Object)options.setCollation(collation));
        Assert.assertEquals((Object)collation, (Object)options.getCollation());
        Assert.assertEquals((Object)options, (Object)options.setAllowDiskUse(Boolean.valueOf(allowDiskUser)));
        Assert.assertEquals((Object)allowDiskUser, (Object)options.getAllowDiskUse());
        Assert.assertEquals((Object)options, (Object)options.setBatchSize(batchSize));
        Assert.assertEquals((long)batchSize, (long)options.getBatchSize());
    }

    @Test
    public void testDefaultOptions() {
        AggregateOptions options = new AggregateOptions();
        Assert.assertEquals((long)0L, (long)options.getMaxTime());
        Assert.assertEquals((long)20L, (long)options.getBatchSize());
        Assert.assertNull((Object)options.getCollation());
    }

    @Test
    public void testOptionsJson() {
        JsonObject json = new JsonObject();
        long maxAwaitTime = TestUtils.randomLong();
        json.put("maxAwaitTime", (Object)maxAwaitTime);
        long maxTime = TestUtils.randomLong();
        json.put("maxTime", (Object)maxTime);
        int batchSize = TestUtils.randomInt();
        json.put("batchSize", (Object)batchSize);
        boolean allowDiskUse = TestUtils.randomBoolean();
        json.put("allowDiskUse", (Object)allowDiskUse);
        CollationOptions collation = new CollationOptions();
        json.put("collation", (Object)collation.toJson());
        AggregateOptions options = new AggregateOptions(json);
        Assert.assertEquals((long)maxTime, (long)options.getMaxTime());
        Assert.assertEquals((long)batchSize, (long)options.getBatchSize());
        Assert.assertEquals((Object)allowDiskUse, (Object)options.getAllowDiskUse());
        Assert.assertEquals((Object)collation, (Object)options.getCollation());
    }

    @Test
    public void testDefaultOptionsJson() {
        AggregateOptions options = new AggregateOptions(new JsonObject());
        AggregateOptions def = new AggregateOptions();
        Assert.assertEquals((long)def.getMaxTime(), (long)options.getMaxTime());
        Assert.assertEquals((Object)def.getAllowDiskUse(), (Object)options.getAllowDiskUse());
        Assert.assertEquals((long)def.getBatchSize(), (long)options.getBatchSize());
        Assert.assertNull((Object)options.getCollation());
    }

    @Test
    public void testCopyOptions() {
        CollationOptions collationOptions = new CollationOptions();
        AggregateOptions options = new AggregateOptions().setCollation(collationOptions);
        options.setMaxTime(TestUtils.randomLong());
        AggregateOptions copy = new AggregateOptions(options);
        Assert.assertEquals((long)options.getMaxTime(), (long)copy.getMaxTime());
        Assert.assertEquals((Object)options.getAllowDiskUse(), (Object)copy.getAllowDiskUse());
        Assert.assertEquals((long)options.getBatchSize(), (long)copy.getBatchSize());
        Assert.assertEquals((Object)options.getCollation(), (Object)copy.getCollation());
    }

    @Test
    public void testToJson() {
        CollationOptions collationOptions = new CollationOptions();
        AggregateOptions options = new AggregateOptions().setCollation(collationOptions);
        long maxTime = TestUtils.randomPositiveLong();
        options.setMaxTime(maxTime);
        int batchSize = TestUtils.randomInt();
        options.setBatchSize(batchSize);
        boolean allowDiskUse = TestUtils.randomBoolean();
        options.setAllowDiskUse(Boolean.valueOf(allowDiskUse));
        CollationOptions collation = new CollationOptions();
        options.setCollation(collation);
        Assert.assertEquals((Object)options, (Object)new AggregateOptions(options.toJson()));
    }
}

