/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.WriteConcern;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.WriteConcernParser;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class WriteConcernParserTest {
    @Test
    public void testNoWriteConcern() {
        WriteConcern wc = new WriteConcernParser(null, new JsonObject()).writeConcern();
        Assert.assertNull((Object)wc);
    }

    @Test
    public void testWriteConcern() {
        JsonObject config = new JsonObject();
        config.put("writeConcern", (Object)"ACKNOWLEDGED");
        WriteConcern wc = new WriteConcernParser(null, config).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)WriteConcern.ACKNOWLEDGED, (Object)wc);
    }

    @Test
    public void testWriteConcernCaseInsensitive() {
        JsonObject config = new JsonObject();
        config.put("writeConcern", (Object)"acknowledged");
        WriteConcern wc = new WriteConcernParser(null, config).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)WriteConcern.ACKNOWLEDGED, (Object)wc);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidWriteConcern() {
        JsonObject config = new JsonObject();
        config.put("writeConcern", (Object)"foo");
        new WriteConcernParser(null, config).writeConcern();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTypeWriteConcern() {
        JsonObject config = new JsonObject();
        config.put("writeConcern", (Object)123);
        new WriteConcernParser(null, config);
    }

    @Test
    public void testAdvancedWriteConcern_w_int() {
        WriteConcern expected = new WriteConcern(3).withWTimeout(25L, TimeUnit.MILLISECONDS).withJournal(Boolean.valueOf(true));
        JsonObject config = new JsonObject();
        config.put("w", (Object)3);
        config.put("wtimeoutMS", (Object)25);
        config.put("j", (Object)true);
        WriteConcern wc = new WriteConcernParser(null, config).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)expected, (Object)wc);
    }

    @Test
    public void testAdvancedWriteConcern_w_string() {
        WriteConcern expected = WriteConcern.MAJORITY.withWTimeout(1L, TimeUnit.MILLISECONDS).withJournal(Boolean.valueOf(true));
        JsonObject config = new JsonObject();
        config.put("w", (Object)"majority");
        config.put("wtimeoutMS", (Object)1);
        config.put("j", (Object)true);
        WriteConcern wc = new WriteConcernParser(null, config).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)expected, (Object)wc);
    }

    @Test
    public void testAdvancedWriteConcern_w_int_only() {
        WriteConcern expected = new WriteConcern(123);
        JsonObject config = new JsonObject();
        config.put("w", (Object)123);
        WriteConcern wc = new WriteConcernParser(null, config).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)expected, (Object)wc);
    }

    @Test
    public void testAdvancedWriteConcern_w_string_only() {
        WriteConcern expected = new WriteConcern("foo");
        JsonObject config = new JsonObject();
        config.put("w", (Object)"foo");
        WriteConcern wc = new WriteConcernParser(null, config).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)expected, (Object)wc);
    }

    @Test
    public void testSimpleAndAdvancedWriteConcern() {
        WriteConcern expected = WriteConcern.JOURNALED;
        JsonObject config = new JsonObject();
        config.put("w", (Object)"majority");
        config.put("wtimeoutMS", (Object)1);
        config.put("j", (Object)true);
        config.put("writeConcern", (Object)"journaled");
        WriteConcern wc = new WriteConcernParser(null, config).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)expected, (Object)wc);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidWriteConcern_w_boolean() {
        JsonObject config = new JsonObject();
        config.put("w", (Object)true);
        new WriteConcernParser(null, config).writeConcern();
    }

    @Test
    public void testConnStringNoWriteConcern() {
        ConnectionString connString = new ConnectionString("mongodb://localhost:27017/mydb?replicaSet=myapp");
        WriteConcern rp = new WriteConcernParser(connString, new JsonObject()).writeConcern();
        Assert.assertNull((Object)rp);
    }

    @Test
    public void testConnStringWriteConcern() {
        ConnectionString connString = new ConnectionString("mongodb://localhost:27017/mydb?replicaSet=myapp&safe=true");
        WriteConcern wc = new WriteConcernParser(connString, new JsonObject()).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)WriteConcern.ACKNOWLEDGED, (Object)wc);
    }

    @Test
    public void testConnStringSimpleAndAdvancedWriteConcern() {
        ConnectionString connString = new ConnectionString("mongodb://localhost:27017/mydb?replicaSet=myapp&w=majority&wtimeoutms=20&journal=false");
        WriteConcern expected = new WriteConcern("majority").withWTimeout(20L, TimeUnit.MILLISECONDS).withJournal(Boolean.valueOf(false));
        WriteConcern wc = new WriteConcernParser(connString, new JsonObject()).writeConcern();
        Assert.assertNotNull((Object)wc);
        Assert.assertEquals((Object)expected, (Object)wc);
    }
}

