/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.connection.SocketSettings;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.SocketSettingsParser;
import io.vertx.test.core.TestUtils;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class SocketSettingsParserTest {
    @Test
    public void testSocketSettings() {
        int connectTimeoutMS = Math.abs(TestUtils.randomInt());
        int socketTimeoutMS = Math.abs(TestUtils.randomInt());
        int receiveBufferSize = Math.abs(TestUtils.randomInt());
        int sendBufferSize = Math.abs(TestUtils.randomInt());
        JsonObject config = new JsonObject();
        config.put("connectTimeoutMS", (Object)connectTimeoutMS);
        config.put("socketTimeoutMS", (Object)socketTimeoutMS);
        config.put("receiveBufferSize", (Object)receiveBufferSize);
        config.put("sendBufferSize", (Object)sendBufferSize);
        SocketSettings settings = new SocketSettingsParser(null, config).settings();
        Assert.assertEquals((long)connectTimeoutMS, (long)settings.getConnectTimeout(TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)socketTimeoutMS, (long)settings.getReadTimeout(TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)receiveBufferSize, (long)settings.getReceiveBufferSize());
        Assert.assertEquals((long)sendBufferSize, (long)settings.getSendBufferSize());
    }
}

