/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.MongoClientSettings;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactoryFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.netty.NettyStreamFactoryFactory;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class ParsingStreamTypeTest {
    private Vertx vertx;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Test
    public void should_not_include_any_stream_type_by_default_for_backwards_compatibility() {
        JsonObject noStreamTypeProvided = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs");
        MongoClientSettings parsedSettings = new MongoClientOptionsParser(this.vertx, noStreamTypeProvided).settings();
        Assert.assertNull((Object)parsedSettings.getStreamFactoryFactory());
    }

    @Parameters(method="validSteamTypes")
    @Test
    public void should_parse_stream_type_from_config_property(String streamTypeString, Class<StreamFactoryFactory> streamType) {
        JsonObject cfgWithStreamTypeProvided = new JsonObject().put("streamType", (Object)streamTypeString);
        MongoClientSettings parsedSettings = new MongoClientOptionsParser(this.vertx, cfgWithStreamTypeProvided).settings();
        Assert.assertThat((Object)parsedSettings.getStreamFactoryFactory(), (Matcher)CoreMatchers.instanceOf(streamType));
    }

    @Test(expected=IllegalArgumentException.class)
    public void only_valid_stream_type_values_allowed_as_config_property() {
        JsonObject withInvalidStreamType = new JsonObject().put("streamType", (Object)"unrecognized");
        new MongoClientOptionsParser(this.vertx, withInvalidStreamType).settings();
    }

    private Object[] validSteamTypes() {
        return new Object[]{new Object[]{"nio2", AsynchronousSocketChannelStreamFactoryFactory.class}, new Object[]{"netty", NettyStreamFactoryFactory.class}};
    }
}

