/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ReadConcern;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class ParsingReadConcernLevelTest {
    private Vertx vertx;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Parameters(method="validReadConcernValues")
    @Test
    public void should_parse_read_concern_from_connection_string(String readConcernString, ReadConcern expectedReadConcern) throws Exception {
        JsonObject configWithConnectionString = new JsonObject().put("connection_string", (Object)String.format("mongodb://localhost:27017/mydb?replicaSet=myRs&readconcernlevel=%s", readConcernString));
        ReadConcern parsedReadConcern = new MongoClientOptionsParser(this.vertx, configWithConnectionString).settings().getReadConcern();
        Assert.assertEquals((Object)expectedReadConcern, (Object)parsedReadConcern);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_an_exception_in_case_of_unrecognized_read_concern_level_in_connection_string() throws Exception {
        JsonObject configWithConnectionString = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs&readconcernlevel=unrecognized");
        new MongoClientOptionsParser(this.vertx, configWithConnectionString).settings().getReadConcern();
    }

    @Parameters(method="validReadConcernValues")
    @Test
    public void should_fallback_to_config_property_if_read_concern_not_present_in_connection_string(String readConcernString, ReadConcern expectedReadConcern) throws Exception {
        JsonObject configWithReadConcernAsSeparateProperty = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs").put("readConcernLevel", (Object)readConcernString);
        ReadConcern parsedReadConcern = new MongoClientOptionsParser(this.vertx, configWithReadConcernAsSeparateProperty).settings().getReadConcern();
        Assert.assertEquals((Object)expectedReadConcern, (Object)parsedReadConcern);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_an_exception_in_case_of_unrecognized_read_concern_level_passed_as_config_property() throws Exception {
        JsonObject configWithReadConcernAsSeparateProperty = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs").put("readConcernLevel", (Object)"unrecognized");
        new MongoClientOptionsParser(this.vertx, configWithReadConcernAsSeparateProperty).settings().getReadConcern();
    }

    @Test
    public void should_return_default_read_concern_in_case_of_missing_read_concern_in_connection_string_or_config_object() throws Exception {
        JsonObject configWithConnectionString = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs");
        ReadConcern parsedReadConcern = new MongoClientOptionsParser(this.vertx, configWithConnectionString).settings().getReadConcern();
        Assert.assertEquals((Object)ReadConcern.DEFAULT, (Object)parsedReadConcern);
    }

    @Test
    public void should_prefer_read_concern_passed_via_connection_string_over_property_value() throws Exception {
        JsonObject configWithReadConcernPassedTwice = new JsonObject().put("connection_string", (Object)"mongodb://localhost:27017/mydb?replicaSet=myRs&readconcernlevel=linearizable").put("readConcernLevel", (Object)"majority");
        ReadConcern parsedReadConcern = new MongoClientOptionsParser(this.vertx, configWithReadConcernPassedTwice).settings().getReadConcern();
        Assert.assertEquals((Object)ReadConcern.MAJORITY, (Object)parsedReadConcern);
    }

    private Object[] validReadConcernValues() {
        return new Object[]{new Object[]{"local", ReadConcern.LOCAL}, new Object[]{"majority", ReadConcern.MAJORITY}, new Object[]{"linearizable", ReadConcern.LINEARIZABLE}};
    }
}

