/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MongoClientOptionsParserTest {
    private Vertx vertx;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Test
    public void testConnStringDbName() {
        String connectionString = "mongodb://localhost:27017/unused_db";
        JsonObject config = new JsonObject().put("connection_string", (Object)connectionString).put("db_name", (Object)"mydb");
        MongoClientOptionsParser parser = new MongoClientOptionsParser(this.vertx, config);
        Assert.assertEquals((Object)"mydb", (Object)parser.database());
    }

    @Test
    public void testDbName() {
        String connectionString = "mongodb://localhost:27017/";
        JsonObject config = new JsonObject().put("connection_string", (Object)connectionString).put("db_name", (Object)"my_db");
        MongoClientOptionsParser parser = new MongoClientOptionsParser(this.vertx, config);
        Assert.assertEquals((Object)"my_db", (Object)parser.database());
    }
}

