/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.config.ClusterSettingsParser;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class ClusterSettingsParserTest {
    @Test
    public void testSingleHost() {
        ClusterSettingsParserTest.assertSingleHost(ClusterConnectionMode.SINGLE, ClusterSettingsParserTest.settings(ClusterSettingsParserTest.singleHost()));
    }

    @Test
    public void testMultipleHosts() {
        ClusterSettingsParserTest.assertMultipleHosts(ClusterSettingsParserTest.settings(ClusterSettingsParserTest.multipleHosts()));
    }

    @Test
    public void testMultipleAndSingleHost() {
        ClusterSettingsParserTest.assertMultipleHosts(ClusterSettingsParserTest.settings(ClusterSettingsParserTest.singleHost(ClusterSettingsParserTest.multipleHosts())));
    }

    @Test
    public void testReplicaSetSingleHost() {
        ClusterSettings settings = ClusterSettingsParserTest.settings(ClusterSettingsParserTest.singleHost().put("replicaSet", (Object)"foo"));
        ClusterSettingsParserTest.assertSingleHost(ClusterConnectionMode.MULTIPLE, settings);
        Assert.assertEquals((Object)"foo", (Object)settings.getRequiredReplicaSetName());
    }

    @Test
    public void testReplicaSetMultipleHosts() {
        ClusterSettings settings = ClusterSettingsParserTest.settings(ClusterSettingsParserTest.multipleHosts().put("replicaSet", (Object)"foobar"));
        ClusterSettingsParserTest.assertMultipleHosts(settings);
        Assert.assertEquals((Object)"foobar", (Object)settings.getRequiredReplicaSetName());
    }

    @Test
    public void testServerSelectionTimeoutMS() {
        ClusterSettings settings = ClusterSettingsParserTest.settings(ClusterSettingsParserTest.multipleHosts().put("serverSelectionTimeoutMS", (Object)7533L));
        ClusterSettingsParserTest.assertMultipleHosts(settings);
        Assert.assertEquals((long)7533L, (long)settings.getServerSelectionTimeout(TimeUnit.MILLISECONDS));
    }

    private static void assertSingleHost(ClusterConnectionMode mode, ClusterSettings settings) {
        List hosts = settings.getHosts();
        Assert.assertNotNull((Object)hosts);
        Assert.assertEquals((long)1L, (long)hosts.size());
        Assert.assertEquals((Object)new ServerAddress("single.host", 1111), hosts.get(0));
        Assert.assertEquals((Object)mode, (Object)settings.getMode());
    }

    private static void assertMultipleHosts(ClusterSettings settings) {
        List hosts = settings.getHosts();
        Assert.assertNotNull((Object)hosts);
        Assert.assertEquals((long)2L, (long)hosts.size());
        Assert.assertEquals((Object)new ServerAddress("multiple.1", 2222), hosts.get(0));
        Assert.assertEquals((Object)new ServerAddress("multiple.2", 3333), hosts.get(1));
        Assert.assertEquals((Object)ClusterConnectionMode.MULTIPLE, (Object)settings.getMode());
    }

    private static ClusterSettings settings(JsonObject config) {
        return new ClusterSettingsParser(null, config).settings();
    }

    private static JsonObject singleHost() {
        return ClusterSettingsParserTest.singleHost(new JsonObject().put("host", (Object)"single.host").put("port", (Object)1111));
    }

    private static JsonObject singleHost(JsonObject config) {
        return config.put("host", (Object)"single.host").put("port", (Object)1111);
    }

    private static JsonObject multipleHosts() {
        JsonObject config = new JsonObject();
        JsonArray array = new JsonArray();
        config.put("hosts", (Object)array);
        JsonObject h = new JsonObject();
        h.put("host", (Object)"multiple.1");
        h.put("port", (Object)2222);
        array.add((Object)h);
        h = new JsonObject();
        h.put("host", (Object)"multiple.2");
        h.put("port", (Object)3333);
        array.add((Object)h);
        return config;
    }
}

