/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.codec.json;

import io.vertx.ext.mongo.impl.codec.json.AbstractJsonCodec;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bson.BsonType;
import org.junit.Assert;
import org.junit.Test;

public class AbstractJsonCodecTest {
    @Test
    public void getBsonType_returnsNullType_whenValueIsNull() {
        AbstractJsonCodec codec = this.getCodec();
        Assert.assertEquals((Object)BsonType.NULL, (Object)codec.getBsonType(null));
    }

    @Test(expected=IllegalStateException.class)
    public void testWhenGettingAnUnsupportedBsonType() {
        AbstractJsonCodec codec = this.getCodec();
        codec.writeValue(null, "foo", Collections.emptyList(), null);
    }

    private AbstractJsonCodec getCodec() {
        return new AbstractJsonCodec(){

            protected boolean isObjectIdInstance(Object instance) {
                return false;
            }

            protected Object newObject() {
                return null;
            }

            protected void add(Object object, String name, Object value) {
            }

            protected boolean isObjectInstance(Object instance) {
                return false;
            }

            protected void forEach(Object object, BiConsumer objectConsumer) {
            }

            protected Object newArray() {
                return null;
            }

            protected void add(Object array, Object value) {
            }

            protected boolean isArrayInstance(Object instance) {
                return false;
            }

            protected void forEach(Object array, Consumer arrayConsumer) {
            }

            public Class getEncoderClass() {
                return null;
            }
        };
    }
}

