/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.test.core.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class UpdateOptionsTest {
    @Test
    public void testOptions() {
        UpdateOptions options = new UpdateOptions();
        WriteOption writeOption = WriteOption.ACKNOWLEDGED;
        Assert.assertEquals((Object)options, (Object)options.setWriteOption(writeOption));
        Assert.assertEquals((Object)writeOption, (Object)options.getWriteOption());
        boolean multi = TestUtils.randomBoolean();
        Assert.assertEquals((Object)options, (Object)options.setMulti(multi));
        Assert.assertEquals((Object)multi, (Object)options.isMulti());
        boolean upsert = TestUtils.randomBoolean();
        Assert.assertEquals((Object)options, (Object)options.setUpsert(upsert));
        Assert.assertEquals((Object)upsert, (Object)options.isUpsert());
        JsonArray arrayFilters = new JsonArray().add((Object)new JsonObject().put(TestUtils.randomAlphaString((int)5), (Object)TestUtils.randomAlphaString((int)5)));
        Assert.assertEquals((Object)options, (Object)options.setArrayFilters(arrayFilters));
        Assert.assertEquals((Object)arrayFilters, (Object)options.getArrayFilters());
        JsonObject hint = new JsonObject().put(TestUtils.randomAlphaString((int)5), (Object)TestUtils.randomInt());
        Assert.assertEquals((Object)options, (Object)options.setHint(hint));
        Assert.assertEquals((Object)hint, (Object)options.getHint());
        String hintString = TestUtils.randomAlphaString((int)12);
        Assert.assertEquals((Object)options, (Object)options.setHintString(hintString));
        Assert.assertEquals((Object)hintString, (Object)options.getHintString());
    }

    @Test
    public void testDefaultOptions() {
        UpdateOptions options = new UpdateOptions();
        Assert.assertNull((Object)options.getWriteOption());
        Assert.assertFalse((boolean)options.isMulti());
        Assert.assertFalse((boolean)options.isUpsert());
        Assert.assertNull((Object)options.getArrayFilters());
        Assert.assertNull((Object)options.getHint());
        Assert.assertNull((Object)options.getHintString());
    }

    @Test
    public void testOptionsJson() {
        JsonObject json = new JsonObject();
        WriteOption writeOption = WriteOption.JOURNALED;
        json.put("writeOption", (Object)writeOption.name());
        boolean multi = TestUtils.randomBoolean();
        json.put("multi", (Object)multi);
        boolean upsert = TestUtils.randomBoolean();
        json.put("upsert", (Object)upsert);
        JsonArray arrayFilters = new JsonArray().add((Object)new JsonObject().put(TestUtils.randomAlphaString((int)5), (Object)TestUtils.randomAlphaString((int)5)));
        json.put("arrayFilters", (Object)arrayFilters);
        JsonObject hint = new JsonObject().put(TestUtils.randomAlphaString((int)5), (Object)TestUtils.randomInt());
        json.put("hint", (Object)hint);
        String hintString = TestUtils.randomAlphaString((int)12);
        json.put("hintString", (Object)hintString);
        UpdateOptions options = new UpdateOptions(json);
        Assert.assertEquals((Object)writeOption, (Object)options.getWriteOption());
        Assert.assertEquals((Object)multi, (Object)options.isMulti());
        Assert.assertEquals((Object)upsert, (Object)options.isUpsert());
        Assert.assertEquals((Object)arrayFilters, (Object)options.getArrayFilters());
        Assert.assertEquals((Object)hint, (Object)options.getHint());
        Assert.assertEquals((Object)hintString, (Object)options.getHintString());
    }

    @Test
    public void testDefaultOptionsJson() {
        UpdateOptions options = new UpdateOptions(new JsonObject());
        UpdateOptions def = new UpdateOptions();
        Assert.assertEquals((Object)def.getWriteOption(), (Object)options.getWriteOption());
        Assert.assertEquals((Object)def.isMulti(), (Object)options.isMulti());
        Assert.assertEquals((Object)def.isUpsert(), (Object)options.isUpsert());
        Assert.assertEquals((Object)def.getArrayFilters(), (Object)options.getArrayFilters());
        Assert.assertEquals((Object)def.getHint(), (Object)options.getHint());
        Assert.assertEquals((Object)def.getHintString(), (Object)options.getHintString());
    }

    @Test
    public void testCopyOptions() {
        UpdateOptions options = new UpdateOptions();
        WriteOption writeOption = WriteOption.REPLICA_ACKNOWLEDGED;
        boolean multi = TestUtils.randomBoolean();
        boolean upsert = TestUtils.randomBoolean();
        JsonArray arrayFilters = new JsonArray().add((Object)new JsonObject().put(TestUtils.randomAlphaString((int)5), (Object)TestUtils.randomAlphaString((int)5)));
        JsonObject hint = new JsonObject().put(TestUtils.randomAlphaString((int)5), (Object)TestUtils.randomInt());
        String hintString = TestUtils.randomAlphaString((int)12);
        options.setWriteOption(writeOption);
        options.setMulti(multi);
        options.setUpsert(upsert);
        options.setArrayFilters(arrayFilters);
        options.setHint(hint);
        options.setHintString(hintString);
        UpdateOptions copy = new UpdateOptions(options);
        Assert.assertEquals((Object)options.getWriteOption(), (Object)copy.getWriteOption());
        Assert.assertEquals((Object)options.isMulti(), (Object)copy.isMulti());
        Assert.assertEquals((Object)options.isUpsert(), (Object)copy.isUpsert());
        Assert.assertEquals((Object)options.getArrayFilters(), (Object)copy.getArrayFilters());
        Assert.assertEquals((Object)options.getHint(), (Object)copy.getHint());
        Assert.assertEquals((Object)options.getHintString(), (Object)copy.getHintString());
    }

    @Test
    public void testToJson() {
        UpdateOptions options = new UpdateOptions();
        WriteOption writeOption = WriteOption.MAJORITY;
        boolean multi = TestUtils.randomBoolean();
        boolean upsert = TestUtils.randomBoolean();
        JsonArray arrayFilters = new JsonArray().add((Object)new JsonObject().put(TestUtils.randomAlphaString((int)5), (Object)TestUtils.randomAlphaString((int)5)));
        JsonObject hint = new JsonObject().put(TestUtils.randomAlphaString((int)5), (Object)TestUtils.randomInt());
        String hintString = TestUtils.randomAlphaString((int)12);
        options.setWriteOption(writeOption);
        options.setMulti(multi);
        options.setUpsert(upsert);
        options.setArrayFilters(arrayFilters);
        options.setHint(hint);
        options.setHintString(hintString);
        Assert.assertEquals((Object)options, (Object)new UpdateOptions(options.toJson()));
    }
}

