/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.TimeSeriesGranularity;
import io.vertx.ext.mongo.TimeSeriesOptions;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class TimeSeriesOptionsTest {
    private static void assertNotEqual(BiConsumer<TimeSeriesOptions, TimeSeriesOptions> f) {
        TimeSeriesOptions a = new TimeSeriesOptions().setTimeField("time");
        TimeSeriesOptions b = new TimeSeriesOptions().setTimeField("time");
        f.accept(a, b);
        Assert.assertNotEquals((Object)a, (Object)b);
    }

    private static void assertNotEqual(int expected, Consumer<TimeSeriesOptions> f) {
        TimeSeriesOptions o = new TimeSeriesOptions().setTimeField("time");
        f.accept(o);
        Assert.assertNotEquals((long)expected, (long)o.hashCode());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new TimeSeriesOptions().setTimeField("time"), (Object)new TimeSeriesOptions().setTimeField("time"));
        TimeSeriesOptionsTest.assertNotEqual((a, b) -> {
            a.setMetaField("metaA");
            b.setMetaField("metaB");
        });
        TimeSeriesOptionsTest.assertNotEqual((a, b) -> {
            a.setMetaField("SECONDS");
            b.setMetaField("HOURS");
        });
        Assert.assertNotEquals((Object)new CollationOptions(), null);
    }

    @Test
    public void testHashCode() {
        TimeSeriesOptions a = new TimeSeriesOptions().setTimeField("timeA");
        int hash = a.hashCode();
        Assert.assertEquals((long)hash, (long)new TimeSeriesOptions().setTimeField("timeA").hashCode());
        TimeSeriesOptionsTest.assertNotEqual(hash, o -> o.setMetaField("metaA"));
        TimeSeriesOptionsTest.assertNotEqual(hash, o -> o.setGranularity(TimeSeriesGranularity.MINUTES));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTimeField() {
        new TimeSeriesOptions().setTimeField(null).toMongoDriverObject();
    }

    @Test
    public void testNullTimeFieldFromJson() {
        Assert.assertEquals((Object)"timestamp", (Object)new TimeSeriesOptions(new JsonObject()).getTimeField());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidGranularityFromJson() {
        new TimeSeriesOptions(JsonObject.of((String)"timeField", (Object)"time", (String)"granularity", (Object)"invalid"));
    }

    @Test
    public void testTimeSeriesOptionsFromJson() {
        TimeSeriesOptions options1 = new TimeSeriesOptions(JsonObject.of((String)"timeField", (Object)"time"));
        TimeSeriesOptions options2 = new TimeSeriesOptions(JsonObject.of((String)"timeField", (Object)"time"));
        Assert.assertEquals((Object)options1, (Object)options2);
        TimeSeriesOptions options3 = new TimeSeriesOptions(JsonObject.of((String)"timeField", (Object)"time", (String)"metaField", (Object)"meta", (String)"granularity", (Object)"HOURS"));
        TimeSeriesOptions options4 = new TimeSeriesOptions(JsonObject.of((String)"timeField", (Object)"time", (String)"metaField", (Object)"meta", (String)"granularity", (Object)"HOURS"));
        Assert.assertEquals((Object)options3, (Object)options4);
        Assert.assertEquals((Object)TimeSeriesGranularity.HOURS, (Object)options3.getGranularity());
        Assert.assertEquals((Object)TimeSeriesGranularity.HOURS, (Object)options4.getGranularity());
        Assert.assertEquals((Object)TimeSeriesGranularity.SECONDS, (Object)options4.setGranularity(TimeSeriesGranularity.SECONDS).getGranularity());
    }
}

