/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.bson.types.ObjectId;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

public abstract class MongoTestBase
extends VertxTestBase {
    private static MongoDBContainer mongoDBContainer;

    protected static String getConnectionString() {
        return MongoTestBase.getProperty("connection_string");
    }

    protected static String getDatabaseName() {
        return MongoTestBase.getProperty("db_name");
    }

    protected static String getProperty(String name) {
        String s = System.getProperty(name);
        if (s != null && (s = s.trim()).length() > 0) {
            return s;
        }
        return null;
    }

    @BeforeClass
    public static void startMongo() {
        int port = 27018;
        mongoDBContainer = new MongoDBContainer(DockerImageName.parse((String)"mongo:5.0.15"));
        mongoDBContainer.setPortBindings(Collections.singletonList(port + ":27017"));
        mongoDBContainer.start();
    }

    @AfterClass
    public static void stopMongo() {
        mongoDBContainer.stop();
    }

    protected static JsonObject getConfig() {
        JsonObject config = new JsonObject();
        String connectionString = MongoTestBase.getConnectionString();
        if (connectionString != null) {
            config.put("connection_string", (Object)connectionString);
        } else {
            config.put("connection_string", (Object)"mongodb://localhost:27018");
        }
        String databaseName = MongoTestBase.getDatabaseName();
        if (databaseName != null) {
            config.put("db_name", (Object)databaseName);
        }
        return config;
    }

    protected void dropCollections(MongoClient mongoClient, CountDownLatch latch) {
        mongoClient.getCollections(this.onSuccess(list -> {
            AtomicInteger collCount = new AtomicInteger();
            List<String> toDrop = this.getOurCollections((List<String>)list);
            int count = toDrop.size();
            if (!toDrop.isEmpty()) {
                for (String collection : toDrop) {
                    mongoClient.dropCollection(collection, this.onSuccess(v -> {
                        if (collCount.incrementAndGet() == count) {
                            latch.countDown();
                        }
                    }));
                }
            } else {
                latch.countDown();
            }
        }));
    }

    protected List<String> getOurCollections(List<String> colls) {
        ArrayList<String> ours = new ArrayList<String>();
        for (String coll : colls) {
            if (!coll.startsWith("ext-mongo")) continue;
            ours.add(coll);
        }
        return ours;
    }

    protected String randomCollection() {
        return "ext-mongo" + TestUtils.randomAlphaString((int)20);
    }

    protected void insertDocs(MongoClient mongoClient, String collection, int num, Handler<AsyncResult<Void>> resultHandler) {
        this.insertDocs(mongoClient, collection, num, this::createDoc, resultHandler);
    }

    protected void insertDocs(MongoClient mongoClient, String collection, int num, Function<Integer, JsonObject> docSupplier, Handler<AsyncResult<Void>> resultHandler) {
        if (num != 0) {
            AtomicInteger cnt = new AtomicInteger();
            for (int i = 0; i < num; ++i) {
                mongoClient.insert(collection, docSupplier.apply(i), ar -> {
                    if (ar.succeeded()) {
                        if (cnt.incrementAndGet() == num) {
                            resultHandler.handle((Object)Future.succeededFuture());
                        }
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            }
        } else {
            resultHandler.handle((Object)Future.succeededFuture());
        }
    }

    protected JsonObject createDoc() {
        return new JsonObject().put("foo", (Object)"bar").put("num", (Object)123).put("big", (Object)true).putNull("nullentry").put("bigDec", (Object)BigDecimal.ONE).put("arr", (Object)new JsonArray().add((Object)"x").add((Object)true).add((Object)12).add((Object)1.23).addNull().add((Object)BigDecimal.ONE).add((Object)new JsonObject().put("wib", (Object)"wob"))).put("date", (Object)new JsonObject().put("$date", (Object)"2015-05-30T22:50:02Z")).put("object_id", (Object)new JsonObject().put("$oid", (Object)new ObjectId().toHexString())).put("other", (Object)new JsonObject().put("quux", (Object)"flib").put("myarr", (Object)new JsonArray().add((Object)"blah").add((Object)true).add((Object)312)));
    }

    protected JsonObject createDoc(int num) {
        return new JsonObject().put("foo", (Object)("bar" + (num != -1 ? Integer.valueOf(num) : ""))).put("num", (Object)123).put("big", (Object)true).putNull("nullentry").put("counter", (Object)num).put("arr", (Object)new JsonArray().add((Object)"x").add((Object)true).add((Object)12).add((Object)1.23).addNull().add((Object)new JsonObject().put("wib", (Object)"wob"))).put("date", (Object)new JsonObject().put("$date", (Object)"2015-05-30T22:50:02Z")).put("object_id", (Object)new JsonObject().put("$oid", (Object)new ObjectId().toHexString())).put("other", (Object)new JsonObject().put("quux", (Object)"flib").put("myarr", (Object)new JsonArray().add((Object)"blah").add((Object)true).add((Object)312))).put("longval", (Object)123456789L).put("dblval", (Object)1.23);
    }

    protected JsonObject createDocWithAmbiguitiesDependingOnLocale(int num) {
        return new JsonObject().put("foo", (Object)(num % 2 == 0 ? "bar" : "b\u00e4r")).put("num", (Object)123).put("big", (Object)true).putNull("nullentry").put("counter", (Object)num).put("arr", (Object)new JsonArray().add((Object)"x").add((Object)true).add((Object)12).add((Object)1.23).addNull().add((Object)new JsonObject().put("wib", (Object)"wob"))).put("date", (Object)new JsonObject().put("$date", (Object)"2015-05-30T22:50:02Z")).put("object_id", (Object)new JsonObject().put("$oid", (Object)new ObjectId().toHexString())).put("other", (Object)new JsonObject().put("quux", (Object)"flib").put("myarr", (Object)new JsonArray().add((Object)"blah").add((Object)true).add((Object)312))).put("longval", (Object)123456789L).put("dblval", (Object)1.23);
    }
}

