/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.test.core.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MongoClientUpdateResultTest {
    @Test
    public void testMongoClientUpdateResultStatuses() {
        long randomMatched = TestUtils.randomLong();
        JsonObject randomUpsertedId = this.randomUpsertId();
        long randomModified = TestUtils.randomLong();
        MongoClientUpdateResult mongoClientUpdateResult = new MongoClientUpdateResult(randomMatched, randomUpsertedId, randomModified);
        Assert.assertEquals((long)randomMatched, (long)mongoClientUpdateResult.getDocMatched());
        Assert.assertEquals((Object)randomUpsertedId, (Object)mongoClientUpdateResult.getDocUpsertedId());
        Assert.assertEquals((long)randomModified, (long)mongoClientUpdateResult.getDocModified());
    }

    @Test
    public void testDefaultMongoClientUpdateResult() {
        MongoClientUpdateResult mongoClientUpdateResult = new MongoClientUpdateResult();
        Assert.assertEquals((long)0L, (long)mongoClientUpdateResult.getDocMatched());
        Assert.assertNull((Object)mongoClientUpdateResult.getDocUpsertedId());
        Assert.assertEquals((long)0L, (long)mongoClientUpdateResult.getDocModified());
    }

    @Test
    public void testCopyMongoClientUpdateResult() {
        MongoClientUpdateResult mongoClientUpdateResultOrigin = new MongoClientUpdateResult(TestUtils.randomLong(), this.randomUpsertId(), TestUtils.randomLong());
        MongoClientUpdateResult mongoClientUpdateResultCopy = new MongoClientUpdateResult(mongoClientUpdateResultOrigin);
        Assert.assertEquals((long)mongoClientUpdateResultOrigin.getDocMatched(), (long)mongoClientUpdateResultCopy.getDocMatched());
        Assert.assertEquals((Object)mongoClientUpdateResultOrigin.getDocUpsertedId(), (Object)mongoClientUpdateResultCopy.getDocUpsertedId());
        Assert.assertEquals((long)mongoClientUpdateResultOrigin.getDocModified(), (long)mongoClientUpdateResultCopy.getDocModified());
    }

    @Test
    public void testJsonMongoClientUpdateResult() {
        this.properJson();
        this.jsonWithoutRequiredFields();
    }

    private void jsonWithoutRequiredFields() {
        JsonObject mongoClientUpdateResultJson = new JsonObject();
        MongoClientUpdateResult mongoClientUpdateResult = new MongoClientUpdateResult(mongoClientUpdateResultJson);
        Assert.assertEquals((long)0L, (long)mongoClientUpdateResult.getDocMatched());
        Assert.assertNull((Object)mongoClientUpdateResult.getDocUpsertedId());
        Assert.assertEquals((long)0L, (long)mongoClientUpdateResult.getDocModified());
    }

    private void properJson() {
        JsonObject mongoClientUpdateResultJson = this.randomMongoClientUpdateResultJson();
        MongoClientUpdateResult mongoClientUpdateResult = new MongoClientUpdateResult(mongoClientUpdateResultJson);
        Assert.assertEquals((long)mongoClientUpdateResultJson.getLong("doc_matched", Long.valueOf(0L)), (long)mongoClientUpdateResult.getDocMatched());
        Assert.assertEquals((Object)mongoClientUpdateResultJson.getJsonObject("upserted_id"), (Object)mongoClientUpdateResult.getDocUpsertedId());
        Assert.assertEquals((long)mongoClientUpdateResultJson.getLong("doc_modified", Long.valueOf(0L)), (long)mongoClientUpdateResult.getDocModified());
    }

    @Test
    public void testToJsonMongoClientUpdateResult() {
        JsonObject mongoClientUpdateResultJson = this.randomMongoClientUpdateResultJson();
        MongoClientUpdateResult mongoClientUpdateResult = new MongoClientUpdateResult(mongoClientUpdateResultJson);
        Assert.assertEquals((Object)mongoClientUpdateResultJson, (Object)mongoClientUpdateResult.toJson());
    }

    @Test
    public void testMongoUpdateResultEquality() {
        this.logicallyUnequal();
        this.logicallyEqual();
    }

    private void logicallyEqual() {
        long randomMatched = TestUtils.randomLong();
        JsonObject randomUpsertedId = this.randomUpsertId();
        long randomModified = TestUtils.randomLong();
        MongoClientUpdateResult mongoClientUpdateResult1 = new MongoClientUpdateResult(randomMatched, randomUpsertedId, randomModified);
        MongoClientUpdateResult mongoClientUpdateResult2 = new MongoClientUpdateResult(randomMatched, randomUpsertedId, randomModified);
        Assert.assertTrue((boolean)mongoClientUpdateResult1.equals((Object)mongoClientUpdateResult2));
        Assert.assertTrue((boolean)mongoClientUpdateResult2.equals((Object)mongoClientUpdateResult1));
    }

    private void logicallyUnequal() {
        MongoClientUpdateResult mongoClientUpdateResult1 = new MongoClientUpdateResult(2333333L, this.randomUpsertId(), 66554545L);
        MongoClientUpdateResult mongoClientUpdateResult2 = new MongoClientUpdateResult(52325L, this.randomUpsertId(), 6021323L);
        Assert.assertFalse((boolean)mongoClientUpdateResult1.equals((Object)mongoClientUpdateResult2));
        Assert.assertFalse((boolean)mongoClientUpdateResult2.equals((Object)mongoClientUpdateResult1));
    }

    private JsonObject randomMongoClientUpdateResultJson() {
        JsonObject mongoClientUpdateResultJson = new JsonObject();
        mongoClientUpdateResultJson.put("doc_matched", (Object)TestUtils.randomLong());
        mongoClientUpdateResultJson.put("upserted_id", (Object)this.randomUpsertId());
        mongoClientUpdateResultJson.put("doc_modified", (Object)TestUtils.randomLong());
        return mongoClientUpdateResultJson;
    }

    private JsonObject randomUpsertId() {
        return new JsonObject().put("_id", (Object)TestUtils.randomAlphaString((int)23));
    }
}

