/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.CollationStrength;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoTestBase;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.test.core.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.junit.Test;

public abstract class MongoClientTestBase
extends MongoTestBase {
    protected MongoClient mongoClient;
    protected boolean useObjectId;

    @Test
    public void testCreateAndGetCollection() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.mongoClient.getCollections(this.onSuccess(list -> {
            List<String> ours = this.getOurCollections((List<String>)list);
            this.assertEquals(1L, ours.size());
            this.assertEquals(collection, ours.get(0));
            String collection2 = this.randomCollection();
            this.mongoClient.createCollection(collection2, this.onSuccess(res2 -> this.mongoClient.getCollections(this.onSuccess(list2 -> {
                List<String> ours2 = this.getOurCollections((List<String>)list2);
                this.assertEquals(2L, ours2.size());
                this.assertTrue(ours2.contains(collection));
                this.assertTrue(ours2.contains(collection2));
                this.testComplete();
            }))));
        }))));
        this.await();
    }

    @Test
    public void testCreateCollectionAlreadyExists() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.mongoClient.createCollection(collection, this.onFailure(ex -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testDropCollection() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.mongoClient.dropCollection(collection, this.onSuccess(res2 -> this.mongoClient.getCollections(this.onSuccess(list -> {
            List<String> ours = this.getOurCollections((List<String>)list);
            this.assertTrue(ours.isEmpty());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testCreateIndexes() {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            ArrayList<IndexModel> indexes = new ArrayList<IndexModel>();
            JsonObject key = new JsonObject().put("field", (Object)1);
            IndexModel index = new IndexModel().setKey(key);
            indexes.add(index);
            JsonObject key2 = new JsonObject().put("field1", (Object)1);
            IndexModel index2 = new IndexModel().setKey(key2);
            indexes.add(index2);
            this.mongoClient.createIndexes(collection, indexes, this.onSuccess(res2 -> this.mongoClient.listIndexes(collection, this.onSuccess(res3 -> {
                long cnt = res3.stream().filter(o -> ((JsonObject)o).getJsonObject("key").containsKey("field") || ((JsonObject)o).getJsonObject("key").containsKey("field1")).count();
                this.assertEquals(2L, cnt);
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testCreateIndex() {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject key = new JsonObject().put("field", (Object)1);
            this.mongoClient.createIndex(collection, key, this.onSuccess(res2 -> this.mongoClient.listIndexes(collection, this.onSuccess(res3 -> {
                long cnt = res3.stream().filter(o -> ((JsonObject)o).getJsonObject("key").containsKey("field")).count();
                this.assertEquals(1L, cnt);
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testCreateIndexWithCollation() {
        this.testCreateIndexWithCollation(new CollationOptions().setLocale(Locale.ENGLISH.toString()), 1);
    }

    @Test
    public void testCreateIndexWithSimpleLocaleCollation() {
        this.testCreateIndexWithCollation(new CollationOptions().setLocale("simple"), 0);
    }

    private void testCreateIndexWithCollation(CollationOptions collation, int expectedCollation) {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject key = new JsonObject().put("field", (Object)1);
            IndexOptions options = new IndexOptions().setCollation(collation);
            this.mongoClient.createIndexWithOptions(collection, key, options, this.onSuccess(res2 -> this.mongoClient.listIndexes(collection, this.onSuccess(res3 -> {
                long keyCount = res3.stream().filter(o -> ((JsonObject)o).getJsonObject("key").containsKey("field")).count();
                this.assertEquals(1L, keyCount);
                long collationCount = res3.stream().filter(o -> ((JsonObject)o).containsKey("collation")).count();
                this.assertEquals(expectedCollation, collationCount);
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testCreateAndDropIndex() {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject key = new JsonObject().put("field", (Object)1);
            this.mongoClient.createIndex(collection, key, this.onSuccess(res2 -> this.mongoClient.dropIndex(collection, "field_1", this.onSuccess(res3 -> this.mongoClient.listIndexes(collection, this.onSuccess(res4 -> {
                long cnt = res4.stream().filter(o -> ((JsonObject)o).getJsonObject("key").containsKey("field")).count();
                this.assertEquals(cnt, 0L);
                this.testComplete();
            }))))));
        }));
        this.await();
    }

    @Test
    public void testRunCommand() throws Exception {
        JsonObject command = new JsonObject().put("isMaster", (Object)1);
        this.mongoClient.runCommand("isMaster", command, this.onSuccess(reply -> {
            this.assertTrue(reply.getBoolean("ismaster"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testRunCommandWithBody() throws Exception {
        JsonObject command = new JsonObject().put("aggregate", (Object)"collection_name").put("pipeline", (Object)new JsonArray()).put("cursor", (Object)new JsonObject());
        this.mongoClient.runCommand("aggregate", command, this.onSuccess(resultObj -> {
            JsonArray resArr = resultObj.getJsonObject("cursor").getJsonArray("firstBatch");
            this.assertNotNull(resArr);
            this.assertEquals(0L, resArr.size());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testRunInvalidCommand() throws Exception {
        JsonObject command = new JsonObject().put("iuhioqwdqhwd", (Object)1);
        this.mongoClient.runCommand("iuhioqwdqhwd", command, this.onFailure(ex -> this.testComplete()));
        this.await();
    }

    @Test
    public void testInsertNoCollection() {
        String collection = this.randomCollection();
        String random = TestUtils.randomAlphaString((int)20);
        this.mongoClient.insert(collection, new JsonObject().put("foo", (Object)random), this.onSuccess(id -> {
            this.assertNotNull(id);
            this.mongoClient.find(collection, new JsonObject(), this.onSuccess(docs -> {
                this.assertNotNull(docs);
                this.assertEquals(1L, docs.size());
                this.assertEquals(random, ((JsonObject)docs.get(0)).getString("foo"));
                this.testComplete();
            }));
        }));
        this.await();
    }

    public void assertDocumentWithIdIsPresent(String collection, Object id) {
        this.mongoClient.find(collection, new JsonObject().put("_id", id), this.onSuccess(result -> {
            this.assertEquals(1L, result.size());
            this.testComplete();
        }));
    }

    @Test
    public void testInsertNoPreexistingID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testInsertPreexistingID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            String genID = TestUtils.randomAlphaString((int)100);
            doc.put("_id", (Object)genID);
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> this.assertDocumentWithIdIsPresent(collection, genID)));
        }));
        this.await();
    }

    @Test
    public void testInsertPreexistingLongID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            Long genID = TestUtils.randomLong();
            doc.put("_id", (Object)genID);
            this.mongoClient.insertWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> this.assertDocumentWithIdIsPresent(collection, genID)));
        }));
        this.await();
    }

    @Test
    public void testSaveWithOptionCanTakeNullWriteOption() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            Long genID = TestUtils.randomLong();
            doc.put("_id", (Object)genID);
            this.mongoClient.saveWithOptions(collection, doc, null, this.onSuccess(id -> this.assertDocumentWithIdIsPresent(collection, genID)));
        }));
        this.await();
    }

    @Test
    public void testSavePreexistingLongID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            Long genID = TestUtils.randomLong();
            doc.put("_id", (Object)genID);
            this.mongoClient.saveWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> this.assertDocumentWithIdIsPresent(collection, genID)));
        }));
        this.await();
    }

    @Test
    public void testInsertPreexistingObjectID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            JsonObject genID = new JsonObject().put("id", (Object)TestUtils.randomAlphaString((int)100));
            doc.put("_id", (Object)genID);
            this.mongoClient.insertWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> this.assertDocumentWithIdIsPresent(collection, genID)));
        }));
        this.await();
    }

    @Test
    public void testInsertDoesntAlterObject() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            LinkedHashMap<String, Cloneable> map = new LinkedHashMap<String, Cloneable>();
            map.put("nestedMap", new HashMap());
            map.put("nestedList", new ArrayList());
            JsonObject doc = new JsonObject(map);
            this.mongoClient.insertWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.assertTrue(map.get("nestedMap") instanceof HashMap);
                this.assertTrue(map.get("nestedList") instanceof ArrayList);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testSavePreexistingObjectID() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            JsonObject genID = new JsonObject().put("id", (Object)TestUtils.randomAlphaString((int)100));
            doc.put("_id", (Object)genID);
            this.mongoClient.saveWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> {
                this.assertNull(id);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testInsertAlreadyExists() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                doc.put("_id", id);
                this.mongoClient.insert(collection, doc, this.onFailure(t -> this.testComplete()));
            }));
        }));
        this.await();
    }

    @Test
    public void testInsertWithOptionsCanTakeNullWriteOption() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insertWithOptions(collection, doc, null, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testInsertWithOptions() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insertWithOptions(collection, doc, WriteOption.UNACKNOWLEDGED, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testInsertWithNestedListMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> nestedMap = new HashMap<String, String>();
        nestedMap.put("foo", "bar");
        map.put("nestedMap", nestedMap);
        map.put("nestedList", Arrays.asList(1, 2, 3));
        String collection = this.randomCollection();
        JsonObject doc = new JsonObject(map);
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            this.mongoClient.findOne(collection, new JsonObject().put("_id", id), null, this.onSuccess(result -> {
                this.assertNotNull(result);
                this.assertNotNull(result.getJsonObject("nestedMap"));
                this.assertEquals("bar", result.getJsonObject("nestedMap").getString("foo"));
                this.assertNotNull(result.getJsonArray("nestedList"));
                this.assertEquals(1L, result.getJsonArray("nestedList").getInteger(0).intValue());
                this.assertEquals(2L, result.getJsonArray("nestedList").getInteger(1).intValue());
                this.assertEquals(3L, result.getJsonArray("nestedList").getInteger(2).intValue());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testInsertRetrieve() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            String genID = TestUtils.randomAlphaString((int)100);
            doc.put("_id", (Object)genID);
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNull(id);
                this.mongoClient.findOne(collection, new JsonObject(), null, this.onSuccess(retrieved -> {
                    this.assertEquals(doc, retrieved);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testSave() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.save(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                doc.put("_id", id);
                doc.put("newField", (Object)"sheep");
                this.mongoClient.save(collection, doc, this.onSuccess(id2 -> {
                    this.assertNull(id2);
                    this.mongoClient.findOne(collection, new JsonObject(), null, this.onSuccess(res2 -> {
                        this.assertEquals("sheep", res2.getString("newField"));
                        this.testComplete();
                    }));
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testSaveWithNestedListMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> nestedMap = new HashMap<String, String>();
        nestedMap.put("foo", "bar");
        map.put("nestedMap", nestedMap);
        map.put("nestedList", Arrays.asList(1, 2, 3));
        String collection = this.randomCollection();
        JsonObject doc = new JsonObject(map);
        this.mongoClient.save(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            this.mongoClient.findOne(collection, new JsonObject().put("_id", id), null, this.onSuccess(result -> {
                this.assertNotNull(result);
                this.assertNotNull(result.getJsonObject("nestedMap"));
                this.assertEquals("bar", result.getJsonObject("nestedMap").getString("foo"));
                this.assertNotNull(result.getJsonArray("nestedList"));
                this.assertEquals(1L, result.getJsonArray("nestedList").getInteger(0).intValue());
                this.assertEquals(2L, result.getJsonArray("nestedList").getInteger(1).intValue());
                this.assertEquals(3L, result.getJsonArray("nestedList").getInteger(2).intValue());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testSaveAndReadBinary() throws Exception {
        String collection = this.randomCollection();
        Instant now = Instant.now();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(now);
        oos.close();
        JsonObject doc = new JsonObject();
        doc.put("now", (Object)new JsonObject().put("$binary", (Object)baos.toByteArray()));
        this.mongoClient.save(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            this.mongoClient.findOne(collection, new JsonObject().put("_id", id), null, this.onSuccess(result -> {
                this.assertNotNull(result);
                this.assertNotNull(result.getJsonObject("now"));
                this.assertNotNull(result.getJsonObject("now").getBinary("$binary"));
                ByteArrayInputStream bais = new ByteArrayInputStream(result.getJsonObject("now").getBinary("$binary"));
                ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream(bais);
                    Instant reconstitutedNow = (Instant)ois.readObject();
                    this.assertEquals(now, reconstitutedNow);
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                    this.assertTrue(false);
                }
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testSaveAndReadObjectId() throws Exception {
        String collection = this.randomCollection();
        ObjectId objectId = new ObjectId();
        JsonObject doc = new JsonObject();
        doc.put("otherId", (Object)new JsonObject().put("$oid", (Object)objectId.toHexString()));
        this.mongoClient.save(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            this.mongoClient.findOne(collection, new JsonObject().put("_id", id), null, this.onSuccess(result -> {
                this.assertNotNull(result);
                this.assertNotNull(result.getJsonObject("otherId").getString("$oid"));
                this.assertEquals(objectId.toHexString(), result.getJsonObject("otherId").getString("$oid"));
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testSaveWithOptions() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.saveWithOptions(collection, doc, WriteOption.ACKNOWLEDGED, this.onSuccess(id -> {
                this.assertNotNull(id);
                doc.put("_id", id);
                doc.put("newField", (Object)"sheep");
                this.mongoClient.save(collection, doc, this.onSuccess(id2 -> {
                    this.assertNull(id2);
                    this.mongoClient.findOne(collection, new JsonObject(), null, this.onSuccess(res2 -> {
                        this.assertEquals("sheep", res2.getString("newField"));
                        this.testComplete();
                    }));
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneAndUpdateDefault() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOneAndUpdate(collection, new JsonObject().put("num", (Object)123), new JsonObject().put("$inc", (Object)new JsonObject().put("num", (Object)7)), this.onSuccess(obj -> {
                    this.assertEquals(123L, obj.getLong("num", Long.valueOf(-1L)));
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneAndUpdateNoRecord() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOneAndUpdate(collection, new JsonObject().put("num", (Object)0), new JsonObject().put("$inc", (Object)new JsonObject().put("num", (Object)7)), this.onSuccess(obj -> {
                    this.assertNull(obj);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneAndUpdateWithOptions() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOneAndUpdateWithOptions(collection, new JsonObject().put("num", (Object)123), new JsonObject().put("$inc", (Object)new JsonObject().put("num", (Object)7)), new FindOptions().setFields(new JsonObject().put("num", (Object)1)), new UpdateOptions().setReturningNewDocument(true), this.onSuccess(obj -> {
                    this.assertEquals(130L, obj.getLong("num", Long.valueOf(-1L)));
                    this.assertFalse(obj.containsKey("foo"));
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneAndReplaceDefault() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                doc.remove("_id");
                this.mongoClient.findOneAndReplace(collection, new JsonObject().put("num", (Object)123), doc.put("num", (Object)130), this.onSuccess(obj -> {
                    this.assertEquals(123L, obj.getLong("num", Long.valueOf(-1L)));
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneAndReplaceWithOptions() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                doc.remove("_id");
                this.mongoClient.findOneAndReplaceWithOptions(collection, new JsonObject().put("num", (Object)123), doc.put("num", (Object)130), new FindOptions().setFields(new JsonObject().put("num", (Object)1)), new UpdateOptions().setReturningNewDocument(true), this.onSuccess(obj -> {
                    this.assertEquals(130L, obj.getLong("num", Long.valueOf(-1L)));
                    this.assertFalse(obj.containsKey("foo"));
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneAndDeleteDefault() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOneAndDelete(collection, new JsonObject().put("num", (Object)123), this.onSuccess(obj -> {
                    this.assertEquals(123L, obj.getLong("num", Long.valueOf(-1L)));
                    this.mongoClient.count(collection, new JsonObject(), this.onSuccess(count -> {
                        this.assertNotNull(count);
                        this.assertEquals(0L, count.intValue());
                        this.testComplete();
                    }));
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneWithOptionsAndCollation() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc1 = this.createDoc();
            JsonObject doc2 = this.createDoc().put("foo", (Object)"b\u00e4r");
            this.mongoClient.insert(collection, doc1, this.onSuccess(id1 -> {
                this.assertNotNull(id1);
                this.mongoClient.insert(collection, doc2, this.onSuccess(id2 -> {
                    this.assertNotNull(id2);
                    this.mongoClient.countWithOptions(collection, new JsonObject().put("foo", (Object)"bar"), new CountOptions().setCollation(new CollationOptions().setLocale("de_AT").setStrength(CollationStrength.TERTIARY)), this.onSuccess(count -> {
                        this.assertNotNull(count);
                        this.assertEquals(1L, count.intValue());
                        this.testComplete();
                    }));
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneAndDeleteWithOptions() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOneAndDeleteWithOptions(collection, new JsonObject().put("num", (Object)123), new FindOptions().setFields(new JsonObject().put("num", (Object)1)), this.onSuccess(obj -> {
                    this.assertEquals(123L, obj.getLong("num", Long.valueOf(-1L)));
                    this.assertFalse(obj.containsKey("foo"));
                    this.mongoClient.count(collection, new JsonObject(), this.onSuccess(count -> {
                        this.assertNotNull(count);
                        this.assertEquals(0L, count.intValue());
                        this.testComplete();
                    }));
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testCountNoCollection() {
        String collection = this.randomCollection();
        this.mongoClient.count(collection, new JsonObject(), this.onSuccess(count -> {
            this.assertEquals(0L, (long)count);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCount() throws Exception {
        int num = 10;
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, num, (Handler<AsyncResult<Void>>)this.onSuccess(res -> this.mongoClient.count(collection, new JsonObject(), this.onSuccess(count -> {
            this.assertNotNull(count);
            this.assertEquals(num, count.intValue());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testCountWithQuery() throws Exception {
        int num = 10;
        String collection = this.randomCollection();
        CountDownLatch latch = new CountDownLatch(num);
        for (int i = 0; i < num; ++i) {
            JsonObject doc = this.createDoc();
            if (i % 2 == 0) {
                doc.put("flag", (Object)true);
            }
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                latch.countDown();
            }));
        }
        this.awaitLatch(latch);
        JsonObject query = new JsonObject().put("flag", (Object)true);
        this.mongoClient.count(collection, query, this.onSuccess(count -> {
            this.assertNotNull(count);
            this.assertEquals(num / 2, count.intValue());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFindOne() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject orig = this.createDoc();
            JsonObject doc = orig.copy();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOne(collection, new JsonObject().put("foo", (Object)"bar"), null, this.onSuccess(obj -> {
                    this.assertTrue(obj.containsKey("_id"));
                    obj.remove("_id");
                    this.assertEquals(orig, obj);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneWithKeys() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = this.createDoc();
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                this.assertNotNull(id);
                this.mongoClient.findOne(collection, new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("num", (Object)true), this.onSuccess(obj -> {
                    this.assertEquals(2L, obj.size());
                    this.assertEquals(123L, obj.getInteger("num").intValue());
                    this.assertTrue(obj.containsKey("_id"));
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testFindOneNotFound() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.mongoClient.findOne(collection, new JsonObject().put("foo", (Object)"bar"), null, this.onSuccess(obj -> {
            this.assertNull(obj);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testFind() throws Exception {
        int num = 10;
        this.doTestFind(num, new JsonObject(), new FindOptions(), results -> {
            this.assertEquals(num, results.size());
            for (JsonObject doc : results) {
                this.assertEquals(12L, doc.size());
            }
        });
    }

    @Test
    public void testFindWithId() throws Exception {
        int num = 10;
        this.doTestFind(num, new JsonObject(), new FindOptions().setFields(new JsonObject().put("_id", (Object)1)), results -> {
            this.assertEquals(num, results.size());
            for (JsonObject doc : results) {
                this.assertEquals(1L, doc.size());
                this.assertTrue(doc.getValue("_id", null) instanceof String);
            }
        });
    }

    @Test
    public void testFindWithFields() throws Exception {
        int num = 10;
        this.doTestFind(num, new JsonObject(), new FindOptions().setFields(new JsonObject().put("num", (Object)true)), results -> {
            this.assertEquals(num, results.size());
            for (JsonObject doc : results) {
                this.assertEquals(2L, doc.size());
            }
        });
    }

    @Test
    public void testFindWithSort() throws Exception {
        int num = 11;
        this.doTestFind(num, new JsonObject(), new FindOptions().setSort(new JsonObject().put("foo", (Object)1)), results -> {
            this.assertEquals(num, results.size());
            this.assertEquals("bar0", ((JsonObject)results.get(0)).getString("foo"));
            this.assertEquals("bar1", ((JsonObject)results.get(1)).getString("foo"));
            this.assertEquals("bar10", ((JsonObject)results.get(2)).getString("foo"));
        });
    }

    @Test
    public void testFindWithLimit() throws Exception {
        int num = 10;
        int limit = 3;
        this.doTestFind(num, new JsonObject(), new FindOptions().setLimit(limit), results -> this.assertEquals(limit, results.size()));
    }

    @Test
    public void testFindWithLimitLarger() throws Exception {
        int num = 10;
        int limit = 20;
        this.doTestFind(num, new JsonObject(), new FindOptions().setLimit(limit), results -> this.assertEquals(num, results.size()));
    }

    @Test
    public void testFindWithSkip() throws Exception {
        int num = 10;
        int skip = 3;
        this.doTestFind(num, new JsonObject(), new FindOptions().setSkip(skip), results -> this.assertEquals(num - skip, results.size()));
    }

    @Test
    public void testFindWithSkipLarger() throws Exception {
        int num = 10;
        int skip = 20;
        this.doTestFind(num, new JsonObject(), new FindOptions().setSkip(skip), results -> this.assertEquals(0L, results.size()));
    }

    private void doTestFind(int numDocs, JsonObject query, FindOptions options, Consumer<List<JsonObject>> resultConsumer) throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.insertDocs(this.mongoClient, collection, numDocs, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.findWithOptions(collection, query, options, this.onSuccess(res3 -> {
            resultConsumer.accept((List<JsonObject>)res3);
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testReplace() {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocuments(collection, new JsonObject().put("_id", id), replacement, this.onSuccess(v -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(list -> {
                this.assertNotNull(list);
                this.assertEquals(1L, list.size());
                JsonObject result = (JsonObject)list.get(0);
                Object id_value = result.getValue("_id");
                if (id_value instanceof JsonObject) {
                    this.assertEquals(id, ((JsonObject)id_value).getString("$oid"));
                } else {
                    this.assertEquals(id, id_value);
                }
                result.remove("_id");
                replacement.remove("_id");
                this.assertEquals(replacement, result);
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testReplaceWithMongoClientUpddateResult() {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocuments(collection, new JsonObject().put("_id", id), replacement, this.onSuccess(v -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(list -> {
                this.assertNull(v.getDocUpsertedId());
                this.assertEquals(1L, v.getDocMatched());
                this.assertEquals(1L, v.getDocModified());
                this.assertNotNull(list);
                this.assertEquals(1L, list.size());
                JsonObject result = (JsonObject)list.get(0);
                Object id_value = result.getValue("_id");
                if (id_value instanceof JsonObject) {
                    this.assertEquals(id, ((JsonObject)id_value).getString("$oid"));
                } else {
                    this.assertEquals(id, id_value);
                }
                result.remove("_id");
                replacement.remove("_id");
                this.assertEquals(replacement, result);
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testReplaceMongoClientUpdateResultUnacknowledge() throws Exception {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocumentsWithOptions(collection, new JsonObject().put("_id", id), replacement, new UpdateOptions().setWriteOption(WriteOption.UNACKNOWLEDGED), this.onSuccess(v -> {
                this.assertNull(v);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testReplaceMongoClientUpdateResultAcknowledge() throws Exception {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocumentsWithOptions(collection, new JsonObject().put("_id", id), replacement, new UpdateOptions().setWriteOption(WriteOption.ACKNOWLEDGED), this.onSuccess(v -> {
                this.assertNull(v.getDocUpsertedId());
                this.assertEquals(1L, v.getDocMatched());
                this.assertEquals(1L, v.getDocModified());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testReplaceUpsert() {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocumentsWithOptions(collection, new JsonObject().put("_id", (Object)"foo"), replacement, new UpdateOptions(true), this.onSuccess(v -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(list -> {
                this.assertNotNull(list);
                this.assertEquals(2L, list.size());
                JsonObject result = null;
                for (JsonObject o : list) {
                    if (!o.containsKey("replacement")) continue;
                    result = o;
                }
                this.assertNotNull(result);
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testReplaceUpsertWithMongoClientUpdateResult() {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        String upsertTestId = "foo";
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocumentsWithOptions(collection, new JsonObject().put("_id", (Object)upsertTestId), replacement, new UpdateOptions(true), this.onSuccess(v -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(list -> {
                this.assertEquals(upsertTestId, v.getDocUpsertedId().getString("_id"));
                this.assertEquals(0L, v.getDocMatched());
                this.assertEquals(0L, v.getDocModified());
                this.assertNotNull(list);
                this.assertEquals(2L, list.size());
                JsonObject result = null;
                for (JsonObject o : list) {
                    if (!o.containsKey("replacement")) continue;
                    result = o;
                }
                this.assertNotNull(result);
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testReplaceUpsert2() {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocumentsWithOptions(collection, new JsonObject().put("_id", id), replacement, new UpdateOptions(true), this.onSuccess(v -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(list -> {
                this.assertNotNull(list);
                this.assertEquals(1L, list.size());
                Object id_value = ((JsonObject)list.get(0)).getValue("_id");
                if (id_value instanceof JsonObject) {
                    this.assertEquals(id, ((JsonObject)id_value).getString("$oid"));
                } else {
                    this.assertEquals(id, id_value);
                }
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testReplaceUpsertWithNoNewIdWithMongoClientUpdateResult() {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            this.assertNotNull(id);
            JsonObject replacement = this.createDoc();
            replacement.put("replacement", (Object)true);
            this.mongoClient.replaceDocumentsWithOptions(collection, new JsonObject().put("_id", id), replacement, new UpdateOptions(true), this.onSuccess(v -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(list -> {
                this.assertNull(v.getDocUpsertedId());
                this.assertEquals(1L, v.getDocMatched());
                this.assertEquals(1L, v.getDocModified());
                this.assertNotNull(list);
                this.assertEquals(1L, list.size());
                Object id_value = ((JsonObject)list.get(0)).getValue("_id");
                if (id_value instanceof JsonObject) {
                    this.assertEquals(id, ((JsonObject)id_value).getString("$oid"));
                } else {
                    this.assertEquals(id, id_value);
                }
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testUpdate() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.insert(collection, this.createDoc(), this.onSuccess(id -> {
            if (this.useObjectId) {
                JsonObject docIdToBeUpdatedObjectId = new JsonObject().put("$oid", id);
                this.updateDataBasedOnId(collection, docIdToBeUpdatedObjectId);
            } else {
                String docIdToBeUpdatedString = id;
                this.updateDataBasedOnId(collection, docIdToBeUpdatedString);
            }
        }));
        this.await();
    }

    private <T> void updateDataBasedOnId(String collection, T docIdToBeUpdated) {
        this.mongoClient.updateCollection(collection, new JsonObject().put("_id", docIdToBeUpdated), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), this.onSuccess(res -> this.mongoClient.findOne(collection, new JsonObject().put("_id", docIdToBeUpdated), null, this.onSuccess(doc -> {
            this.assertEquals("fooed", doc.getString("foo"));
            this.testComplete();
        }))));
    }

    @Test
    public void testUpdateWithMongoClientUpdateResult() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.insert(collection, this.createDoc(), this.onSuccess(id -> {
            if (this.useObjectId) {
                JsonObject docIdToBeUpdatedObjectId = new JsonObject().put("$oid", id);
                this.updateDataBasedOnIdWithMongoClientUpdateResult(collection, docIdToBeUpdatedObjectId);
            } else {
                String docIdToBeUpdatedString = id;
                this.updateDataBasedOnIdWithMongoClientUpdateResult(collection, docIdToBeUpdatedString);
            }
        }));
        this.await();
    }

    private <T> void updateDataBasedOnIdWithMongoClientUpdateResult(String collection, T id) {
        this.mongoClient.updateCollection(collection, new JsonObject().put("_id", id), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), this.onSuccess(res -> {
            this.assertEquals(1L, res.getDocModified());
            this.assertEquals(1L, res.getDocMatched());
            this.assertNull(res.getDocUpsertedId());
            this.mongoClient.findOne(collection, new JsonObject().put("_id", id), null, this.onSuccess(doc -> {
                this.assertEquals("fooed", doc.getString("foo"));
                this.testComplete();
            }));
        }));
    }

    @Test
    public void testUpdateOne() throws Exception {
        int num = 1;
        this.doTestUpdate(num, new JsonObject().put("num", (Object)123), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), new UpdateOptions(), results -> {
            this.assertEquals(num, results.size());
            for (JsonObject doc : results) {
                this.assertEquals(12L, doc.size());
                this.assertEquals("fooed", doc.getString("foo"));
                this.assertNotNull(doc.getValue("_id"));
            }
        });
    }

    @Test
    public void testUpdateOneWithMongoClientUpdateResult() throws Exception {
        int num = 1;
        this.doTestUpdateWithMongoClientUpdateResult(num, new JsonObject().put("num", (Object)123), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), new UpdateOptions(), results -> {
            this.assertEquals(num, results.size());
            for (JsonObject doc : results) {
                this.assertEquals(12L, doc.size());
                this.assertEquals("fooed", doc.getString("foo"));
                this.assertNotNull(doc.getValue("_id"));
            }
        });
    }

    @Test
    public void testUpdateAll() throws Exception {
        int num = 10;
        this.doTestUpdate(num, new JsonObject().put("num", (Object)123), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), new UpdateOptions(false, true), results -> {
            this.assertEquals(num, results.size());
            for (JsonObject doc : results) {
                this.assertEquals(12L, doc.size());
                this.assertEquals("fooed", doc.getString("foo"));
                this.assertNotNull(doc.getValue("_id"));
            }
        });
    }

    @Test
    public void testUpdateAllWithMongoClientUpdateResult() throws Exception {
        int num = 10;
        this.doTestUpdateWithMongoClientUpdateResult(num, new JsonObject().put("num", (Object)123), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), new UpdateOptions(false, true), results -> {
            this.assertEquals(num, results.size());
            for (JsonObject doc : results) {
                this.assertEquals(12L, doc.size());
                this.assertEquals("fooed", doc.getString("foo"));
                this.assertNotNull(doc.getValue("_id"));
            }
        });
    }

    @Test
    public void testUpdateMongoClientUpdateResultUpsertIdResponse() throws Exception {
        String collection = this.randomCollection();
        String upsertedId = TestUtils.randomAlphaString((int)20);
        this.mongoClient.insert(collection, this.createDoc(), this.onSuccess(id -> this.mongoClient.updateCollectionWithOptions(collection, new JsonObject().put("_id", (Object)upsertedId), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), new UpdateOptions().setUpsert(true), this.onSuccess(res -> {
            this.assertEquals(0L, res.getDocModified());
            this.assertEquals(0L, res.getDocMatched());
            this.assertEquals(upsertedId, res.getDocUpsertedId().getString("_id"));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testMongoClientUpdateResultAcknowledge() throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.insert(collection, this.createDoc(), this.onSuccess(id -> {
            if (this.useObjectId) {
                JsonObject docIdToBeUpdatedObjectId = new JsonObject().put("$oid", id);
                this.updateWithOptionWithMongoClientUpdateResultBasedOnIdAcknowledged(collection, docIdToBeUpdatedObjectId);
            } else {
                String docIdToBeUpdatedString = id;
                this.updateWithOptionWithMongoClientUpdateResultBasedOnIdAcknowledged(collection, docIdToBeUpdatedString);
            }
        }));
        this.await();
    }

    private <T> void updateWithOptionWithMongoClientUpdateResultBasedOnIdAcknowledged(String collection, T id) {
        this.mongoClient.updateCollectionWithOptions(collection, new JsonObject().put("_id", id), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), new UpdateOptions().setWriteOption(WriteOption.ACKNOWLEDGED), this.onSuccess(res -> {
            this.assertEquals(1L, res.getDocModified());
            this.assertEquals(1L, res.getDocMatched());
            this.assertNull(res.getDocUpsertedId());
            this.testComplete();
        }));
    }

    @Test
    public void testMongoClientUpdateResultUnacknowledge() throws Exception {
        String collection = this.randomCollection();
        String upsertedId = TestUtils.randomAlphaString((int)20);
        this.mongoClient.insert(collection, this.createDoc(), this.onSuccess(id -> this.mongoClient.updateCollectionWithOptions(collection, new JsonObject().put("_id", (Object)upsertedId), new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"fooed")), new UpdateOptions().setWriteOption(WriteOption.UNACKNOWLEDGED), this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }))));
        this.await();
    }

    private void doTestUpdate(int numDocs, JsonObject query, JsonObject update, UpdateOptions options, Consumer<List<JsonObject>> resultConsumer) throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.insertDocs(this.mongoClient, collection, numDocs, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.updateCollectionWithOptions(collection, query, update, options, this.onSuccess(res3 -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(res4 -> {
            resultConsumer.accept((List<JsonObject>)res4);
            this.testComplete();
        }))))))));
        this.await();
    }

    private void doTestUpdateWithMongoClientUpdateResult(int numDocs, JsonObject query, JsonObject update, UpdateOptions options, Consumer<List<JsonObject>> resultConsumer) throws Exception {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> this.insertDocs(this.mongoClient, collection, numDocs, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.updateCollectionWithOptions(collection, query, update, options, this.onSuccess(res3 -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(res4 -> {
            resultConsumer.accept((List<JsonObject>)res4);
            this.testComplete();
        }))))))));
        this.await();
    }

    @Test
    public void testRemoveOne() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 6, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.removeDocument(collection, new JsonObject().put("num", (Object)123), this.onSuccess(res3 -> this.mongoClient.count(collection, new JsonObject(), this.onSuccess(count -> {
            this.assertEquals(5L, (long)count);
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testRemoveOneWithMongoClientDeleteResult() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 6, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.removeDocument(collection, new JsonObject().put("num", (Object)123), this.onSuccess(res3 -> this.mongoClient.count(collection, new JsonObject(), this.onSuccess(count -> {
            this.assertEquals(1L, res3.getRemovedCount());
            this.assertEquals(5L, (long)count);
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testRemoveOneWithOptions() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 6, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.removeDocumentWithOptions(collection, new JsonObject().put("num", (Object)123), WriteOption.UNACKNOWLEDGED, this.onSuccess(res3 -> this.mongoClient.count(collection, new JsonObject(), this.onSuccess(count -> {
            this.assertNull(res3);
            this.assertEquals(5L, (long)count);
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testRemoveDocumentWithOptionsCanHaveNullWriteOption() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 6, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.removeDocumentWithOptions(collection, new JsonObject().put("num", (Object)123), null, this.onSuccess(res3 -> {
            this.assertEquals(1L, res3.getRemovedCount());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testRemoveOneWithOptionsWithMongoClientDeleteResultAcknowledged() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 6, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.removeDocumentWithOptions(collection, new JsonObject().put("num", (Object)123), WriteOption.ACKNOWLEDGED, this.onSuccess(res3 -> {
            this.assertEquals(1L, res3.getRemovedCount());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testRemoveOneWithOptionsWithMongoClientDeleteResultUnacknowledged() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 6, (Handler<AsyncResult<Void>>)this.onSuccess(res2 -> this.mongoClient.removeDocumentWithOptions(collection, new JsonObject().put("num", (Object)123), WriteOption.UNACKNOWLEDGED, this.onSuccess(res3 -> {
            this.assertNull(res3);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testRemoveMultiple() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(v -> this.mongoClient.removeDocuments(collection, new JsonObject(), this.onSuccess(v2 -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(res2 -> {
            this.assertTrue(res2.isEmpty());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testRemoveMultipleWithMongoClientDeleteResult() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(v -> this.mongoClient.removeDocuments(collection, new JsonObject(), this.onSuccess(v2 -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(res2 -> {
            this.assertEquals(10L, v2.getRemovedCount());
            this.assertTrue(res2.isEmpty());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testRemoveWithOptions() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(v -> this.mongoClient.removeDocumentsWithOptions(collection, new JsonObject(), WriteOption.ACKNOWLEDGED, this.onSuccess(v2 -> this.mongoClient.find(collection, new JsonObject(), this.onSuccess(res2 -> {
            this.assertTrue(res2.isEmpty());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testRemoveDocumentsWithOptionsCanHaveNullWriteOption() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(v -> this.mongoClient.removeDocumentsWithOptions(collection, new JsonObject(), null, this.onSuccess(v2 -> {
            this.assertEquals(10L, v2.getRemovedCount());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testRemoveWithOptionsWithMongoClientDeleteResultAcknowledge() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(v -> this.mongoClient.removeDocumentsWithOptions(collection, new JsonObject(), WriteOption.ACKNOWLEDGED, this.onSuccess(v2 -> {
            this.assertEquals(10L, v2.getRemovedCount());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testRemoveWithOptionsWithMongoClientDeleteResultUnacknowledge() throws Exception {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 10, (Handler<AsyncResult<Void>>)this.onSuccess(v -> this.mongoClient.removeDocumentsWithOptions(collection, new JsonObject(), WriteOption.UNACKNOWLEDGED, this.onSuccess(v2 -> {
            this.assertNull(v2);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testNonStringID() {
        String collection = this.randomCollection();
        JsonObject document = new JsonObject().put("title", (Object)"The Hobbit");
        document.put("_id", (Object)123456);
        document.put("foo", (Object)"bar");
        this.mongoClient.insert(collection, document, this.onSuccess(id -> this.mongoClient.findOne(collection, new JsonObject(), null, this.onSuccess(retrieved -> {
            this.assertEquals(document, retrieved);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testContexts() {
        this.vertx.runOnContext(v -> {
            Context currentContext = Vertx.currentContext();
            this.assertNotNull(currentContext);
            String collection = this.randomCollection();
            JsonObject document = new JsonObject().put("title", (Object)"The Hobbit");
            document.put("_id", (Object)123456);
            document.put("foo", (Object)"bar");
            this.mongoClient.insert(collection, document, this.onSuccess(id -> {
                Context resultContext = Vertx.currentContext();
                this.assertSame(currentContext, resultContext);
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testBulkOperation_insertDocument() {
        String collection = this.randomCollection();
        JsonObject doc = this.createDoc();
        this.mongoClient.bulkWrite(collection, Arrays.asList(BulkOperation.createInsert((JsonObject)doc)), this.onSuccess(bulkResult -> {
            this.assertEquals(1L, bulkResult.getInsertedCount());
            this.assertEquals(0L, bulkResult.getModifiedCount());
            this.assertEquals(0L, bulkResult.getDeletedCount());
            this.assertEquals(0L, bulkResult.getMatchedCount());
            this.mongoClient.find(collection, new JsonObject(), this.onSuccess(docs -> {
                this.assertEquals(1L, docs.size());
                JsonObject foundDoc = (JsonObject)docs.get(0);
                doc.put("_id", (Object)foundDoc.getString("_id"));
                this.assertEquals(foundDoc, doc);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_insertDocuments() {
        String collection = this.randomCollection();
        JsonObject doc1 = new JsonObject().put("foo", (Object)"bar");
        JsonObject doc2 = new JsonObject().put("foo", (Object)"foobar");
        this.mongoClient.bulkWrite(collection, Arrays.asList(BulkOperation.createInsert((JsonObject)doc1), BulkOperation.createInsert((JsonObject)doc2)), this.onSuccess(bulkResult -> {
            this.assertEquals(2L, bulkResult.getInsertedCount());
            this.assertEquals(0L, bulkResult.getModifiedCount());
            this.assertEquals(0L, bulkResult.getDeletedCount());
            this.assertEquals(0L, bulkResult.getMatchedCount());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_updateDocument() {
        String collection = this.randomCollection();
        JsonObject doc = new JsonObject().put("foo", (Object)"bar");
        this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
            JsonObject update = new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"foobar"));
            JsonObject filter = new JsonObject();
            if (this.useObjectId) {
                filter.put("_id", (Object)new JsonObject().put("$oid", id));
            } else {
                filter.put("_id", id);
            }
            this.mongoClient.bulkWrite(collection, Arrays.asList(BulkOperation.createUpdate((JsonObject)filter, (JsonObject)update)), this.onSuccess(bulkResult -> {
                this.assertEquals(1L, bulkResult.getModifiedCount());
                this.assertEquals(0L, bulkResult.getDeletedCount());
                this.assertEquals(0L, bulkResult.getInsertedCount());
                this.assertEquals(1L, bulkResult.getMatchedCount());
                this.mongoClient.find(collection, new JsonObject(), this.onSuccess(docs -> {
                    this.assertEquals(1L, docs.size());
                    JsonObject foundDoc = (JsonObject)docs.get(0);
                    this.assertEquals("foobar", foundDoc.getString("foo"));
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_updateMultipleDocuments() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 5, (Handler<AsyncResult<Void>>)this.onSuccess(v -> {
            JsonObject update = new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"foobar-bulk"));
            JsonObject filter = new JsonObject();
            BulkOperation bulkUpdate = BulkOperation.createUpdate((JsonObject)filter, (JsonObject)update).setMulti(true);
            this.mongoClient.bulkWrite(collection, Arrays.asList(bulkUpdate), this.onSuccess(bulkResult -> {
                this.assertEquals(5L, bulkResult.getModifiedCount());
                this.assertEquals(5L, bulkResult.getMatchedCount());
                this.assertEquals(0L, bulkResult.getDeletedCount());
                this.assertEquals(0L, bulkResult.getInsertedCount());
                this.mongoClient.find(collection, new JsonObject(), this.onSuccess(docs -> {
                    this.assertEquals(5L, docs.size());
                    for (JsonObject foundDoc : docs) {
                        this.assertEquals("foobar-bulk", foundDoc.getString("foo"));
                    }
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_updateMultipleDocuments_multiFalse() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 5, (Handler<AsyncResult<Void>>)this.onSuccess(v -> {
            JsonObject update = new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"foobar-bulk"));
            JsonObject filter = new JsonObject();
            BulkOperation bulkUpdate = BulkOperation.createUpdate((JsonObject)filter, (JsonObject)update).setMulti(false);
            this.mongoClient.bulkWrite(collection, Arrays.asList(bulkUpdate), this.onSuccess(bulkResult -> {
                this.assertEquals(1L, bulkResult.getModifiedCount());
                this.assertEquals(0L, bulkResult.getDeletedCount());
                this.assertEquals(0L, bulkResult.getInsertedCount());
                this.assertEquals(1L, bulkResult.getMatchedCount());
                this.mongoClient.find(collection, new JsonObject().put("foo", (Object)"foobar-bulk"), this.onSuccess(docs -> {
                    this.assertEquals(1L, docs.size());
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_upsertDocument() {
        String collection = this.randomCollection();
        JsonObject doc = new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"bar"));
        BulkOperation bulkUpdate = BulkOperation.createUpdate((JsonObject)new JsonObject().put("foo", (Object)"bur"), (JsonObject)doc).setUpsert(true);
        this.mongoClient.bulkWrite(collection, Arrays.asList(bulkUpdate), this.onSuccess(bulkResult -> {
            this.assertEquals(0L, bulkResult.getInsertedCount());
            this.assertEquals(0L, bulkResult.getDeletedCount());
            this.assertEquals(0L, bulkResult.getModifiedCount());
            this.assertEquals(0L, bulkResult.getMatchedCount());
            List upserts = bulkResult.getUpserts();
            this.assertNotNull(upserts);
            this.assertEquals(1L, upserts.size());
            JsonObject upsert = (JsonObject)upserts.get(0);
            this.assertEquals(0L, upsert.getInteger("index").intValue());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_upsertDocument_upsertDisabled() {
        String collection = this.randomCollection();
        JsonObject doc = new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"bar"));
        BulkOperation bulkUpdate = BulkOperation.createUpdate((JsonObject)new JsonObject().put("foo", (Object)"bur"), (JsonObject)doc).setUpsert(false);
        this.mongoClient.bulkWrite(collection, Arrays.asList(bulkUpdate), this.onSuccess(bulkResult -> {
            this.assertEquals(0L, bulkResult.getInsertedCount());
            this.assertEquals(0L, bulkResult.getModifiedCount());
            this.assertEquals(0L, bulkResult.getDeletedCount());
            this.assertEquals(0L, bulkResult.getMatchedCount());
            this.assertEquals(0L, bulkResult.getUpserts().size());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_replace() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 1, (Handler<AsyncResult<Void>>)this.onSuccess(v -> {
            JsonObject filter = new JsonObject().put("num", (Object)123);
            JsonObject replace = new JsonObject().put("foo", (Object)"replaced");
            BulkOperation bulkReplace = BulkOperation.createReplace((JsonObject)filter, (JsonObject)replace);
            this.mongoClient.bulkWrite(collection, Arrays.asList(bulkReplace), this.onSuccess(bulkResult -> {
                this.assertEquals(0L, bulkResult.getInsertedCount());
                this.assertEquals(1L, bulkResult.getModifiedCount());
                this.assertEquals(0L, bulkResult.getDeletedCount());
                this.assertEquals(1L, bulkResult.getMatchedCount());
                this.assertEquals(0L, bulkResult.getUpserts().size());
                this.mongoClient.find(collection, new JsonObject(), this.onSuccess(docs -> {
                    this.assertEquals(1L, docs.size());
                    JsonObject foundDoc = (JsonObject)docs.get(0);
                    this.assertEquals("replaced", foundDoc.getString("foo"));
                    this.assertNull(foundDoc.getInteger("num"));
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_replaceById() {
        String collection = this.randomCollection();
        this.mongoClient.createCollection(collection, this.onSuccess(res -> {
            JsonObject doc = new JsonObject();
            doc.put("foo", (Object)"bar");
            doc.put("num", (Object)123);
            this.mongoClient.insert(collection, doc, this.onSuccess(id -> {
                JsonObject filter = new JsonObject().put("_id", id);
                JsonObject replace = new JsonObject().put("foo", (Object)"replaced");
                BulkOperation bulkReplace = BulkOperation.createReplace((JsonObject)filter, (JsonObject)replace);
                this.mongoClient.bulkWrite(collection, Arrays.asList(bulkReplace), this.onSuccess(bulkResult -> {
                    this.assertEquals(0L, bulkResult.getInsertedCount());
                    this.assertEquals(0L, bulkResult.getDeletedCount());
                    this.assertEquals(1L, bulkResult.getMatchedCount());
                    this.assertEquals(0L, bulkResult.getUpserts().size());
                    this.mongoClient.find(collection, new JsonObject(), this.onSuccess(docs -> {
                        this.assertEquals(1L, docs.size());
                        JsonObject foundDoc = (JsonObject)docs.get(0);
                        this.assertEquals("replaced", foundDoc.getString("foo"));
                        this.assertNull(foundDoc.getInteger("num"));
                        this.testComplete();
                    }));
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_replaceOne_upsert() {
        String collection = this.randomCollection();
        JsonObject filter = new JsonObject().put("foo", (Object)"bar");
        JsonObject replace = new JsonObject().put("foo", (Object)"upsert");
        BulkOperation bulkReplace = BulkOperation.createReplace((JsonObject)filter, (JsonObject)replace, (boolean)true);
        this.mongoClient.bulkWrite(collection, Arrays.asList(bulkReplace), this.onSuccess(bulkResult -> {
            this.assertEquals(0L, bulkResult.getInsertedCount());
            this.assertEquals(0L, bulkResult.getDeletedCount());
            this.assertEquals(0L, bulkResult.getModifiedCount());
            this.assertEquals(0L, bulkResult.getMatchedCount());
            this.assertEquals(1L, bulkResult.getUpserts().size());
            this.assertEquals(0L, ((JsonObject)bulkResult.getUpserts().get(0)).getInteger("index").intValue());
            this.mongoClient.find(collection, new JsonObject(), this.onSuccess(docs -> {
                this.assertEquals(1L, docs.size());
                JsonObject foundDoc = (JsonObject)docs.get(0);
                this.assertEquals("upsert", foundDoc.getString("foo"));
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_delete_multiDisabled() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 5, (Handler<AsyncResult<Void>>)this.onSuccess(v -> {
            JsonObject filter = new JsonObject().put("num", (Object)123);
            BulkOperation bulkDelete = BulkOperation.createDelete((JsonObject)filter).setMulti(false);
            this.mongoClient.bulkWrite(collection, Arrays.asList(bulkDelete), this.onSuccess(bulkResult -> {
                this.assertEquals(0L, bulkResult.getInsertedCount());
                this.assertEquals(1L, bulkResult.getDeletedCount());
                this.assertEquals(0L, bulkResult.getModifiedCount());
                this.assertEquals(0L, bulkResult.getMatchedCount());
                this.assertEquals(0L, bulkResult.getUpserts().size());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_delete_multiEnabled() {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 5, (Handler<AsyncResult<Void>>)this.onSuccess(v -> {
            JsonObject filter = new JsonObject().put("num", (Object)123);
            BulkOperation bulkDelete = BulkOperation.createDelete((JsonObject)filter).setMulti(true);
            this.mongoClient.bulkWrite(collection, Arrays.asList(bulkDelete), this.onSuccess(bulkResult -> {
                this.assertEquals(0L, bulkResult.getInsertedCount());
                this.assertEquals(5L, bulkResult.getDeletedCount());
                this.assertEquals(0L, bulkResult.getModifiedCount());
                this.assertEquals(0L, bulkResult.getMatchedCount());
                this.assertEquals(0L, bulkResult.getUpserts().size());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testBulkOperation_completeBulk() {
        this.testCompleteBulk(null);
    }

    @Test
    public void testBulkOperation_completeBulk_unacknowleged() {
        this.testCompleteBulk(new BulkWriteOptions().setWriteOption(WriteOption.UNACKNOWLEDGED));
    }

    @Test
    public void testBulkOperationwithOptions_completeBulk_orderedFalse() {
        this.testCompleteBulk(new BulkWriteOptions(false));
    }

    @Test
    public void testBulkOperationwithOptions_completeBulk_orderedTrue() {
        this.testCompleteBulk(new BulkWriteOptions(true));
    }

    private void testCompleteBulk(BulkWriteOptions bulkWriteOptions) {
        String collection = this.randomCollection();
        this.insertDocs(this.mongoClient, collection, 5, (Handler<AsyncResult<Void>>)this.onSuccess(v -> {
            BulkOperation bulkInsert = BulkOperation.createInsert((JsonObject)new JsonObject().put("foo", (Object)"insert"));
            BulkOperation bulkUpdate = BulkOperation.createUpdate((JsonObject)new JsonObject().put("foo", (Object)"bar1"), (JsonObject)new JsonObject().put("$set", (Object)new JsonObject().put("foo", (Object)"update")));
            BulkOperation bulkReplace = BulkOperation.createReplace((JsonObject)new JsonObject().put("foo", (Object)"bar2"), (JsonObject)new JsonObject().put("foo", (Object)"replace"));
            BulkOperation bulkDelete = BulkOperation.createDelete((JsonObject)new JsonObject().put("foo", (Object)"bar3"));
            Handler successHandler = this.onSuccess(bulkResult -> {
                if (bulkWriteOptions != null && bulkWriteOptions.getWriteOption() == WriteOption.UNACKNOWLEDGED) {
                    this.assertNull(bulkResult);
                    this.testComplete();
                } else {
                    this.assertEquals(1L, bulkResult.getInsertedCount());
                    this.assertEquals(1L, bulkResult.getDeletedCount());
                    this.assertEquals(2L, bulkResult.getModifiedCount());
                    this.assertEquals(2L, bulkResult.getMatchedCount());
                    this.assertEquals(0L, bulkResult.getUpserts().size());
                    this.mongoClient.find(collection, new JsonObject(), this.onSuccess(docs -> {
                        List values = docs.stream().map(doc -> doc.getString("foo")).collect(Collectors.toList());
                        this.assertTrue(values.contains("insert"));
                        this.assertFalse(values.contains("bar1"));
                        this.assertTrue(values.contains("update"));
                        this.assertFalse(values.contains("bar2"));
                        this.assertTrue(values.contains("replace"));
                        this.assertFalse(values.contains("bar3"));
                        this.testComplete();
                    }));
                }
            });
            if (bulkWriteOptions == null) {
                this.mongoClient.bulkWrite(collection, Arrays.asList(bulkInsert, bulkUpdate, bulkReplace, bulkDelete), successHandler);
            } else {
                this.mongoClient.bulkWriteWithOptions(collection, Arrays.asList(bulkInsert, bulkUpdate, bulkReplace, bulkDelete), bulkWriteOptions, successHandler);
            }
        }));
        this.await();
    }
}

