/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.test.core.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MongoClientDeleteResultTest {
    @Test
    public void testMongoClientDeleteResultWithRemovedCountSpecified() {
        long randomRemoved = TestUtils.randomLong();
        MongoClientDeleteResult mongoClientDeleteResult = new MongoClientDeleteResult(randomRemoved);
        Assert.assertEquals((long)randomRemoved, (long)mongoClientDeleteResult.getRemovedCount());
    }

    @Test
    public void testDefaultMongoClientDeleteResult() {
        MongoClientDeleteResult mongoClientDeleteResult = new MongoClientDeleteResult();
        Assert.assertEquals((long)0L, (long)mongoClientDeleteResult.getRemovedCount());
    }

    @Test
    public void testCopyMongoClientDeleteResult() {
        MongoClientDeleteResult origin = new MongoClientDeleteResult(TestUtils.randomLong());
        MongoClientDeleteResult copy = new MongoClientDeleteResult(origin);
        Assert.assertEquals((long)origin.getRemovedCount(), (long)copy.getRemovedCount());
    }

    @Test
    public void testJsonMongoClientDeleteResult() {
        this.properJson();
        this.jsonWithoutRequiredField();
    }

    private void jsonWithoutRequiredField() {
        JsonObject jsonObject = new JsonObject();
        MongoClientDeleteResult mongoClientDeleteResult = new MongoClientDeleteResult(jsonObject);
        Assert.assertEquals((long)0L, (long)mongoClientDeleteResult.getRemovedCount());
    }

    private void properJson() {
        JsonObject randomMongoClientDeleteResultJson = MongoClientDeleteResultTest.randomMongoClientDeleteResultJson();
        MongoClientDeleteResult mongoClientDeleteResult = new MongoClientDeleteResult(randomMongoClientDeleteResultJson);
        Assert.assertEquals((long)randomMongoClientDeleteResultJson.getLong("removed_count", Long.valueOf(0L)), (long)mongoClientDeleteResult.getRemovedCount());
    }

    @Test
    public void testToJsonMongoClientDeleteResult() {
        JsonObject randomMongoClientDeleteJson = MongoClientDeleteResultTest.randomMongoClientDeleteResultJson();
        MongoClientDeleteResult mongoClientDeleteResult = new MongoClientDeleteResult(randomMongoClientDeleteJson);
        Assert.assertEquals((Object)randomMongoClientDeleteJson, (Object)mongoClientDeleteResult.toJson());
    }

    @Test
    public void testMongoClientDeleteResultEquality() {
        this.logicallyEqual();
        this.logicallyUnequal();
    }

    private void logicallyUnequal() {
        MongoClientDeleteResult mongoClientDeleteResult1 = new MongoClientDeleteResult(23L);
        MongoClientDeleteResult mongoClientDeleteResult2 = new MongoClientDeleteResult(55L);
        Assert.assertFalse((boolean)mongoClientDeleteResult1.equals((Object)mongoClientDeleteResult2));
        Assert.assertFalse((boolean)mongoClientDeleteResult2.equals((Object)mongoClientDeleteResult1));
    }

    private void logicallyEqual() {
        long randomRemoved = TestUtils.randomLong();
        MongoClientDeleteResult mongoClientDeleteResult1 = new MongoClientDeleteResult(randomRemoved);
        MongoClientDeleteResult mongoClientDeleteResult2 = new MongoClientDeleteResult(randomRemoved);
        Assert.assertTrue((boolean)mongoClientDeleteResult1.equals((Object)mongoClientDeleteResult2));
        Assert.assertTrue((boolean)mongoClientDeleteResult2.equals((Object)mongoClientDeleteResult1));
    }

    private static JsonObject randomMongoClientDeleteResultJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("removed_count", (Object)TestUtils.randomLong());
        return jsonObject;
    }
}

