/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.test.core.TestUtils;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MongoClientBulkWriteResultTest {
    @Test
    public void testMongoClientBulkWriteStatuses() {
        long randomMatched = TestUtils.randomLong();
        long randomModified = TestUtils.randomLong();
        long randomInserted = TestUtils.randomLong();
        long randomDeleted = TestUtils.randomLong();
        List<JsonObject> upserts = this.randomUpsertIds();
        MongoClientBulkWriteResult mongoClientBulkWriteResult = new MongoClientBulkWriteResult(randomInserted, randomMatched, randomDeleted, randomModified, upserts);
        Assert.assertEquals((long)randomMatched, (long)mongoClientBulkWriteResult.getMatchedCount());
        Assert.assertEquals((long)randomModified, (long)mongoClientBulkWriteResult.getModifiedCount());
        Assert.assertEquals((long)randomInserted, (long)mongoClientBulkWriteResult.getInsertedCount());
        Assert.assertEquals((long)randomDeleted, (long)mongoClientBulkWriteResult.getDeletedCount());
        Assert.assertEquals(upserts, (Object)mongoClientBulkWriteResult.getUpserts());
    }

    @Test
    public void testDefaultMongoClientBulkWriteResult() {
        MongoClientBulkWriteResult mongoClientBulkWriteResult = new MongoClientBulkWriteResult();
        Assert.assertEquals((long)0L, (long)mongoClientBulkWriteResult.getMatchedCount());
        Assert.assertEquals((long)0L, (long)mongoClientBulkWriteResult.getModifiedCount());
        Assert.assertEquals((long)0L, (long)mongoClientBulkWriteResult.getInsertedCount());
        Assert.assertEquals((long)0L, (long)mongoClientBulkWriteResult.getDeletedCount());
        Assert.assertNull((Object)mongoClientBulkWriteResult.getUpserts());
    }

    @Test
    public void testCopyMongoClientBulkWriteResult() {
        MongoClientBulkWriteResult mongoClientBulkWriteResultOrigin = new MongoClientBulkWriteResult(TestUtils.randomLong(), TestUtils.randomLong(), TestUtils.randomLong(), TestUtils.randomLong(), this.randomUpsertIds());
        MongoClientBulkWriteResult mongoClientBulkWriteResultCopy = new MongoClientBulkWriteResult(mongoClientBulkWriteResultOrigin);
        Assert.assertEquals((long)mongoClientBulkWriteResultCopy.getMatchedCount(), (long)mongoClientBulkWriteResultOrigin.getMatchedCount());
        Assert.assertEquals((long)mongoClientBulkWriteResultCopy.getModifiedCount(), (long)mongoClientBulkWriteResultOrigin.getModifiedCount());
        Assert.assertEquals((long)mongoClientBulkWriteResultCopy.getInsertedCount(), (long)mongoClientBulkWriteResultOrigin.getInsertedCount());
        Assert.assertEquals((long)mongoClientBulkWriteResultCopy.getDeletedCount(), (long)mongoClientBulkWriteResultOrigin.getDeletedCount());
        Assert.assertEquals((Object)mongoClientBulkWriteResultCopy.getUpserts(), (Object)mongoClientBulkWriteResultOrigin.getUpserts());
    }

    @Test
    public void testJsonMongoClientBulkWriteResult() {
        this.properJson();
        this.jsonWithoutRequiredFields();
    }

    private void jsonWithoutRequiredFields() {
        JsonObject mongoClientBulkWriteResultJson = new JsonObject();
        MongoClientBulkWriteResult mongoClientBulkWriteResult = new MongoClientBulkWriteResult(mongoClientBulkWriteResultJson);
        Assert.assertEquals((long)0L, (long)mongoClientBulkWriteResult.getMatchedCount());
        Assert.assertEquals((long)0L, (long)mongoClientBulkWriteResult.getModifiedCount());
        Assert.assertEquals((long)0L, (long)mongoClientBulkWriteResult.getInsertedCount());
        Assert.assertEquals((long)0L, (long)mongoClientBulkWriteResult.getDeletedCount());
        Assert.assertNull((Object)mongoClientBulkWriteResult.getUpserts());
    }

    private void properJson() {
        JsonObject mongoClientBulkWriteResultJson = this.randomMongoClientBulkWriteResultJson();
        MongoClientBulkWriteResult mongoClientBulkWriteResult = new MongoClientBulkWriteResult(mongoClientBulkWriteResultJson);
        Assert.assertEquals((long)mongoClientBulkWriteResultJson.getLong("deletedCount", Long.valueOf(0L)), (long)mongoClientBulkWriteResult.getDeletedCount());
        Assert.assertEquals((long)mongoClientBulkWriteResultJson.getLong("insertedCount", Long.valueOf(0L)), (long)mongoClientBulkWriteResult.getInsertedCount());
        Assert.assertEquals((long)mongoClientBulkWriteResultJson.getLong("matchedCount", Long.valueOf(0L)), (long)mongoClientBulkWriteResult.getMatchedCount());
        Assert.assertEquals((long)mongoClientBulkWriteResultJson.getLong("modifiedCount", Long.valueOf(0L)), (long)mongoClientBulkWriteResult.getModifiedCount());
        JsonArray upserts = mongoClientBulkWriteResultJson.getJsonArray("upserts", null);
        Assert.assertEquals((Object)(upserts != null ? upserts.getList() : null), (Object)mongoClientBulkWriteResult.getUpserts());
    }

    @Test
    public void testToJsonMongoClientBulkWriteResult() {
        JsonObject mongoClientBulkWriteResultJson = this.randomMongoClientBulkWriteResultJson();
        MongoClientBulkWriteResult mongoClientBulkWriteResult = new MongoClientBulkWriteResult(mongoClientBulkWriteResultJson);
        Assert.assertEquals((Object)mongoClientBulkWriteResultJson, (Object)mongoClientBulkWriteResult.toJson());
    }

    @Test
    public void testMongoBulkWriteResultEquality() {
        this.logicallyUnequal();
        this.logicallyEqual();
    }

    private void logicallyEqual() {
        long randomMatched = TestUtils.randomLong();
        long randomModified = TestUtils.randomLong();
        long randomInserted = TestUtils.randomLong();
        long randomDeleted = TestUtils.randomLong();
        List<JsonObject> upserts = this.randomUpsertIds();
        MongoClientBulkWriteResult mongoClientBulkWriteResult1 = new MongoClientBulkWriteResult(randomInserted, randomMatched, randomDeleted, randomModified, upserts);
        MongoClientBulkWriteResult mongoClientBulkWriteResult2 = new MongoClientBulkWriteResult(randomInserted, randomMatched, randomDeleted, randomModified, upserts);
        Assert.assertTrue((boolean)mongoClientBulkWriteResult1.equals((Object)mongoClientBulkWriteResult2));
        Assert.assertTrue((boolean)mongoClientBulkWriteResult2.equals((Object)mongoClientBulkWriteResult1));
    }

    private void logicallyUnequal() {
        MongoClientBulkWriteResult mongoClientBulkWriteResult1 = new MongoClientBulkWriteResult(123L, 456L, 789L, 135L, this.randomUpsertIds());
        MongoClientBulkWriteResult mongoClientBulkWriteResult2 = new MongoClientBulkWriteResult(456L, 789L, 135L, 123L, this.randomUpsertIds());
        Assert.assertFalse((boolean)mongoClientBulkWriteResult1.equals((Object)mongoClientBulkWriteResult2));
        Assert.assertFalse((boolean)mongoClientBulkWriteResult2.equals((Object)mongoClientBulkWriteResult1));
    }

    private JsonObject randomMongoClientBulkWriteResultJson() {
        JsonObject mongoClientBulkWriteResultJson = new JsonObject();
        mongoClientBulkWriteResultJson.put("deletedCount", (Object)TestUtils.randomLong());
        mongoClientBulkWriteResultJson.put("insertedCount", (Object)TestUtils.randomLong());
        mongoClientBulkWriteResultJson.put("matchedCount", (Object)TestUtils.randomLong());
        mongoClientBulkWriteResultJson.put("modifiedCount", (Object)TestUtils.randomLong());
        mongoClientBulkWriteResultJson.put("upserts", this.randomUpsertIds());
        return mongoClientBulkWriteResultJson;
    }

    private List<JsonObject> randomUpsertIds() {
        return Arrays.asList(this.randomUpsertId(), this.randomUpsertId());
    }

    private JsonObject randomUpsertId() {
        return new JsonObject().put("_id", (Object)TestUtils.randomAlphaString((int)23)).put("index", (Object)TestUtils.randomInt());
    }
}

