/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.IndexOptions;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class IndexOptionsTest {
    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new IndexOptions(), (Object)new IndexOptions());
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.background(true);
            b.background(false);
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.unique(true);
            b.unique(false);
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.name("a");
            b.name("b");
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.sparse(true);
            b.sparse(false);
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.expireAfter(Long.valueOf(4L), TimeUnit.SECONDS);
            b.expireAfter(Long.valueOf(3L), TimeUnit.SECONDS);
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.version(Integer.valueOf(1));
            b.version(Integer.valueOf(2));
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.weights(new JsonObject("{ \"f\": 3 }"));
            b.weights(new JsonObject());
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.defaultLanguage("en");
            b.defaultLanguage("de");
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.languageOverride("en");
            b.languageOverride("de");
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.textVersion(Integer.valueOf(2));
            b.textVersion(Integer.valueOf(1));
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.sphereVersion(Integer.valueOf(1));
            b.sphereVersion(Integer.valueOf(3));
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.bits(Integer.valueOf(5));
            b.bits(Integer.valueOf(6));
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.min(Double.valueOf(2.3));
            b.min(Double.valueOf(2.4));
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.max(Double.valueOf(3.2));
            b.max(Double.valueOf(3.3));
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.bucketSize(Double.valueOf(23.0));
            b.bucketSize(Double.valueOf(24.0));
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.storageEngine(new JsonObject("{ \"f\": 3 }"));
            b.storageEngine(new JsonObject());
        });
        IndexOptionsTest.assertNotEqual((a, b) -> {
            a.partialFilterExpression(new JsonObject("{ \"f\": 3 }"));
            b.partialFilterExpression(new JsonObject());
        });
        Assert.assertNotEquals((Object)new IndexOptions(), null);
    }

    @Test
    public void testHashCode() {
        IndexOptions a = new IndexOptions();
        int hash = a.hashCode();
        Assert.assertEquals((long)hash, (long)new IndexOptions().hashCode());
        IndexOptionsTest.assertNotEqual(hash, o -> o.background(true));
        IndexOptionsTest.assertNotEqual(hash, o -> o.unique(true));
        IndexOptionsTest.assertNotEqual(hash, o -> o.name("foobar"));
        IndexOptionsTest.assertNotEqual(hash, o -> o.sparse(true));
        IndexOptionsTest.assertNotEqual(hash, o -> o.expireAfter(Long.valueOf(6L), TimeUnit.SECONDS));
        IndexOptionsTest.assertNotEqual(hash, o -> o.version(Integer.valueOf(22)));
        IndexOptionsTest.assertNotEqual(hash, o -> o.weights(new JsonObject("{ \"f\": 42 }")));
        IndexOptionsTest.assertNotEqual(hash, o -> o.defaultLanguage("pl"));
        IndexOptionsTest.assertNotEqual(hash, o -> o.languageOverride("ru"));
        IndexOptionsTest.assertNotEqual(hash, o -> o.textVersion(Integer.valueOf(39)));
        IndexOptionsTest.assertNotEqual(hash, o -> o.sphereVersion(Integer.valueOf(31)));
        IndexOptionsTest.assertNotEqual(hash, o -> o.bits(Integer.valueOf(13)));
        IndexOptionsTest.assertNotEqual(hash, o -> o.min(Double.valueOf(2.5)));
        IndexOptionsTest.assertNotEqual(hash, o -> o.max(Double.valueOf(6.1)));
        IndexOptionsTest.assertNotEqual(hash, o -> o.bucketSize(Double.valueOf(12.0)));
        IndexOptionsTest.assertNotEqual(hash, o -> o.storageEngine(new JsonObject("{ \"f\": 12 }")));
        IndexOptionsTest.assertNotEqual(hash, o -> o.partialFilterExpression(new JsonObject("{ \"f\": 4 }")));
    }

    private static void assertNotEqual(BiConsumer<IndexOptions, IndexOptions> f) {
        IndexOptions a = new IndexOptions();
        IndexOptions b = new IndexOptions();
        f.accept(a, b);
        Assert.assertNotEquals((Object)a, (Object)b);
    }

    private static void assertNotEqual(int expected, Consumer<IndexOptions> f) {
        IndexOptions o = new IndexOptions();
        f.accept(o);
        Assert.assertNotEquals((long)expected, (long)o.hashCode());
    }
}

